/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import org.gradle.api.Action;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.routes.RoutesSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.twirl.TwirlSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.play.PlayApplicationSpec;

public class PlaySourceSetRules
extends RuleSource {
    @Defaults
    void createJvmSourceSets(PlayApplicationSpec playComponent) {
        playComponent.getSources().create("scala", ScalaLanguageSourceSet.class, (Action)new Action<ScalaLanguageSourceSet>(){

            public void execute(ScalaLanguageSourceSet scalaSources) {
                scalaSources.getSource().srcDir((Object)"app");
                scalaSources.getSource().include(new String[]{"**/*.scala"});
            }
        });
        playComponent.getSources().create("java", JavaSourceSet.class, (Action)new Action<JavaSourceSet>(){

            public void execute(JavaSourceSet javaSources) {
                javaSources.getSource().srcDir((Object)"app");
                javaSources.getSource().include(new String[]{"**/*.java"});
            }
        });
        playComponent.getSources().create("resources", JvmResourceSet.class, (Action)new Action<JvmResourceSet>(){

            public void execute(JvmResourceSet appResources) {
                appResources.getSource().srcDirs(new Object[]{"conf"});
            }
        });
    }

    @Defaults
    void createTwirlSourceSets(PlayApplicationSpec playComponent) {
        playComponent.getSources().create("twirlTemplates", TwirlSourceSet.class, (Action)new Action<TwirlSourceSet>(){

            public void execute(TwirlSourceSet twirlSourceSet) {
                twirlSourceSet.getSource().srcDir((Object)"app");
                twirlSourceSet.getSource().include(new String[]{"**/*.html"});
            }
        });
    }

    @Defaults
    void createRoutesSourceSets(PlayApplicationSpec playComponent) {
        playComponent.getSources().create("routes", RoutesSourceSet.class, (Action)new Action<RoutesSourceSet>(){

            public void execute(RoutesSourceSet routesSourceSet) {
                routesSourceSet.getSource().srcDir((Object)"conf");
                routesSourceSet.getSource().include(new String[]{"routes"});
                routesSourceSet.getSource().include(new String[]{"*.routes"});
            }
        });
    }
}

