/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.twirl.TwirlCompileSpec;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaOptionInvocationWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwirlCompiler
implements Compiler<TwirlCompileSpec>,
Serializable {
    private final VersionedTwirlCompilerAdapter adapter;

    public TwirlCompiler(VersionedTwirlCompilerAdapter adapter) {
        this.adapter = adapter;
    }

    public WorkResult execute(TwirlCompileSpec spec) {
        ArrayList outputFiles = Lists.newArrayList();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            ScalaMethod compile = this.adapter.getCompileMethod(cl);
            Iterable<RelativeFile> sources = spec.getSources();
            for (RelativeFile sourceFile : sources) {
                Object result = compile.invoke(this.adapter.createCompileParameters(cl, sourceFile.getFile(), sourceFile.getBaseDir(), spec.getDestinationDir(), spec.isJavaProject()));
                ScalaOptionInvocationWrapper maybeFile = new ScalaOptionInvocationWrapper(result);
                if (!maybeFile.isDefined()) continue;
                outputFiles.add(maybeFile.get());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking Play Twirl template compiler.", e);
        }
        return new SimpleWorkResult(!outputFiles.isEmpty());
    }

    public Object getDependencyNotation() {
        return this.adapter.getDependencyNotation();
    }

    public Iterable<String> getClassLoaderPackages() {
        return this.adapter.getClassLoaderPackages();
    }
}

