/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Strings;
import java.util.Collections;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.LocalComponentDependencyMetaData;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.ModuleDependencySpec;
import org.gradle.platform.base.ProjectDependencySpec;
import org.gradle.platform.base.internal.DefaultModuleDependencySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLibraryLocalComponentMetaData
extends DefaultLocalComponentMetaData {
    private static final String VERSION = "<local component>";
    private static final ExcludeRule[] EXCLUDE_RULES = new ExcludeRule[0];
    private static final String CONFIGURATION_COMPILE = "compile";

    public static DefaultLibraryLocalComponentMetaData newDefaultLibraryLocalComponentMetadata(LibraryBinaryIdentifier componentId, TaskDependency buildDependencies, Iterable<DependencySpec> dependencies, String defaultProject) {
        DefaultLibraryLocalComponentMetaData metadata = DefaultLibraryLocalComponentMetaData.newDefaultLibraryLocalComponentMetadata(componentId, buildDependencies);
        metadata.addDependencies(dependencies, defaultProject);
        return metadata;
    }

    private static DefaultLibraryLocalComponentMetaData newDefaultLibraryLocalComponentMetadata(LibraryBinaryIdentifier componentId, TaskDependency buildDependencies) {
        DefaultLibraryLocalComponentMetaData metaData = new DefaultLibraryLocalComponentMetaData((ModuleVersionIdentifier)DefaultLibraryLocalComponentMetaData.localModuleVersionIdentifierFor(componentId), (ComponentIdentifier)componentId);
        metaData.addConfiguration("API", String.format("Request metadata: %s", componentId.getDisplayName()), Collections.emptySet(), Collections.singleton("API"), true, true, buildDependencies);
        return metaData;
    }

    private static DefaultModuleVersionIdentifier localModuleVersionIdentifierFor(LibraryBinaryIdentifier componentId) {
        return new DefaultModuleVersionIdentifier(componentId.getProjectPath(), componentId.getLibraryName(), VERSION);
    }

    private DefaultLibraryLocalComponentMetaData(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier) {
        super(id, componentIdentifier, "release");
    }

    private void addDependencies(Iterable<DependencySpec> dependencies, String projectPath) {
        for (DependencySpec dependency : dependencies) {
            this.addDependency(dependency, projectPath);
        }
    }

    private void addDependency(DependencySpec dependency, String defaultProject) {
        DependencyMetaData metadata = dependency instanceof ModuleDependencySpec ? this.moduleDependencyMetadata((ModuleDependencySpec)dependency) : this.projectDependencyMetadata((ProjectDependencySpec)dependency, defaultProject);
        this.addDependency(metadata);
    }

    private DependencyMetaData moduleDependencyMetadata(ModuleDependencySpec moduleDependency) {
        ModuleVersionSelector requested = this.moduleVersionSelectorFrom(moduleDependency);
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector((ModuleVersionSelector)requested);
        return this.dependencyMetadataFor((ComponentSelector)selector, requested, CONFIGURATION_COMPILE);
    }

    private DependencyMetaData projectDependencyMetadata(ProjectDependencySpec projectDependency, String defaultProject) {
        String projectPath = projectDependency.getProjectPath();
        if (Strings.isNullOrEmpty((String)projectPath)) {
            projectPath = defaultProject;
        }
        String libraryName = projectDependency.getLibraryName();
        DefaultLibraryComponentSelector selector = new DefaultLibraryComponentSelector(projectPath, libraryName);
        DefaultModuleVersionSelector requested = new DefaultModuleVersionSelector(Strings.nullToEmpty((String)projectPath), Strings.nullToEmpty((String)libraryName), this.getId().getVersion());
        return this.dependencyMetadataFor((ComponentSelector)selector, (ModuleVersionSelector)requested, "API");
    }

    private ModuleVersionSelector moduleVersionSelectorFrom(ModuleDependencySpec module) {
        return new DefaultModuleVersionSelector(module.getGroup(), module.getName(), DefaultModuleDependencySpec.effectiveVersionFor(module.getVersion()));
    }

    private DependencyMetaData dependencyMetadataFor(ComponentSelector selector, ModuleVersionSelector requested, String configuration) {
        return new LocalComponentDependencyMetaData(selector, requested, "API", configuration, Collections.emptySet(), EXCLUDE_RULES, false, false, true);
    }
}

