/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import java.io.File;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.internal.DefaultReportContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskReportContainer<T extends Report>
extends DefaultReportContainer<T> {
    private final TaskInternal task;
    final Transformer<File, Report> toFile = new Transformer<File, Report>(){

        public File transform(Report original) {
            return original.getDestination();
        }
    };
    private static final Spec<Report> IS_DIRECTORY_OUTPUT_TYPE = new Spec<Report>(){

        public boolean isSatisfiedBy(Report report) {
            return report.getOutputType() == Report.OutputType.DIRECTORY;
        }
    };
    private static final Spec<Report> IS_FILE_OUTPUT_TYPE = Specs.not(IS_DIRECTORY_OUTPUT_TYPE);

    public TaskReportContainer(Class<? extends T> type, Task task) {
        super(type, (Instantiator)((ProjectInternal)task.getProject()).getServices().get(Instantiator.class));
        this.task = (TaskInternal)task;
    }

    protected Task getTask() {
        return this.task;
    }

    @OutputDirectories
    public Set<File> getEnabledDirectoryReportDestinations() {
        return CollectionUtils.collect((Set)CollectionUtils.filter(this.getEnabled(), IS_DIRECTORY_OUTPUT_TYPE), this.toFile);
    }

    @OutputFiles
    public Set<File> getEnabledFileReportDestinations() {
        return CollectionUtils.collect((Set)CollectionUtils.filter(this.getEnabled(), IS_FILE_OUTPUT_TYPE), this.toFile);
    }

    @Input
    public SortedSet<String> getEnabledReportNames() {
        return (SortedSet)CollectionUtils.collect(this.getEnabled(), new TreeSet(), (Transformer)new Transformer<String, Report>(){

            public String transform(Report report) {
                return report.getName();
            }
        });
    }
}

