/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.MethodMetaInfo;
import org.gradle.messaging.remote.internal.protocol.PayloadMessage;
import org.gradle.messaging.remote.internal.protocol.RemoteMethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationMarshallingDispatch
implements Dispatch<Message> {
    private final Dispatch<? super Message> dispatch;
    private final Map<Method, Integer> methods = new HashMap<Method, Integer>();
    private int nextKey;

    public MethodInvocationMarshallingDispatch(Dispatch<? super Message> dispatch) {
        this.dispatch = dispatch;
    }

    @Override
    public void dispatch(Message message) {
        if (!(message instanceof PayloadMessage)) {
            this.dispatch.dispatch(message);
            return;
        }
        PayloadMessage payloadMessage = (PayloadMessage)((Object)message);
        if (!(payloadMessage.getNestedPayload() instanceof MethodInvocation)) {
            this.dispatch.dispatch(message);
            return;
        }
        MethodInvocation methodInvocation = (MethodInvocation)payloadMessage.getNestedPayload();
        Method method = methodInvocation.getMethod();
        Integer key = this.methods.get(method);
        if (key == null) {
            key = this.nextKey++;
            this.methods.put(method, key);
            this.dispatch.dispatch(new MethodMetaInfo(key, method));
        }
        Message transformedMessage = payloadMessage.withNestedPayload(new RemoteMethodInvocation(key, methodInvocation.getArguments()));
        this.dispatch.dispatch(transformedMessage);
    }
}

