/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

public class HeapProportionalSizer {
    private static final int DEFAULT_SIZES_MAX_HEAP_MB = 910;
    private static final int ASSUMED_USED_HEAP = 150;
    private static final double MIN_RATIO = 0.2;
    private final int maxHeapMB;
    private final double sizingRatio;

    public HeapProportionalSizer(int maxHeapMB) {
        this.maxHeapMB = maxHeapMB;
        this.sizingRatio = this.calculateRatio();
    }

    public HeapProportionalSizer() {
        this(HeapProportionalSizer.calculateMaxHeapMB());
    }

    private static int calculateMaxHeapMB() {
        return (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
    }

    private double calculateRatio() {
        return Math.max((double)(this.maxHeapMB - 150) / 760.0, 0.2);
    }

    public int scaleValue(int referenceValue) {
        return this.scaleValue(referenceValue, 100);
    }

    public int scaleValue(int referenceValue, int granularity) {
        if (referenceValue < granularity) {
            throw new IllegalArgumentException("reference value must be larger than granularity");
        }
        return (int)((double)referenceValue * this.sizingRatio) / granularity * granularity;
    }
}

