/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;

public abstract class AbstractAuxiliaryCacheEventLogging<K, V>
extends AbstractAuxiliaryCache<K, V> {
    @Override
    public void update(ICacheElement<K, V> iCacheElement) throws IOException {
        this.updateWithEventLogging(iCacheElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateWithEventLogging(ICacheElement<K, V> iCacheElement) throws IOException {
        ICacheEvent<K> iCacheEvent = this.createICacheEvent(iCacheElement, "update");
        try {
            this.processUpdate(iCacheElement);
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected abstract void processUpdate(ICacheElement<K, V> var1) throws IOException;

    @Override
    public ICacheElement<K, V> get(K k) throws IOException {
        return this.getWithEventLogging(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ICacheElement<K, V> getWithEventLogging(K k) throws IOException {
        ICacheEvent<K> iCacheEvent = this.createICacheEvent(this.getCacheName(), k, "get");
        try {
            ICacheElement<K, V> iCacheElement = this.processGet(k);
            return iCacheElement;
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected abstract ICacheElement<K, V> processGet(K var1) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> set) throws IOException {
        return this.getMultipleWithEventLogging(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<K, ICacheElement<K, V>> getMultipleWithEventLogging(Set<K> set) throws IOException {
        ICacheEvent<Serializable> iCacheEvent = this.createICacheEvent(this.getCacheName(), (Serializable)((Object)set), "getMultiple");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMultiple(set);
            return map;
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected abstract Map<K, ICacheElement<K, V>> processGetMultiple(Set<K> var1) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String string) throws IOException {
        return this.getMatchingWithEventLogging(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<K, ICacheElement<K, V>> getMatchingWithEventLogging(String string) throws IOException {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(this.getCacheName(), string, "getMatching");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMatching(string);
            return map;
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected abstract Map<K, ICacheElement<K, V>> processGetMatching(String var1) throws IOException;

    @Override
    public boolean remove(K k) throws IOException {
        return this.removeWithEventLogging(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeWithEventLogging(K k) throws IOException {
        ICacheEvent<K> iCacheEvent = this.createICacheEvent(this.getCacheName(), k, "remove");
        try {
            boolean bl = this.processRemove(k);
            return bl;
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected abstract boolean processRemove(K var1) throws IOException;

    @Override
    public void removeAll() throws IOException {
        this.removeAllWithEventLogging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeAllWithEventLogging() throws IOException {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(this.getCacheName(), "all", "removeAll");
        try {
            this.processRemoveAll();
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected abstract void processRemoveAll() throws IOException;

    @Override
    public void dispose() throws IOException {
        this.disposeWithEventLogging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disposeWithEventLogging() throws IOException {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(this.getCacheName(), "none", "dispose");
        try {
            this.processDispose();
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected abstract void processDispose() throws IOException;
}

