/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;

public class SelectByInternalPointAction
extends JosmAction {
    public static Collection<OsmPrimitive> getSurroundingObjects(EastNorth eastNorth) {
        DataSet dataSet = SelectByInternalPointAction.getCurrentDataSet();
        if (dataSet == null) {
            return Collections.emptySet();
        }
        Node node = new Node(eastNorth);
        TreeMap<Double, OsmPrimitive> treeMap = new TreeMap<Double, OsmPrimitive>();
        for (Way osmPrimitive : dataSet.getWays()) {
            if (!osmPrimitive.isUsable() || !osmPrimitive.isClosed() || !osmPrimitive.isSelectable() || !Geometry.nodeInsidePolygon(node, osmPrimitive.getNodes())) continue;
            treeMap.put(Geometry.closedWayArea(osmPrimitive), osmPrimitive);
        }
        for (Relation relation : dataSet.getRelations()) {
            if (!relation.isUsable() || !relation.isMultipolygon() || !relation.isSelectable() || !Geometry.isNodeInsideMultiPolygon(node, relation, null)) continue;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.isWay() || !relationMember.getWay().isClosed()) continue;
                treeMap.values().remove(relationMember.getWay());
            }
            BBox bBox = relation.getBBox();
            EastNorth eastNorth2 = Main.map.mapView.getProjection().latlon2eastNorth(bBox.getTopLeft());
            EastNorth eastNorth3 = Main.map.mapView.getProjection().latlon2eastNorth(bBox.getBottomRight());
            double d = Math.abs((eastNorth2.east() - eastNorth3.east()) * (eastNorth2.north() - eastNorth3.north()));
            if (d == 0.0) {
                d = 1.0E8;
            }
            treeMap.put(d, relation);
        }
        return treeMap.values();
    }

    public static OsmPrimitive getSmallestSurroundingObject(EastNorth eastNorth) {
        Collection<OsmPrimitive> collection = SelectByInternalPointAction.getSurroundingObjects(eastNorth);
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static void performSelection(EastNorth eastNorth, boolean bl, boolean bl2) {
        Collection<OsmPrimitive> collection = SelectByInternalPointAction.getSurroundingObjects(eastNorth);
        if (collection.isEmpty()) {
            return;
        }
        if (bl2) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(SelectByInternalPointAction.getCurrentDataSet().getSelected());
            arrayList.removeAll(collection);
            SelectByInternalPointAction.getCurrentDataSet().setSelected(arrayList);
        } else if (bl) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(SelectByInternalPointAction.getCurrentDataSet().getSelected());
            arrayList.add(collection.iterator().next());
            SelectByInternalPointAction.getCurrentDataSet().setSelected(arrayList);
        } else {
            SelectByInternalPointAction.getCurrentDataSet().setSelected(collection.iterator().next());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        throw new UnsupportedOperationException();
    }
}

