/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public abstract class ConflictResolveCommand
extends Command {
    private final ConflictCollection resolvedConflicts = new ConflictCollection();

    public ConflictResolveCommand() {
    }

    public ConflictResolveCommand(OsmDataLayer osmDataLayer) {
        super(osmDataLayer);
    }

    protected void rememberConflict(Conflict<?> conflict) {
        if (!this.resolvedConflicts.hasConflictForMy((OsmPrimitive)conflict.getMy())) {
            this.resolvedConflicts.add(conflict);
        }
    }

    protected void reconstituteConflicts() {
        OsmDataLayer osmDataLayer = this.getLayer();
        for (Conflict<?> conflict : this.resolvedConflicts) {
            if (osmDataLayer.getConflicts().hasConflictForMy((OsmPrimitive)conflict.getMy())) continue;
            osmDataLayer.getConflicts().add(conflict);
        }
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        if (Main.isDisplayingMapView()) {
            if (!Main.map.mapView.hasLayer(this.getLayer())) {
                Main.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.getLayer().toString()));
                return;
            }
            Main.map.mapView.setActiveLayer(this.getLayer());
        }
        this.reconstituteConflicts();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.resolvedConflicts == null ? 0 : this.resolvedConflicts.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConflictResolveCommand conflictResolveCommand = (ConflictResolveCommand)object;
        return !(this.resolvedConflicts == null ? conflictResolveCommand.resolvedConflicts != null : !this.resolvedConflicts.equals(conflictResolveCommand.resolvedConflicts));
    }
}

