/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Line2D;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

public final class WaySegment
implements Comparable<WaySegment> {
    public Way way;
    public int lowerIndex;

    public WaySegment(Way way, int n) {
        this.way = way;
        this.lowerIndex = n;
    }

    public Node getFirstNode() {
        return this.way.getNode(this.lowerIndex);
    }

    public Node getSecondNode() {
        return this.way.getNode(this.lowerIndex + 1);
    }

    public static WaySegment forNodePair(Way way, Node node, Node node2) {
        for (int i = way.getNodesCount() - 1; i > 0; --i) {
            int n = way.getNodes().subList(0, i).lastIndexOf(node);
            if (!node2.equals(way.getNode(n + 1))) continue;
            return new WaySegment(way, n);
        }
        throw new IllegalArgumentException("Node pair is not part of way!");
    }

    public Way toWay() {
        Way way = new Way();
        way.addNode(this.getFirstNode());
        way.addNode(this.getSecondNode());
        return way;
    }

    public boolean equals(Object object) {
        return object instanceof WaySegment && ((WaySegment)object).way == this.way && ((WaySegment)object).lowerIndex == this.lowerIndex;
    }

    public int hashCode() {
        return this.way.hashCode() ^ this.lowerIndex;
    }

    @Override
    public int compareTo(WaySegment waySegment) {
        return this.equals(waySegment) ? 0 : this.toWay().compareTo(waySegment.toWay());
    }

    public boolean intersects(WaySegment waySegment) {
        if (this.getFirstNode().equals(waySegment.getFirstNode()) || this.getSecondNode().equals(waySegment.getSecondNode()) || this.getFirstNode().equals(waySegment.getSecondNode()) || this.getSecondNode().equals(waySegment.getFirstNode())) {
            return false;
        }
        return Line2D.linesIntersect(this.getFirstNode().getEastNorth().east(), this.getFirstNode().getEastNorth().north(), this.getSecondNode().getEastNorth().east(), this.getSecondNode().getEastNorth().north(), waySegment.getFirstNode().getEastNorth().east(), waySegment.getFirstNode().getEastNorth().north(), waySegment.getSecondNode().getEastNorth().east(), waySegment.getSecondNode().getEastNorth().north());
    }

    public String toString() {
        return "WaySegment [way=" + this.way.getUniqueId() + ", lowerIndex=" + this.lowerIndex + ']';
    }
}

