/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public class ConditionalKeys
extends Test.TagTest {
    private final OpeningHourTest openingHourTest = new OpeningHourTest();
    private static final Set<String> RESTRICTION_TYPES = new HashSet<String>(Arrays.asList("oneway", "toll", "noexit", "maxspeed", "minspeed", "maxstay", "maxweight", "maxaxleload", "maxheight", "maxwidth", "maxlength", "overtaking", "maxgcweight", "maxgcweightrating", "fee"));
    private static final Set<String> RESTRICTION_VALUES = new HashSet<String>(Arrays.asList("yes", "official", "designated", "destination", "delivery", "permissive", "private", "agricultural", "forestry", "no"));
    private static final Set<String> TRANSPORT_MODES = new HashSet<String>(Arrays.asList("access", "foot", "ski", "inline_skates", "ice_skates", "horse", "vehicle", "bicycle", "carriage", "trailer", "caravan", "motor_vehicle", "motorcycle", "moped", "mofa", "motorcar", "motorhome", "psv", "bus", "taxi", "tourist_bus", "goods", "hgv", "agricultural", "atv", "snowmobile"));

    public ConditionalKeys() {
        super(I18n.tr("Conditional Keys", new Object[0]), I18n.tr("Tests for the correct usage of ''*:conditional'' tags.", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.openingHourTest.initialize();
    }

    public static boolean isRestrictionType(String string) {
        return RESTRICTION_TYPES.contains(string);
    }

    public static boolean isRestrictionValue(String string) {
        return RESTRICTION_VALUES.contains(string);
    }

    public static boolean isTransportationMode(String string) {
        return TRANSPORT_MODES.contains(string);
    }

    public static boolean isDirection(String string) {
        return "forward".equals(string) || "backward".equals(string);
    }

    public boolean isKeyValid(String string) {
        if (!string.endsWith(":conditional")) {
            return false;
        }
        String[] stringArray = string.replaceAll(":conditional", "").split(":");
        return stringArray.length == 3 && ConditionalKeys.isRestrictionType(stringArray[0]) && ConditionalKeys.isTransportationMode(stringArray[1]) && ConditionalKeys.isDirection(stringArray[2]) || stringArray.length == 1 && (ConditionalKeys.isRestrictionType(stringArray[0]) || ConditionalKeys.isTransportationMode(stringArray[0])) || stringArray.length == 2 && (ConditionalKeys.isRestrictionType(stringArray[0]) && (ConditionalKeys.isTransportationMode(stringArray[1]) || ConditionalKeys.isDirection(stringArray[1])) || ConditionalKeys.isTransportationMode(stringArray[0]) && ConditionalKeys.isDirection(stringArray[1]));
    }

    public boolean isValueValid(String string, String string2) {
        return this.validateValue(string, string2) == null;
    }

    public String validateValue(String string, String string2) {
        try {
            for (ConditionalValue conditionalValue : ConditionalValue.parse(string2)) {
                if (ConditionalKeys.isTransportationMode(string.split(":")[0]) && !ConditionalKeys.isRestrictionValue(conditionalValue.restrictionValue)) {
                    return I18n.tr("{0} is not a valid restriction value", conditionalValue.restrictionValue);
                }
                for (String string3 : conditionalValue.conditions) {
                    List<OpeningHourTest.OpeningHoursTestError> list;
                    if (!string3.matches(".*[0-9]:[0-9]{2}.*") || (list = this.openingHourTest.checkOpeningHourSyntax("", string3, OpeningHourTest.CheckMode.TIME_RANGE, true, LanguageInfo.getJOSMLocaleCode())).isEmpty()) continue;
                    return list.get(0).getMessage();
                }
            }
        }
        catch (ConditionalParsingException conditionalParsingException) {
            return conditionalParsingException.getMessage();
        }
        return null;
    }

    public List<TestError> validatePrimitive(OsmPrimitive osmPrimitive) {
        ArrayList<TestError> arrayList = new ArrayList<TestError>();
        for (String string : Utils.filter(osmPrimitive.keySet(), Predicates.stringMatchesPattern(Pattern.compile(".*:conditional(:.*)?$")))) {
            if (!this.isKeyValid(string)) {
                arrayList.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Wrong syntax in {0} key", string), 3201, osmPrimitive));
                continue;
            }
            String string2 = osmPrimitive.get(string);
            String string3 = this.validateValue(string, string2);
            if (string3 == null) continue;
            arrayList.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Error in {0} value: {1}", string, string3), 3202, osmPrimitive));
        }
        return arrayList;
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        this.errors.addAll(this.validatePrimitive(osmPrimitive));
    }

    public static class ConditionalValue {
        public final String restrictionValue;
        public final Collection<String> conditions;

        public ConditionalValue(String string, Collection<String> collection) {
            this.restrictionValue = string;
            this.conditions = collection;
        }

        public static List<ConditionalValue> parse(String string) throws ConditionalParsingException {
            ArrayList<ConditionalValue> arrayList = new ArrayList<ConditionalValue>();
            Pattern pattern = Pattern.compile("([^@\\p{Space}][^@]*?)\\s*@\\s*(\\([^)\\p{Space}][^)]+?\\)|[^();\\p{Space}][^();]*?)\\s*");
            Matcher matcher = Pattern.compile("(" + pattern + ")(;\\s*" + pattern + ")*").matcher(string);
            if (!matcher.matches()) {
                throw new ConditionalParsingException(I18n.tr("Does not match pattern ''restriction value @ condition''", new Object[0]));
            }
            int n = 2;
            while (n + 1 <= matcher.groupCount() && matcher.group(n + 1) != null) {
                String string2 = matcher.group(n);
                String[] stringArray = matcher.group(n + 1).replace("(", "").replace(")", "").split("\\s+(AND|and)\\s+");
                arrayList.add(new ConditionalValue(string2, Arrays.asList(stringArray)));
                n += 3;
            }
            return arrayList;
        }
    }

    static class ConditionalParsingException
    extends RuntimeException {
        ConditionalParsingException(String string) {
            super(string);
        }
    }
}

