/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.download.BookmarkList;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class BookmarkSelection
implements DownloadSelection {
    private Bounds currentArea;
    private BookmarkList bookmarks;
    private DownloadDialog parent;
    private JMultilineLabel lblCurrentDownloadArea;
    private final JosmTextArea bboxDisplay = new JosmTextArea();
    private AddAction actAdd;

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        RemoveAction removeAction = new RemoveAction();
        this.bookmarks.addListSelectionListener(removeAction);
        jPanel.add((Component)new JButton(removeAction), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        RenameAction renameAction = new RenameAction();
        this.bookmarks.addListSelectionListener(renameAction);
        jPanel.add((Component)new JButton(renameAction), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildDownloadAreaAddPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.lblCurrentDownloadArea = new JMultilineLabel("");
        jPanel.add((Component)this.lblCurrentDownloadArea, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bboxDisplay.setEditable(false);
        this.bboxDisplay.setBackground(jPanel.getBackground());
        this.bboxDisplay.addFocusListener(new BoundingBoxSelection.SelectAllOnFocusHandler(this.bboxDisplay));
        jPanel.add((Component)this.bboxDisplay, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.actAdd = new AddAction();
        jPanel.add((Component)new JButton(this.actAdd), gridBagConstraints);
        return jPanel;
    }

    @Override
    public void addGui(final DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        downloadDialog.addDownloadAreaSelector(jPanel, I18n.tr("Bookmarks", new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.bookmarks = new BookmarkList();
        this.bookmarks.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BookmarkList.Bookmark bookmark = (BookmarkList.Bookmark)BookmarkSelection.this.bookmarks.getSelectedValue();
                if (bookmark != null) {
                    downloadDialog.boundingBoxChanged(bookmark.getArea(), BookmarkSelection.this);
                }
            }
        });
        this.bookmarks.addMouseListener(new DoubleClickAdapter());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.buildDownloadAreaAddPanel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.buildButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JScrollPane(this.bookmarks), gridBagConstraints);
        this.parent = downloadDialog;
    }

    protected void updateDownloadAreaLabel() {
        if (this.currentArea == null) {
            this.lblCurrentDownloadArea.setText(I18n.tr("<html>There is currently no download area selected.</html>", new Object[0]));
        } else {
            this.lblCurrentDownloadArea.setText(I18n.tr("<html><strong>Current download area</strong> (minlon, minlat, maxlon, maxlat): </html>", new Object[0]));
            this.bboxDisplay.setText(this.currentArea.toBBox().toStringCSV(","));
        }
    }

    @Override
    public void setDownloadArea(Bounds bounds) {
        if (bounds == null) {
            return;
        }
        this.currentArea = bounds;
        this.bookmarks.clearSelection();
        this.updateDownloadAreaLabel();
        this.actAdd.setEnabled(true);
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() != 2) {
                return;
            }
            int n = BookmarkSelection.this.bookmarks.locationToIndex(mouseEvent.getPoint());
            if (n < 0 || n >= BookmarkSelection.this.bookmarks.getModel().getSize()) {
                return;
            }
            BookmarkList.Bookmark bookmark = (BookmarkList.Bookmark)BookmarkSelection.this.bookmarks.getModel().getElementAt(n);
            BookmarkSelection.this.parent.startDownload(bookmark.getArea());
        }
    }

    class RenameAction
    extends AbstractAction
    implements ListSelectionListener {
        RenameAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.putValue("ShortDescription", I18n.tr("Rename the currently selected bookmark", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List list = BookmarkSelection.this.bookmarks.getSelectedValuesList();
            if (list == null || list.size() != 1) {
                return;
            }
            BookmarkList.Bookmark bookmark = (BookmarkList.Bookmark)list.get(0);
            Object object = JOptionPane.showInputDialog(Main.parent, I18n.tr("Please enter a name for the bookmarked download area.", new Object[0]), I18n.tr("Name of location", new Object[0]), 3, null, null, bookmark.getName());
            if (object != null) {
                bookmark.setName(object.toString());
                BookmarkSelection.this.bookmarks.save();
                BookmarkSelection.this.bookmarks.repaint();
            }
        }

        protected final void updateEnabledState() {
            this.setEnabled(BookmarkSelection.this.bookmarks.getSelectedIndices().length == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Remove the currently selected bookmarks", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List list = BookmarkSelection.this.bookmarks.getSelectedValuesList();
            if (list == null || list.isEmpty()) {
                return;
            }
            for (Object e : list) {
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).removeElement(e);
            }
            BookmarkSelection.this.bookmarks.save();
        }

        protected final void updateEnabledState() {
            this.setEnabled(BookmarkSelection.this.bookmarks.getSelectedIndices().length > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction {
        AddAction() {
            this.putValue("Name", I18n.tr("Create bookmark", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "bookmark-new"));
            this.putValue("ShortDescription", I18n.tr("Add a bookmark for the currently selected download area", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BookmarkSelection.this.currentArea == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Currently, there is no download area selected. Please select an area first.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                return;
            }
            BookmarkList.Bookmark bookmark = new BookmarkList.Bookmark();
            bookmark.setName(JOptionPane.showInputDialog(Main.parent, I18n.tr("Please enter a name for the bookmarked download area.", new Object[0]), I18n.tr("Name of location", new Object[0]), 3));
            bookmark.setArea(BookmarkSelection.this.currentArea);
            if (bookmark.getName() != null && !bookmark.getName().isEmpty()) {
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).addElement(bookmark);
                BookmarkSelection.this.bookmarks.save();
            }
        }
    }
}

