/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.mappaint.styleelement.LineElement;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSStyleSource
extends StyleSource {
    public static final String MAPCSS_STYLE_MIME_TYPES = "text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    public final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
    public final MapCSSRuleIndex nodeRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex wayRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex wayNoAreaRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex relationRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex multipolygonRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex canvasRules = new MapCSSRuleIndex();
    private Color backgroundColorOverride;
    private String css;
    private ZipFile zipFile;
    public static final ReadWriteLock STYLE_SOURCE_LOCK;
    protected static final Set<String> SUPPORTED_KEYS;

    public MapCSSStyleSource(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public MapCSSStyleSource(SourceEntry sourceEntry) {
        super(sourceEntry);
    }

    public MapCSSStyleSource(String string) {
        super(null, null, null);
        CheckParameterUtil.ensureParameterNotNull(string);
        this.css = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStyleSource() {
        STYLE_SOURCE_LOCK.writeLock().lock();
        try {
            Object object;
            Object object2;
            Object object3;
            this.init();
            this.rules.clear();
            this.nodeRules.clear();
            this.wayRules.clear();
            this.wayNoAreaRules.clear();
            this.relationRules.clear();
            this.multipolygonRules.clear();
            this.canvasRules.clear();
            try {
                Throwable object4 = null;
                try (InputStream inputStream = this.getSourceInputStream();){
                    try {
                        object3 = new MapCSSParser(inputStream, "UTF-8", MapCSSParser.LexicalState.PREPROCESSOR);
                        object2 = ((MapCSSParser)object3).pp_root(this);
                        object = new ByteArrayInputStream(((String)object2).getBytes(StandardCharsets.UTF_8));
                        Object object5 = new MapCSSParser((InputStream)object, "UTF-8", MapCSSParser.LexicalState.DEFAULT);
                        ((MapCSSParser)object5).sheet(this);
                        this.loadMeta();
                        this.loadCanvas();
                        this.loadSettings();
                    }
                    finally {
                        this.closeSourceInputStream(inputStream);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, iOException.toString()));
                Main.error(iOException);
                this.logError(iOException);
            }
            catch (TokenMgrError tokenMgrError) {
                Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, tokenMgrError.getMessage()));
                Main.error(tokenMgrError);
                this.logError(tokenMgrError);
            }
            catch (ParseException parseException) {
                Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, parseException.getMessage()));
                Main.error(parseException);
                this.logError(new ParseException(parseException.getMessage()));
            }
            block38: for (MapCSSRule mapCSSRule : this.rules) {
                object3 = mapCSSRule.selector;
                while (object3 instanceof Selector.ChildOrParentSelector) {
                    object3 = ((Selector.ChildOrParentSelector)object3).right;
                }
                object2 = new MapCSSRule(mapCSSRule.selector.optimizedBaseCheck(), mapCSSRule.declaration);
                switch (object = ((Selector.GeneralSelector)object3).getBase()) {
                    case "node": {
                        this.nodeRules.add((MapCSSRule)object2);
                        continue block38;
                    }
                    case "way": {
                        this.wayNoAreaRules.add((MapCSSRule)object2);
                        this.wayRules.add((MapCSSRule)object2);
                        continue block38;
                    }
                    case "area": {
                        this.wayRules.add((MapCSSRule)object2);
                        this.multipolygonRules.add((MapCSSRule)object2);
                        continue block38;
                    }
                    case "relation": {
                        this.relationRules.add((MapCSSRule)object2);
                        this.multipolygonRules.add((MapCSSRule)object2);
                        continue block38;
                    }
                    case "*": {
                        this.nodeRules.add((MapCSSRule)object2);
                        this.wayRules.add((MapCSSRule)object2);
                        this.wayNoAreaRules.add((MapCSSRule)object2);
                        this.relationRules.add((MapCSSRule)object2);
                        this.multipolygonRules.add((MapCSSRule)object2);
                        continue block38;
                    }
                    case "canvas": {
                        this.canvasRules.add(mapCSSRule);
                        continue block38;
                    }
                    case "meta": 
                    case "setting": {
                        continue block38;
                    }
                }
                RuntimeException runtimeException = new RuntimeException(MessageFormat.format("Unknown MapCSS base selector {0}", object));
                Main.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, runtimeException.getMessage()));
                Main.error(runtimeException);
                this.logError(runtimeException);
            }
            this.nodeRules.initIndex();
            this.wayRules.initIndex();
            this.wayNoAreaRules.initIndex();
            this.relationRules.initIndex();
            this.multipolygonRules.initIndex();
            this.canvasRules.initIndex();
        }
        finally {
            STYLE_SOURCE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        if (this.css != null) {
            return new ByteArrayInputStream(this.css.getBytes(StandardCharsets.UTF_8));
        }
        CachedFile cachedFile = this.getCachedFile();
        if (this.isZip) {
            File file = cachedFile.getFile();
            this.zipFile = new ZipFile(file, StandardCharsets.UTF_8);
            this.zipIcons = file;
            ZipEntry zipEntry = this.zipFile.getEntry(this.zipEntryPath);
            return this.zipFile.getInputStream(zipEntry);
        }
        this.zipFile = null;
        this.zipIcons = null;
        return cachedFile.getInputStream();
    }

    @Override
    public CachedFile getCachedFile() throws IOException {
        return new CachedFile(this.url).setHttpAccept(MAPCSS_STYLE_MIME_TYPES);
    }

    @Override
    public void closeSourceInputStream(InputStream inputStream) {
        super.closeSourceInputStream(inputStream);
        if (this.isZip) {
            Utils.close(this.zipFile);
        }
    }

    private void loadMeta() {
        Cascade cascade = this.constructSpecial("meta");
        String string = cascade.get("title", null, String.class);
        if (this.title == null) {
            this.title = string;
        }
        String string2 = cascade.get("icon", null, String.class);
        if (this.icon == null) {
            this.icon = string2;
        }
    }

    private void loadCanvas() {
        Cascade cascade = this.constructSpecial("canvas");
        this.backgroundColorOverride = cascade.get("fill-color", null, Color.class);
        if (this.backgroundColorOverride == null) {
            this.backgroundColorOverride = cascade.get("background-color", null, Color.class);
            if (this.backgroundColorOverride != null) {
                Main.warn(I18n.tr("Detected deprecated ''{0}'' in ''{1}'' which will be removed shortly. Use ''{2}'' instead.", "canvas{background-color}", this.url, "fill-color"));
            }
        }
    }

    private void loadSettings() {
        Object object;
        this.settings.clear();
        this.settingValues.clear();
        MultiCascade multiCascade = new MultiCascade();
        Node node = new Node();
        String string = LanguageInfo.getJOSMLocaleCode();
        node.put("lang", string);
        Environment environment = new Environment(node, multiCascade, "default", this);
        for (MapCSSRule object2 : this.rules) {
            if (!(object2.selector instanceof Selector.GeneralSelector) || !"setting".equals(((Selector.OptimizedGeneralSelector)(object = (Selector.GeneralSelector)object2.selector)).getBase()) || !((Selector.GeneralSelector)object).matchesConditions(environment)) continue;
            environment.layer = null;
            environment.layer = ((Selector.OptimizedGeneralSelector)object).getSubpart().getId(environment);
            object2.execute(environment);
        }
        for (Map.Entry entry : multiCascade.getLayers()) {
            if ("default".equals(entry.getKey())) {
                Main.warn("setting requires layer identifier e.g. 'setting::my_setting {...}'");
                continue;
            }
            object = (Cascade)entry.getValue();
            String string2 = ((Cascade)object).get("type", null, String.class);
            StyleSetting.BooleanStyleSetting booleanStyleSetting = null;
            if ("boolean".equals(string2)) {
                booleanStyleSetting = StyleSetting.BooleanStyleSetting.create((Cascade)object, this, (String)entry.getKey());
            } else {
                Main.warn("Unkown setting type: " + string2);
            }
            if (booleanStyleSetting == null) continue;
            this.settings.add(booleanStyleSetting);
            this.settingValues.put(entry.getKey(), booleanStyleSetting.getValue());
        }
    }

    private Cascade constructSpecial(String string) {
        MultiCascade multiCascade = new MultiCascade();
        Node node = new Node();
        String string2 = LanguageInfo.getJOSMLocaleCode();
        node.put("lang", string2);
        Environment environment = new Environment(node, multiCascade, "default", this);
        for (MapCSSRule mapCSSRule : this.rules) {
            Selector.GeneralSelector generalSelector;
            if (!(mapCSSRule.selector instanceof Selector.GeneralSelector) || !(generalSelector = (Selector.GeneralSelector)mapCSSRule.selector).getBase().equals(string) || !generalSelector.matchesConditions(environment)) continue;
            mapCSSRule.execute(environment);
        }
        return multiCascade.getCascade("default");
    }

    @Override
    public Color getBackgroundColorOverride() {
        return this.backgroundColorOverride;
    }

    @Override
    public void apply(MultiCascade multiCascade, OsmPrimitive osmPrimitive, double d, boolean bl) {
        Environment environment = new Environment(osmPrimitive, multiCascade, null, this);
        MapCSSRuleIndex mapCSSRuleIndex = osmPrimitive instanceof Node ? this.nodeRules : (osmPrimitive instanceof Way ? (osmPrimitive.isKeyFalse("area") ? this.wayNoAreaRules : this.wayRules) : (((Relation)osmPrimitive).isMultipolygon() ? this.multipolygonRules : (osmPrimitive.hasKey("#canvas") ? this.canvasRules : this.relationRules)));
        int n = -1;
        Iterator<MapCSSRule> iterator = mapCSSRuleIndex.getRuleCandidates(osmPrimitive);
        while (iterator.hasNext()) {
            MapCSSRule mapCSSRule = iterator.next();
            environment.clearSelectorMatchingInformation();
            environment.layer = null;
            String string = environment.layer = mapCSSRule.selector.getSubpart().getId(environment);
            if (!mapCSSRule.selector.matches(environment)) continue;
            Selector selector = mapCSSRule.selector;
            if (!selector.getRange().contains(d)) {
                multiCascade.range = multiCascade.range.reduceAround(d, selector.getRange());
                continue;
            }
            multiCascade.range = Range.cut(multiCascade.range, selector.getRange());
            if (mapCSSRule.declaration.idx == n) continue;
            n = mapCSSRule.declaration.idx;
            if ("*".equals(string)) {
                for (Map.Entry<String, Cascade> entry : multiCascade.getLayers()) {
                    environment.layer = entry.getKey();
                    if ("*".equals(environment.layer)) continue;
                    mapCSSRule.execute(environment);
                }
            }
            environment.layer = string;
            mapCSSRule.execute(environment);
        }
    }

    public boolean evalSupportsDeclCondition(String string, Object object) {
        if (string == null) {
            return false;
        }
        if (SUPPORTED_KEYS.contains(string)) {
            return true;
        }
        switch (string) {
            case "user-agent": {
                String string2 = Cascade.convertTo(object, String.class);
                return "josm".equals(string2);
            }
            case "min-josm-version": {
                Float f = Cascade.convertTo(object, Float.class);
                return f != null && Math.round(f.floatValue()) <= Version.getInstance().getVersion();
            }
            case "max-josm-version": {
                Float f = Cascade.convertTo(object, Float.class);
                return f != null && Math.round(f.floatValue()) >= Version.getInstance().getVersion();
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return Utils.join("\n", this.rules);
    }

    static {
        Field[] fieldArray;
        STYLE_SOURCE_LOCK = new ReentrantReadWriteLock();
        SUPPORTED_KEYS = new HashSet<String>();
        for (Field field : fieldArray = StyleKeys.class.getDeclaredFields()) {
            try {
                SUPPORTED_KEYS.add((String)field.get(null));
                if (field.getName().toLowerCase(Locale.ENGLISH).replace('_', '-').equals(field.get(null))) continue;
                throw new RuntimeException(field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new RuntimeException(exception);
            }
        }
        for (LineElement.LineType lineType : LineElement.LineType.values()) {
            SUPPORTED_KEYS.add(lineType.prefix + "color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-offset");
            SUPPORTED_KEYS.add(lineType.prefix + "linecap");
            SUPPORTED_KEYS.add(lineType.prefix + "linejoin");
            SUPPORTED_KEYS.add(lineType.prefix + "miterlimit");
            SUPPORTED_KEYS.add(lineType.prefix + "offset");
            SUPPORTED_KEYS.add(lineType.prefix + "opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "real-width");
            SUPPORTED_KEYS.add(lineType.prefix + "width");
        }
    }

    public static class MapCSSRuleIndex {
        private final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
        private final Map<String, MapCSSKeyRules> index = new HashMap<String, MapCSSKeyRules>();
        private final BitSet remaining = new BitSet();

        public void add(MapCSSRule mapCSSRule) {
            this.rules.add(mapCSSRule);
        }

        public void initIndex() {
            Collections.sort(this.rules);
            for (int i = 0; i < this.rules.size(); ++i) {
                Object object;
                MapCSSRule mapCSSRule = this.rules.get(i);
                Selector selector = mapCSSRule.selector;
                while (selector instanceof Selector.ChildOrParentSelector) {
                    selector = ((Selector.ChildOrParentSelector)selector).right;
                }
                Selector.OptimizedGeneralSelector optimizedGeneralSelector = (Selector.OptimizedGeneralSelector)selector;
                if (optimizedGeneralSelector.conds == null) {
                    this.remaining.set(i);
                    continue;
                }
                ArrayList arrayList = new ArrayList(Utils.filteredCollection(optimizedGeneralSelector.conds, Condition.SimpleKeyValueCondition.class));
                if (!arrayList.isEmpty()) {
                    object = (Condition.SimpleKeyValueCondition)arrayList.get(arrayList.size() - 1);
                    this.getEntryInIndex(((Condition.SimpleKeyValueCondition)object).k).addForKeyAndValue(((Condition.SimpleKeyValueCondition)object).v, i);
                    continue;
                }
                object = this.findAnyRequiredKey(optimizedGeneralSelector.conds);
                if (object != null) {
                    this.getEntryInIndex((String)object).addForKey(i);
                    continue;
                }
                this.remaining.set(i);
            }
        }

        private String findAnyRequiredKey(List<Condition> list) {
            String string = null;
            for (Condition condition : list) {
                Condition condition2;
                if (condition instanceof Condition.KeyCondition) {
                    condition2 = (Condition.KeyCondition)condition;
                    if (condition2.negateResult || !MapCSSRuleIndex.conditionRequiresKeyPresence(condition2.matchType)) continue;
                    string = condition2.label;
                    continue;
                }
                if (!(condition instanceof Condition.KeyValueCondition)) continue;
                condition2 = (Condition.KeyValueCondition)condition;
                if (Condition.Op.NEGATED_OPS.contains((Object)((Condition.KeyValueCondition)condition2).op)) continue;
                string = ((Condition.KeyValueCondition)condition2).k;
            }
            return string;
        }

        private static boolean conditionRequiresKeyPresence(Condition.KeyMatchType keyMatchType) {
            return keyMatchType != Condition.KeyMatchType.REGEX;
        }

        private MapCSSKeyRules getEntryInIndex(String string) {
            MapCSSKeyRules mapCSSKeyRules = this.index.get(string);
            if (mapCSSKeyRules == null) {
                mapCSSKeyRules = new MapCSSKeyRules();
                this.index.put(string.intern(), mapCSSKeyRules);
            }
            return mapCSSKeyRules;
        }

        public Iterator<MapCSSRule> getRuleCandidates(OsmPrimitive osmPrimitive) {
            BitSet bitSet = new BitSet(this.rules.size());
            bitSet.or(this.remaining);
            RuleCandidatesIterator ruleCandidatesIterator = new RuleCandidatesIterator(bitSet);
            osmPrimitive.visitKeys(ruleCandidatesIterator);
            ruleCandidatesIterator.prepare();
            return ruleCandidatesIterator;
        }

        public void clear() {
            this.rules.clear();
            this.index.clear();
            this.remaining.clear();
        }

        private static final class MapCSSKeyRules {
            BitSet generalRules = new BitSet();
            Map<String, BitSet> specialRules = new HashMap<String, BitSet>();

            private MapCSSKeyRules() {
            }

            public void addForKey(int n) {
                this.generalRules.set(n);
                for (BitSet bitSet : this.specialRules.values()) {
                    bitSet.set(n);
                }
            }

            public void addForKeyAndValue(String string, int n) {
                BitSet bitSet = this.specialRules.get(string);
                if (bitSet == null) {
                    bitSet = new BitSet();
                    bitSet.or(this.generalRules);
                    this.specialRules.put(string.intern(), bitSet);
                }
                bitSet.set(n);
            }

            public BitSet get(String string) {
                BitSet bitSet = this.specialRules.get(string);
                if (bitSet != null) {
                    return bitSet;
                }
                return this.generalRules;
            }
        }

        private final class RuleCandidatesIterator
        implements Iterator<MapCSSRule>,
        AbstractPrimitive.KeyValueVisitor {
            private final BitSet ruleCandidates;
            private int next;

            private RuleCandidatesIterator(BitSet bitSet) {
                this.ruleCandidates = bitSet;
            }

            @Override
            public boolean hasNext() {
                return this.next >= 0;
            }

            @Override
            public MapCSSRule next() {
                MapCSSRule mapCSSRule = (MapCSSRule)MapCSSRuleIndex.this.rules.get(this.next);
                this.next = this.ruleCandidates.nextSetBit(this.next + 1);
                return mapCSSRule;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visitKeyValue(AbstractPrimitive abstractPrimitive, String string, String string2) {
                MapCSSKeyRules mapCSSKeyRules = (MapCSSKeyRules)MapCSSRuleIndex.this.index.get(string);
                if (mapCSSKeyRules != null) {
                    BitSet bitSet = mapCSSKeyRules.get(string2);
                    this.ruleCandidates.or(bitSet);
                }
            }

            public void prepare() {
                this.next = this.ruleCandidates.nextSetBit(0);
            }
        }
    }
}

