/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class PartialPosTagFilter
implements RuleFilter {
    @Nullable
    protected abstract List<AnalyzedTokenReadings> tag(String var1);

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, AnalyzedTokenReadings[] patternTokens) {
        if (!(args.containsKey("no") && args.containsKey("regexp") && args.containsKey("postag_regexp"))) {
            throw new RuntimeException("Set 'no', 'regexp' and 'postag_regexp' for filter " + PartialPosTagFilter.class.getSimpleName());
        }
        int tokenPos = Integer.parseInt(args.get("no"));
        Pattern pattern = Pattern.compile(args.get("regexp"));
        String requiredTagRegexp = args.get("postag_regexp");
        boolean negatePos = args.containsKey("negate_pos");
        String token = patternTokens[tokenPos - 1].getToken();
        Matcher matcher = pattern.matcher(token);
        if (matcher.matches()) {
            String partialToken = matcher.group(1);
            List<AnalyzedTokenReadings> tags = this.tag(partialToken);
            if (tags != null && this.partialTagHasRequiredTag(tags, requiredTagRegexp, negatePos)) {
                return match;
            }
            return null;
        }
        return null;
    }

    private boolean partialTagHasRequiredTag(List<AnalyzedTokenReadings> tags, String requiredTagRegexp, boolean negatePos) {
        int postagCount = 0;
        for (AnalyzedTokenReadings tag : tags) {
            for (AnalyzedToken analyzedToken : tag.getReadings()) {
                if (analyzedToken.getPOSTag() == null) continue;
                if (negatePos) {
                    ++postagCount;
                    if (!analyzedToken.getPOSTag().matches(requiredTagRegexp)) continue;
                    return false;
                }
                if (!analyzedToken.getPOSTag().matches(requiredTagRegexp)) continue;
                return true;
            }
        }
        return postagCount == 0 ? false : negatePos;
    }
}

