/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.languagetool.rules.spelling.hunspell.HunspellLibrary;

public class Hunspell {
    private static Hunspell hunspell = null;
    private HunspellLibrary hsl = null;
    private String libFile;
    private HashMap<String, Dictionary> map = new HashMap();

    public static Hunspell getInstance() throws UnsatisfiedLinkError, UnsupportedOperationException {
        return Hunspell.getInstance(null);
    }

    public static Hunspell getInstance(String libDir) throws UnsatisfiedLinkError, UnsupportedOperationException {
        if (hunspell != null) {
            return hunspell;
        }
        hunspell = new Hunspell(libDir);
        return hunspell;
    }

    protected void tryLoad(String libFile) throws UnsupportedOperationException {
        this.hsl = (HunspellLibrary)Native.loadLibrary((String)libFile, HunspellLibrary.class);
    }

    protected Hunspell(String libDir) throws UnsatisfiedLinkError, UnsupportedOperationException {
        this.libFile = libDir != null ? libDir + "/" + Hunspell.libName() : Hunspell.libNameBare();
        try {
            this.hsl = (HunspellLibrary)Native.loadLibrary((String)this.libFile, HunspellLibrary.class);
        }
        catch (UnsatisfiedLinkError urgh) {
            File lib;
            this.libFile = Hunspell.libName();
            InputStream is = Hunspell.class.getResourceAsStream("/" + this.libFile);
            if (is == null) {
                throw new UnsatisfiedLinkError("Can't find " + this.libFile + " in the filesystem nor in the classpath\n" + urgh);
            }
            FileOutputStream fos = null;
            try {
                int count;
                lib = File.createTempFile("jna", "." + this.libFile);
                lib.deleteOnExit();
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new Error("Failed to create temporary file for " + this.libFile, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
            this.hsl = (HunspellLibrary)Native.loadLibrary((String)lib.getAbsolutePath(), HunspellLibrary.class);
        }
    }

    public String getLibFile() {
        return this.libFile;
    }

    public static String libName() throws UnsupportedOperationException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return Hunspell.libNameBare() + ".dll";
        }
        if (os.startsWith("mac os x")) {
            return Hunspell.libNameBare() + ".jnilib";
        }
        return "lib" + Hunspell.libNameBare() + ".so";
    }

    public static String libNameBare() throws UnsupportedOperationException {
        boolean amd64;
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean x86 = arch.equals("x86") || arch.equals("i386") || arch.equals("i686");
        boolean bl = amd64 = arch.equals("x86_64") || arch.equals("amd64") || arch.equals("ia64n");
        if (os.startsWith("windows")) {
            if (x86) {
                return "hunspell-win-x86-32";
            }
            if (amd64) {
                return "hunspell-win-x86-64";
            }
        } else if (os.startsWith("mac os x")) {
            if (x86) {
                return "hunspell-darwin-x86-32";
            }
            if (amd64) {
                return "hunspell-darwin-x86-64";
            }
            if (arch.equals("ppc")) {
                return "hunspell-darwin-ppc-32";
            }
        } else if (os.startsWith("linux")) {
            if (x86) {
                return "hunspell-linux-x86-32";
            }
            if (amd64) {
                return "hunspell-linux-x86-64";
            }
        } else if (os.startsWith("sunos")) {
            // empty if block
        }
        throw new UnsupportedOperationException("Unknown OS/arch: " + os + "/" + arch);
    }

    private static CharBuffer ensureCapacity(CharBuffer buffer, int capacity) {
        if (buffer == null || buffer.capacity() < capacity) {
            buffer = CharBuffer.allocate(capacity);
        }
        return buffer;
    }

    public Dictionary getDictionary(String baseFileName) throws IOException {
        if (this.map.containsKey(baseFileName)) {
            return this.map.get(baseFileName);
        }
        Dictionary d = new Dictionary(baseFileName);
        this.map.put(baseFileName, d);
        return d;
    }

    public void destroyDictionary(String baseFileName) {
        if (this.map.containsKey(baseFileName)) {
            this.map.remove(baseFileName);
        }
    }

    public class Dictionary {
        private Pointer hunspellDict = null;
        private String encoding;
        private final String wordChars;

        Dictionary(String baseFileName) throws IOException {
            File dic = new File(baseFileName + ".dic");
            File aff = new File(baseFileName + ".aff");
            if (!dic.canRead() || !aff.canRead()) {
                throw new FileNotFoundException("The dictionary files " + baseFileName + "(.aff|.dic) could not be read");
            }
            this.hunspellDict = Hunspell.this.hsl.Hunspell_create(aff.toString(), dic.toString());
            this.encoding = Hunspell.this.hsl.Hunspell_get_dic_encoding(this.hunspellDict);
            if ("microsoft1251".equals(this.encoding)) {
                this.encoding = "windows-1251";
            } else if ("ISCII-DEVANAGARI".equals(this.encoding)) {
                this.encoding = "ISCII91";
            }
            this.wordChars = this.getWordCharsFromFile(aff);
        }

        public void destroy() {
            if (Hunspell.this.hsl != null && this.hunspellDict != null) {
                Hunspell.this.hsl.Hunspell_destroy(this.hunspellDict);
                this.hunspellDict = null;
            }
        }

        public String getWordChars() {
            return this.wordChars;
        }

        public boolean misspelled(String word) {
            try {
                byte[] wordAsBytes = this.stringToBytes(word);
                if (wordAsBytes.length == 0 && word.length() > 0) {
                    return true;
                }
                return Hunspell.this.hsl.Hunspell_spell(this.hunspellDict, wordAsBytes) == 0;
            }
            catch (UnsupportedEncodingException e) {
                return true;
            }
        }

        protected byte[] stringToBytes(String str) throws UnsupportedEncodingException {
            byte[] strBytes = str.getBytes(this.encoding);
            byte[] zeroTerminated = Arrays.copyOf(strBytes, strBytes.length + 1);
            zeroTerminated[zeroTerminated.length - 1] = 0;
            return zeroTerminated;
        }

        public List<String> suggest(String word) throws CharacterCodingException {
            ArrayList<String> res = new ArrayList<String>();
            try {
                int suggestionsCount = 0;
                PointerByReference suggestions = new PointerByReference();
                byte[] wordAsBytes = this.stringToBytes(word);
                if (wordAsBytes.length == 0 && word.length() > 0) {
                    return res;
                }
                suggestionsCount = Hunspell.this.hsl.Hunspell_suggest(this.hunspellDict, suggestions, this.stringToBytes(word));
                if (suggestionsCount == 0) {
                    return res;
                }
                Pointer[] pointerArray = suggestions.getValue().getPointerArray(0L, suggestionsCount);
                for (int i = 0; i < suggestionsCount; ++i) {
                    long len = pointerArray[i].indexOf(0L, (byte)0);
                    if (len == -1L) continue;
                    if (len > Integer.MAX_VALUE) {
                        throw new RuntimeException("String improperly terminated: " + len);
                    }
                    byte[] data = pointerArray[i].getByteArray(0L, (int)len);
                    res.add(new String(data, this.encoding));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return res;
        }

        private String getWordCharsFromFile(File affixFile) throws IOException {
            String affixWordChars = "";
            try (Scanner scanner = new Scanner(affixFile, this.encoding);){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith("WORDCHARS ")) continue;
                    affixWordChars = line.substring("WORDCHARS ".length());
                }
            }
            return affixWordChars;
        }

        public void addWord(String word) throws UnsupportedEncodingException {
            Hunspell.this.hsl.Hunspell_add(this.hunspellDict, this.stringToBytes(word));
        }
    }
}

