/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.bitext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import junit.framework.TestCase;
import org.languagetool.bitext.StringPair;
import org.languagetool.bitext.TabBitextReader;

public class TabBitextReaderTest
extends TestCase {
    public void testReader() throws Exception {
        File input = File.createTempFile("input", "txt");
        input.deleteOnExit();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(input), "UTF-8"));
        writer.println("This is not actual.\tTo nie jest aktualne.");
        writer.println("Test\tTest");
        writer.println("ab\tVery strange data indeed, much longer than input");
        writer.close();
        TabBitextReader reader = new TabBitextReader(input.getAbsolutePath(), "UTF-8");
        int i = 1;
        for (StringPair srcAndTrg : reader) {
            TabBitextReaderTest.assertTrue((srcAndTrg.getSource() != null ? 1 : 0) != 0);
            TabBitextReaderTest.assertTrue((srcAndTrg.getTarget() != null ? 1 : 0) != 0);
            if (i == 1) {
                TabBitextReaderTest.assertEquals((String)"This is not actual.", (String)srcAndTrg.getSource());
            } else if (i == 2) {
                TabBitextReaderTest.assertEquals((String)"Test", (String)srcAndTrg.getSource());
            } else if (i == 3) {
                TabBitextReaderTest.assertEquals((String)"Very strange data indeed, much longer than input", (String)srcAndTrg.getTarget());
            }
            ++i;
        }
    }
}

