/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import junit.framework.TestCase;
import org.languagetool.rules.spelling.SuggestionExtractor;

public class SuggestionExtractorTest
extends TestCase {
    public void testGetSuggestions() throws IOException {
        SuggestionExtractor extractor = new SuggestionExtractor();
        SuggestionExtractorTest.assertEquals((String)"[]", (String)extractor.getSimpleSuggestions("Did you mean foo?").toString());
        SuggestionExtractorTest.assertEquals((String)"[foo bla]", (String)extractor.getSimpleSuggestions("Did you mean <suggestion>foo bla</suggestion>?").toString());
        SuggestionExtractorTest.assertEquals((String)"[foo bla, xxx]", (String)extractor.getSimpleSuggestions("Did you mean <suggestion>foo bla</suggestion> or <suggestion>xxx</suggestion>?").toString());
        SuggestionExtractorTest.assertEquals((String)"[foo bla, xxx]", (String)extractor.getSimpleSuggestions("Did you mean <suggestion suppress_misspelled=\"yes\">foo bla</suggestion> or <suggestion>xxx</suggestion>?").toString());
        SuggestionExtractorTest.assertEquals((String)"[]", (String)extractor.getSimpleSuggestions("Did you mean <suggestion>foo \\1</suggestion>?").toString());
        SuggestionExtractorTest.assertEquals((String)"[]", (String)extractor.getSimpleSuggestions("Did you mean <suggestion>\u201a<match no=\"3\" include_skipped=\"following\"/></suggestion>?").toString());
    }
}

