/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public class WordTokenizerTest
extends TestCase {
    private final WordTokenizer wordTokenizer = new WordTokenizer();

    public void testTokenize() {
        WordTokenizer wordTokenizer = new WordTokenizer();
        List tokens = wordTokenizer.tokenize("This is\u00a0a test");
        WordTokenizerTest.assertEquals((int)tokens.size(), (int)7);
        WordTokenizerTest.assertEquals((String)"[This,  , is, \u00a0, a,  , test]", (String)tokens.toString());
        List tokens2 = wordTokenizer.tokenize("This\rbreaks");
        WordTokenizerTest.assertEquals((int)3, (int)tokens2.size());
        WordTokenizerTest.assertEquals((String)"[This, \r, breaks]", (String)tokens2.toString());
    }

    public void testIsUrl() {
        WordTokenizerTest.assertTrue((boolean)WordTokenizer.isUrl((String)"www.languagetool.org"));
        WordTokenizerTest.assertTrue((boolean)WordTokenizer.isUrl((String)"http://www.languagetool.org"));
        WordTokenizerTest.assertTrue((boolean)WordTokenizer.isUrl((String)"https://www.languagetool.org"));
        WordTokenizerTest.assertFalse((boolean)WordTokenizer.isUrl((String)"languagetool.org"));
        WordTokenizerTest.assertFalse((boolean)WordTokenizer.isUrl((String)"something-else"));
    }

    public void testUrlTokenize() {
        WordTokenizerTest.assertEquals((String)"This| |http://foo.org| |blah", (String)this.tokenize("This http://foo.org blah"));
        WordTokenizerTest.assertEquals((String)"This| |http://foo.org| |and| |ftp://bla.com| |blah", (String)this.tokenize("This http://foo.org and ftp://bla.com blah"));
        WordTokenizerTest.assertEquals((String)"foo| |http://localhost:32000/?ch=1| |bar", (String)this.tokenize("foo http://localhost:32000/?ch=1 bar"));
        WordTokenizerTest.assertEquals((String)"foo| |ftp://localhost:32000/| |bar", (String)this.tokenize("foo ftp://localhost:32000/ bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://google.de/?aaa| |bar", (String)this.tokenize("foo http://google.de/?aaa bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://www.flickr.com/123@N04/hallo#test| |bar", (String)this.tokenize("foo http://www.flickr.com/123@N04/hallo#test bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://www.youtube.com/watch?v=wDN_EYUvUq0| |bar", (String)this.tokenize("foo http://www.youtube.com/watch?v=wDN_EYUvUq0 bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://example.net/index.html?s=A54C6FE2%23info| |bar", (String)this.tokenize("foo http://example.net/index.html?s=A54C6FE2%23info bar"));
        WordTokenizerTest.assertEquals((String)"foo| |https://joe:passwd@example.net:8080/index.html?action=x&session=A54C6FE2#info| |bar", (String)this.tokenize("foo https://joe:passwd@example.net:8080/index.html?action=x&session=A54C6FE2#info bar"));
    }

    public void testUrlTokenizeWithQuote() {
        WordTokenizerTest.assertEquals((String)"This| |'|http://foo.org|'| |blah", (String)this.tokenize("This 'http://foo.org' blah"));
        WordTokenizerTest.assertEquals((String)"This| |\"|http://foo.org|\"| |blah", (String)this.tokenize("This \"http://foo.org\" blah"));
    }

    public void testUrlTokenizeWithAppendedCharacter() {
        WordTokenizerTest.assertEquals((String)"foo| |(|http://ex.net/p?a=x#i|)| |bar", (String)this.tokenize("foo (http://ex.net/p?a=x#i) bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://ex.net/p?a=x#i|,| |bar", (String)this.tokenize("foo http://ex.net/p?a=x#i, bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://ex.net/p?a=x#i|.| |bar", (String)this.tokenize("foo http://ex.net/p?a=x#i. bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://ex.net/p?a=x#i|:| |bar", (String)this.tokenize("foo http://ex.net/p?a=x#i: bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://ex.net/p?a=x#i|?| |bar", (String)this.tokenize("foo http://ex.net/p?a=x#i? bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://ex.net/p?a=x#i|!| |bar", (String)this.tokenize("foo http://ex.net/p?a=x#i! bar"));
    }

    public void testIncompleteUrlTokenize() {
        WordTokenizerTest.assertEquals((String)"http|:|/", (String)this.tokenize("http:/"));
        WordTokenizerTest.assertEquals((String)"http://", (String)this.tokenize("http://"));
        WordTokenizerTest.assertEquals((String)"http://a", (String)this.tokenize("http://a"));
        WordTokenizerTest.assertEquals((String)"foo| |http| |bar", (String)this.tokenize("foo http bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http|:| |bar", (String)this.tokenize("foo http: bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http|:|/| |bar", (String)this.tokenize("foo http:/ bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://| |bar", (String)this.tokenize("foo http:// bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://a| |bar", (String)this.tokenize("foo http://a bar"));
        WordTokenizerTest.assertEquals((String)"foo| |http://|?| |bar", (String)this.tokenize("foo http://? bar"));
    }

    private String tokenize(String text) {
        List tokens = this.wordTokenizer.tokenize(text);
        return StringTools.listToString((Collection)tokens, (String)"|");
    }
}

