/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAction
extends AbstractAction {
    public static final String POPUP = "Popup";
    public static final String TOGGLE_BUTTON_MODEL = "ToggleButtonModel";

    public ResourceAction(UserPreferences userPreferences, Class<?> clazz, String string) {
        this(userPreferences, clazz, string, false);
    }

    public ResourceAction(UserPreferences userPreferences, Class<?> clazz, String string, boolean bl) {
        this.readActionProperties(userPreferences, clazz, string);
        this.setEnabled(bl);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this, clazz, string));
    }

    private void readActionProperties(UserPreferences userPreferences, Class<?> clazz, String string) {
        String string2;
        String string3;
        String string4;
        String string5 = string + ".";
        this.putValue("Name", this.getOptionalString(userPreferences, clazz, string5 + "Name", true));
        this.putValue("Default", this.getValue("Name"));
        this.putValue(POPUP, this.getOptionalString(userPreferences, clazz, string5 + POPUP, true));
        this.putValue("ShortDescription", this.getOptionalString(userPreferences, clazz, string5 + "ShortDescription", false));
        this.putValue("LongDescription", this.getOptionalString(userPreferences, clazz, string5 + "LongDescription", false));
        String string6 = this.getOptionalString(userPreferences, clazz, string5 + "SmallIcon", false);
        if (string6 != null) {
            this.putValue("SmallIcon", new ImageIcon(clazz.getResource(string6)));
        }
        if ((string4 = this.getOptionalString(userPreferences, clazz, (string3 = string5 + "AcceleratorKey") + "." + System.getProperty("os.name"), false)) == null) {
            string4 = this.getOptionalString(userPreferences, clazz, string3, false);
        }
        if (string4 != null) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string4));
        }
        if ((string2 = this.getOptionalString(userPreferences, clazz, string5 + "MnemonicKey", false)) != null) {
            this.putValue("MnemonicKey", KeyStroke.getKeyStroke(string2).getKeyCode());
        }
    }

    private String getOptionalString(UserPreferences userPreferences, Class<?> clazz, String string, boolean bl) {
        try {
            String string2;
            String string3 = string2 = bl ? SwingTools.getLocalizedLabelText(userPreferences, clazz, string, new Object[0]) : userPreferences.getLocalizedString(clazz, string, new Object[0]);
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        throw new UnsupportedOperationException();
    }

    public static class ButtonAction
    extends AbstractDecoratedAction {
        public ButtonAction(Action action) {
            super(action);
        }

        public Object getValue(String string) {
            if (OperatingSystem.isMacOSX() && string.equals("MnemonicKey")) {
                return null;
            }
            return super.getValue(string);
        }
    }

    public static class ToolBarAction
    extends AbstractDecoratedAction {
        public ToolBarAction(Action action) {
            super(action);
        }

        public Object getValue(String string) {
            if (string.equals("Name")) {
                return null;
            }
            return super.getValue(string);
        }
    }

    public static class PopupMenuItemAction
    extends MenuItemAction {
        public PopupMenuItemAction(Action action) {
            super(action);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ResourceAction.POPUP.equals(propertyChangeEvent.getPropertyName()) && (propertyChangeEvent.getOldValue() != null || propertyChangeEvent.getNewValue() != null)) {
                        PopupMenuItemAction.this.firePropertyChange("Name", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        public Object getValue(String string) {
            if (string.equals("Name")) {
                Object object = super.getValue(ResourceAction.POPUP);
                if (object != null) {
                    return object;
                }
            } else {
                if (string.equals("SmallIcon")) {
                    return null;
                }
                if (OperatingSystem.isMacOSX() && string.equals("AcceleratorKey")) {
                    return null;
                }
            }
            return super.getValue(string);
        }
    }

    public static class MenuItemAction
    extends AbstractDecoratedAction {
        public MenuItemAction(Action action) {
            super(action);
        }

        public Object getValue(String string) {
            if (OperatingSystem.isMacOSX() && (string.equals("MnemonicKey") || string.equals("SmallIcon") || string.equals("ShortDescription"))) {
                return null;
            }
            return super.getValue(string);
        }
    }

    private static class AbstractDecoratedAction
    implements Action {
        private Action action;
        private SwingPropertyChangeSupport propertyChangeSupport;

        public AbstractDecoratedAction(Action action) {
            this.action = action;
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
            action.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("enabled".equals(string)) {
                        AbstractDecoratedAction.this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
                    } else {
                        Object object = AbstractDecoratedAction.this.getValue(string);
                        if (object != null) {
                            AbstractDecoratedAction.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), string, propertyChangeEvent.getOldValue(), object));
                        }
                    }
                }
            });
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }

        public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public Object getValue(String string) {
            return this.action.getValue(string);
        }

        public final boolean isEnabled() {
            return this.action.isEnabled();
        }

        public final void putValue(String string, Object object) {
            this.action.putValue(string, object);
        }

        public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public final void setEnabled(boolean bl) {
            this.action.setEnabled(bl);
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            this.propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private final WeakReference<ResourceAction> resourceAction;
        private final Class<?> resourceClass;
        private final String actionPrefix;

        public LanguageChangeListener(ResourceAction resourceAction, Class<?> clazz, String string) {
            this.resourceAction = new WeakReference<ResourceAction>(resourceAction);
            this.resourceClass = clazz;
            this.actionPrefix = string;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ResourceAction resourceAction = (ResourceAction)this.resourceAction.get();
            if (resourceAction == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                resourceAction.readActionProperties((UserPreferences)propertyChangeEvent.getSource(), this.resourceClass, this.actionPrefix);
            }
        }
    }
}

