/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;

public class ScaledImageComponent
extends JComponent {
    private BufferedImage image;
    private boolean imageEnlargementEnabled;
    private float scaleMultiplier = 1.0f;

    public ScaledImageComponent() {
        this(null);
    }

    public ScaledImageComponent(BufferedImage bufferedImage) {
        this(bufferedImage, false);
    }

    public ScaledImageComponent(BufferedImage bufferedImage, boolean bl) {
        this.image = bufferedImage;
        this.imageEnlargementEnabled = bl;
        this.setBorder(BorderFactory.createEtchedBorder(1));
    }

    public Dimension getPreferredSize() {
        float f;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.image == null) {
            return new Dimension(300 + n, 300 + n2);
        }
        if (this.getParent() instanceof JViewport) {
            float f2;
            Dimension dimension = ((JViewport)this.getParent()).getExtentSize();
            dimension.width -= n;
            dimension.height -= n2;
            float f3 = (float)this.image.getWidth() / (float)dimension.width;
            if (f3 > (f2 = (float)this.image.getHeight() / (float)dimension.height)) {
                return new Dimension((int)((float)dimension.width * this.scaleMultiplier) + n, (int)((float)this.image.getHeight() / f3 * this.scaleMultiplier) + n2);
            }
            return new Dimension((int)((float)this.image.getWidth() / f2 * this.scaleMultiplier) + n, (int)((float)dimension.height * this.scaleMultiplier) + n2);
        }
        int n3 = 300 - n;
        int n4 = 300 - n2;
        float f4 = (float)this.image.getWidth() / (float)n3;
        if (f4 > (f = (float)this.image.getHeight() / (float)n4)) {
            return new Dimension((int)((float)n3 * this.scaleMultiplier) + n, (int)((float)this.image.getHeight() / f4 * this.scaleMultiplier) + n2);
        }
        return new Dimension((int)((float)this.image.getWidth() / f * this.scaleMultiplier) + n, (int)((float)n4 * this.scaleMultiplier) + n2);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paintImage(graphics, null);
    }

    protected void paintImage(Graphics graphics, AlphaComposite alphaComposite) {
        if (this.image != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            AffineTransform affineTransform = graphics2D.getTransform();
            Composite composite = graphics2D.getComposite();
            Point point = this.getImageTranslation();
            graphics2D.translate(point.x, point.y);
            float f = this.getImageScale();
            graphics2D.scale(f, f);
            if (alphaComposite != null) {
                graphics2D.setComposite(alphaComposite);
            }
            graphics2D.drawImage((Image)this.image, 0, 0, this);
            graphics2D.setComposite(composite);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    protected float getImageScale() {
        float f;
        if (this.image != null) {
            Dimension dimension = this.getParent() instanceof JViewport ? ((JViewport)this.getParent()).getExtentSize() : this.getSize();
            Insets insets = this.getInsets();
            f = Math.min((float)(dimension.width - insets.left - insets.right) / (float)this.image.getWidth(), (float)(dimension.height - insets.top - insets.bottom) / (float)this.image.getHeight());
            if (!this.imageEnlargementEnabled) {
                f = Math.min(1.0f, f);
            }
        } else {
            f = 1.0f;
        }
        return f * this.scaleMultiplier;
    }

    public float getScaleMultiplier() {
        return this.scaleMultiplier;
    }

    public void setScaleMultiplier(float f) {
        this.scaleMultiplier = f;
        this.revalidate();
        this.repaint();
    }

    protected Point getImageTranslation() {
        float f = this.getImageScale();
        Insets insets = this.getInsets();
        return new Point(insets.left + (this.getWidth() - insets.left - insets.right - Math.round((float)this.image.getWidth() * f)) / 2, insets.top + (this.getHeight() - insets.top - insets.bottom - Math.round((float)this.image.getHeight() * f)) / 2);
    }

    protected boolean isPointInImage(int n, int n2) {
        Point point = this.getImageTranslation();
        float f = this.getImageScale();
        return n >= point.x && n < point.x + Math.round((float)this.getImage().getWidth() * f) && n2 >= point.y && n2 < point.y + Math.round((float)this.getImage().getHeight() * f);
    }

    protected Point getPointConstrainedInImage(int n, int n2) {
        Point point = this.getImageTranslation();
        float f = this.getImageScale();
        n = Math.min(Math.max(n, point.x), point.x + Math.round((float)this.getImage().getWidth() * f));
        n2 = Math.min(Math.max(n2, point.y), point.y + Math.round((float)this.getImage().getHeight() * f));
        return new Point(n, n2);
    }
}

