/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.julbridge;

import java.util.Enumeration;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.logging.julbridge.JULBridgeFilter;
import org.apache.logging.julbridge.JULBridgeHandler;
import org.apache.logging.julbridge.JULLevelConverter;
import org.apache.logging.julbridge.JULLog4jEventConverter;

public class JULLog4jBridge {
    public static void bridgeJULLogger(String JULLoggerName) {
        JULLog4jBridge.bridgeJULLogger(JULLoggerName, org.apache.log4j.LogManager.getLoggerRepository(), JULLog4jEventConverter.DEFAULT_LEVEL_CONVERTER);
    }

    public static void bridgeJULLogger(String JULLoggerName, LoggerRepository repository) {
        JULLog4jBridge.bridgeJULLogger(JULLoggerName, repository, JULLog4jEventConverter.DEFAULT_LEVEL_CONVERTER);
    }

    public static void bridgeJULLogger(String JULLoggerName, LoggerRepository repository, JULLevelConverter levelConverter) {
        org.apache.log4j.Logger log4jLogger = repository.getLogger(JULLoggerName);
        Logger JULLogger = Logger.getLogger(JULLoggerName);
        JULLogger.setFilter(new JULBridgeFilter(JULLogger.getFilter(), log4jLogger, new JULLog4jEventConverter(repository, levelConverter)));
    }

    public static void assimilate(LoggerRepository repository, JULLevelConverter levelConverter) {
        LogManager.getLogManager().reset();
        Logger.getLogger("").setLevel(levelConverter.convertLog4jLevel(repository.getThreshold()));
        Logger.getLogger("").addHandler(new JULBridgeHandler(repository, new JULLog4jEventConverter(repository, levelConverter)));
    }

    private static void clearAllFilters(LogManager logManager) {
        Enumeration<String> enumeration = logManager.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            Logger logger = logManager.getLogger(enumeration.nextElement().toString());
            logger.setFilter(null);
        }
    }

    public static void assimilate(LoggerRepository repository) {
        JULLog4jBridge.assimilate(repository, JULLog4jEventConverter.DEFAULT_LEVEL_CONVERTER);
    }

    public static void assimilate() {
        JULLog4jBridge.assimilate(org.apache.log4j.LogManager.getLoggerRepository());
    }

    public static void repatriate() {
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> loggerNames = logManager.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            logManager.getLogger(loggerNames.nextElement().toString()).setFilter(null);
        }
        logManager.reset();
    }
}

