/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.util;

import ch.csnc.extension.util.Encoding;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class EncodingUnitTest {
    @Test
    public void shouldConvertDataIntoCorrectBase64String() {
        Assert.assertThat((Object)Encoding.base64encode("Hello World".getBytes()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"SGVsbG8gV29ybGQ=")));
    }

    @Test
    public void shouldConvertBase64StringIntoCorrectData() {
        Assert.assertThat((Object)Encoding.base64decode("SGVsbG8gV29ybGQ="), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Hello World".getBytes())));
    }

    @Test
    public void shouldConvertDataIntoCorrectHexString() {
        Assert.assertThat((Object)Encoding.toHexString("Hello World".getBytes()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"48656c6c6f20576f726c64")));
    }

    @Test
    public void shouldConvertStringIntoCorrectMD5Hash() {
        Assert.assertThat((Object)Encoding.hashMD5("Hello World"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"b10a8db164e0754105b7a99be72e3fe5")));
    }

    @Test
    public void shouldConvertStringIntoCorrectSHAHash() {
        Assert.assertThat((Object)Encoding.hashSHA("Hello World"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"0a4d55a8d778e5022fab701977c5d840bbc486d0")));
    }

    @Test
    public void shouldConvertStringIntoCorrectRot13Cipher() {
        Assert.assertThat((Object)Encoding.rot13("Hello World"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Uryyb Jbeyq")));
    }

    @Test
    public void shouldEncodeStringIntoCorrectUrlString() {
        Assert.assertThat((Object)Encoding.urlEncode("He//o Wor/d"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"He%2F%2Fo+Wor%2Fd")));
    }

    @Test
    public void shouldDecodeUrlStringIntoCorrectString() {
        Assert.assertThat((Object)Encoding.urlDecode("He%2F%2Fo+Wor%2Fd"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"He//o Wor/d")));
    }
}

