/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JCheckBoxTree
extends JTree {
    private static final long serialVersionUID = -4194122328392241790L;
    HashMap<TreePath, CheckedNode> nodesCheckingState;
    HashSet<TreePath> checkedPaths = new HashSet();
    protected EventListenerList listenerList = new EventListenerList();

    public void addCheckChangeEventListener(CheckChangeEventListener checkChangeEventListener) {
        this.listenerList.add(CheckChangeEventListener.class, checkChangeEventListener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener checkChangeEventListener) {
        this.listenerList.remove(CheckChangeEventListener.class, checkChangeEventListener);
    }

    void fireCheckChangeEvent(CheckChangeEvent checkChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)objectArray[i + 1]).checkStateChanged(checkChangeEvent);
        }
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.resetCheckingState();
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[this.checkedPaths.size()]);
    }

    public boolean isSelectedPartially(TreePath treePath) {
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath);
        return checkedNode.isSelected && checkedNode.hasChildren && !checkedNode.allChildrenSelected;
    }

    private void resetCheckingState() {
        this.nodesCheckingState = new HashMap();
        this.checkedPaths = new HashSet();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(defaultMutableTreeNode);
    }

    private void addSubtreeToCheckingStateTracking(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object[] objectArray = defaultMutableTreeNode.getPath();
        TreePath treePath = new TreePath(objectArray);
        CheckedNode checkedNode = new CheckedNode(false, defaultMutableTreeNode.getChildCount() > 0, false);
        this.nodesCheckingState.put(treePath, checkedNode);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.addSubtreeToCheckingStateTracking((DefaultMutableTreeNode)treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i)).getLastPathComponent());
        }
    }

    public JCheckBoxTree() {
        this.setToggleClickCount(0);
        CheckBoxCellRenderer checkBoxCellRenderer = new CheckBoxCellRenderer();
        this.setCellRenderer(checkBoxCellRenderer);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -8190634240451667286L;

            @Override
            public void setSelectionPath(TreePath treePath) {
            }

            @Override
            public void addSelectionPath(TreePath treePath) {
            }

            @Override
            public void removeSelectionPath(TreePath treePath) {
            }

            @Override
            public void setSelectionPaths(TreePath[] treePathArray) {
            }
        };
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = JCheckBoxTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (!JCheckBoxTree.this.nodesCheckingState.get((Object)treePath).isCheckBoxEnabled) {
                    return;
                }
                boolean bl = !JCheckBoxTree.this.nodesCheckingState.get((Object)treePath).isSelected;
                JCheckBoxTree.this.checkSubTree(treePath, bl);
                JCheckBoxTree.this.updatePredecessorsWithCheckMode(treePath, bl);
                JCheckBoxTree.this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
                JCheckBoxTree.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.setSelectionModel(defaultTreeSelectionModel);
    }

    protected void updatePredecessorsWithCheckMode(TreePath treePath, boolean bl) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return;
        }
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath2);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
        checkedNode.allChildrenSelected = true;
        checkedNode.isSelected = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreePath treePath3 = treePath2.pathByAddingChild(defaultMutableTreeNode.getChildAt(i));
            CheckedNode checkedNode2 = this.nodesCheckingState.get(treePath3);
            if (!checkedNode2.allChildrenSelected) {
                checkedNode.allChildrenSelected = false;
            }
            if (!checkedNode2.isSelected) continue;
            checkedNode.isSelected = true;
        }
        if (checkedNode.isSelected) {
            this.checkedPaths.add(treePath2);
        } else {
            this.checkedPaths.remove(treePath2);
        }
        this.updatePredecessorsWithCheckMode(treePath2, bl);
    }

    public void checkSubTree(TreePath treePath, boolean bl) {
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath);
        checkedNode.isSelected = bl;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.checkSubTree(treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i)), bl);
        }
        checkedNode.allChildrenSelected = bl;
        if (bl) {
            this.checkedPaths.add(treePath);
        } else {
            this.checkedPaths.remove(treePath);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapseAll() {
        for (int i = this.getRowCount(); i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public boolean isSelectedFully(TreePath treePath) {
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath);
        return checkedNode.isSelected && (!checkedNode.hasChildren || checkedNode.allChildrenSelected);
    }

    public void check(TreePath treePath, boolean bl) {
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath);
        checkedNode.isSelected = bl;
        if (bl) {
            this.checkedPaths.add(treePath);
        } else {
            this.checkedPaths.remove(treePath);
        }
    }

    public void setCheckBoxEnabled(TreePath treePath, boolean bl) {
        this.nodesCheckingState.get((Object)treePath).isCheckBoxEnabled = bl;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(new Dimension(500, 500));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setSize(new Dimension(500, 500));
        jFrame.getContentPane().add(jPanel);
        JCheckBoxTree jCheckBoxTree = new JCheckBoxTree();
        jCheckBoxTree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jCheckBoxTree);
        jPanel.add((Component)jScrollPane, "Center");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Tech");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Db");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HypersonicSQL"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("MsSQL"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("MySQL"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Oracle"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PostgreSQL"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("OS");
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Linux"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("WS");
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        jCheckBoxTree.setModel(defaultTreeModel);
        jFrame.setVisible(true);
    }

    private class CheckBoxCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7341833835878991719L;
        JCheckBox checkBox;
        JLabel altLabel;

        public CheckBoxCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.altLabel = new JLabel("");
            this.add((Component)this.checkBox, "Center");
            this.add((Component)this.altLabel, "East");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            CheckedNode checkedNode = JCheckBoxTree.this.nodesCheckingState.get(treePath);
            if (checkedNode == null) {
                return this;
            }
            if (checkedNode.isCheckBoxEnabled) {
                this.checkBox.setSelected(checkedNode.isSelected);
                this.checkBox.setOpaque(checkedNode.isSelected && checkedNode.hasChildren && !checkedNode.allChildrenSelected);
                this.checkBox.setVisible(true);
                this.checkBox.setEnabled(true);
                this.altLabel.setText(object2.toString() + "          ");
            } else {
                this.checkBox.setVisible(false);
                this.checkBox.setEnabled(false);
                this.altLabel.setText(object2.toString());
            }
            return this;
        }
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public class CheckChangeEvent
    extends EventObject {
        private static final long serialVersionUID = -8100230309044193368L;

        public CheckChangeEvent(Object object) {
            super(object);
        }
    }

    private class CheckedNode {
        boolean isSelected;
        boolean hasChildren;
        boolean allChildrenSelected;
        boolean isCheckBoxEnabled = true;

        public CheckedNode(boolean bl, boolean bl2, boolean bl3) {
            this.isSelected = bl;
            this.hasChildren = bl2;
            this.allChildrenSelected = bl3;
        }
    }
}

