/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MulticolumnAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.VerticalBox;
import org.scilab.forge.jlatexmath.VlineAtom;

public class MatrixAtom
extends Atom {
    public static SpaceAtom hsep = new SpaceAtom(0, 1.0f, 0.0f, 0.0f);
    public static SpaceAtom semihsep = new SpaceAtom(0, 0.5f, 0.0f, 0.0f);
    public static SpaceAtom vsep_in = new SpaceAtom(1, 0.0f, 1.0f, 0.0f);
    public static SpaceAtom vsep_ext_top = new SpaceAtom(1, 0.0f, 0.4f, 0.0f);
    public static SpaceAtom vsep_ext_bot = new SpaceAtom(1, 0.0f, 0.4f, 0.0f);
    public static final int ARRAY = 0;
    public static final int MATRIX = 1;
    public static final int ALIGN = 2;
    public static final int ALIGNAT = 3;
    public static final int FLALIGN = 4;
    public static final int SMALLMATRIX = 5;
    public static final int ALIGNED = 6;
    public static final int ALIGNEDAT = 7;
    private static final Box nullBox = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    private ArrayOfAtoms matrix;
    private int[] position;
    private Map<Integer, VlineAtom> vlines = new HashMap<Integer, VlineAtom>();
    private boolean isAlign;
    private boolean isAlignat;
    private boolean isFl;
    private int type;
    private boolean isPartial;
    private boolean spaceAround;
    private static SpaceAtom align = new SpaceAtom(2);

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, String string, boolean bl2) {
        this.isPartial = bl;
        this.matrix = arrayOfAtoms;
        this.type = 0;
        this.spaceAround = bl2;
        this.parsePositions(new StringBuffer(string));
    }

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, String string) {
        this(bl, arrayOfAtoms, string, false);
    }

    public MatrixAtom(ArrayOfAtoms arrayOfAtoms, String string) {
        this(false, arrayOfAtoms, string);
    }

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, int n) {
        this(bl, arrayOfAtoms, n, false);
    }

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, int n, boolean bl2) {
        this.isPartial = bl;
        this.matrix = arrayOfAtoms;
        this.type = n;
        this.spaceAround = bl2;
        if (n != 1 && n != 5) {
            this.position = new int[this.matrix.col];
            for (int i = 0; i < this.matrix.col; i += 2) {
                this.position[i] = 1;
                if (i + 1 >= this.matrix.col) continue;
                this.position[i + 1] = 0;
            }
        } else {
            this.position = new int[this.matrix.col];
            for (int i = 0; i < this.matrix.col; ++i) {
                this.position[i] = 2;
            }
        }
    }

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, int n, int n2) {
        this(bl, arrayOfAtoms, n, n2, true);
    }

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, int n, int n2, boolean bl2) {
        this.isPartial = bl;
        this.matrix = arrayOfAtoms;
        this.type = n;
        this.spaceAround = bl2;
        this.position = new int[this.matrix.col];
        for (int i = 0; i < this.matrix.col; ++i) {
            this.position[i] = n2;
        }
    }

    public MatrixAtom(ArrayOfAtoms arrayOfAtoms, int n) {
        this(false, arrayOfAtoms, n);
    }

    private void parsePositions(StringBuffer stringBuffer) {
        int n;
        int n2 = stringBuffer.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block9: for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case 'l': {
                    arrayList.add(0);
                    continue block9;
                }
                case 'r': {
                    arrayList.add(1);
                    continue block9;
                }
                case 'c': {
                    arrayList.add(2);
                    continue block9;
                }
                case '|': {
                    n = 1;
                    while (++i < n2) {
                        c = stringBuffer.charAt(i);
                        if (c != '|') {
                            --i;
                            break;
                        }
                        ++n;
                    }
                    this.vlines.put(arrayList.size(), new VlineAtom(n));
                    continue block9;
                }
                case '@': {
                    TeXFormula teXFormula = new TeXFormula();
                    TeXParser teXParser = new TeXParser(this.isPartial, stringBuffer.substring(++i), teXFormula, false);
                    Atom atom = teXParser.getArgument();
                    ++this.matrix.col;
                    for (int j = 0; j < this.matrix.row; ++j) {
                        this.matrix.array.get(j).add(arrayList.size(), atom);
                    }
                    arrayList.add(5);
                    i += teXParser.getPos();
                    --i;
                    continue block9;
                }
                case '*': {
                    TeXFormula teXFormula = new TeXFormula();
                    TeXParser teXParser = new TeXParser(this.isPartial, stringBuffer.substring(++i), teXFormula, false);
                    String[] stringArray = teXParser.getOptsArgs(2, 0);
                    i += teXParser.getPos();
                    int n3 = Integer.parseInt(stringArray[1]);
                    String string = "";
                    for (int j = 0; j < n3; ++j) {
                        string = string + stringArray[2];
                    }
                    stringBuffer.insert(i, string);
                    n2 = stringBuffer.length();
                    --i;
                    continue block9;
                }
                case '\t': 
                case ' ': {
                    continue block9;
                }
                default: {
                    arrayList.add(2);
                }
            }
        }
        for (n = arrayList.size(); n < this.matrix.col; ++n) {
            arrayList.add(2);
        }
        if (arrayList.size() != 0) {
            Integer[] integerArray = arrayList.toArray(new Integer[0]);
            this.position = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                this.position[i] = integerArray[i];
            }
        } else {
            this.position = new int[]{2};
        }
    }

    public Box[] getColumnSep(TeXEnvironment teXEnvironment, float f) {
        int n = this.matrix.row;
        int n2 = this.matrix.col;
        Box[] boxArray = new Box[n2 + 1];
        float f2 = teXEnvironment.getTextwidth();
        if (this.type == 6 || this.type == 7) {
            f2 = Float.POSITIVE_INFINITY;
        }
        switch (this.type) {
            case 0: {
                int n3 = 1;
                if (this.position[0] == 5) {
                    boxArray[1] = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                    n3 = 2;
                }
                boxArray[0] = this.spaceAround ? semihsep.createBox(teXEnvironment) : new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                boxArray[n2] = boxArray[0];
                Box box = hsep.createBox(teXEnvironment);
                while (n3 < n2) {
                    if (this.position[n3] == 5) {
                        boxArray[n3] = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                        boxArray[n3 + 1] = boxArray[n3];
                        ++n3;
                    } else {
                        boxArray[n3] = box;
                    }
                    ++n3;
                }
                return boxArray;
            }
            case 1: 
            case 5: {
                boxArray[0] = nullBox;
                boxArray[n2] = boxArray[0];
                Box box = hsep.createBox(teXEnvironment);
                for (int i = 1; i < n2; ++i) {
                    boxArray[i] = box;
                }
                return boxArray;
            }
            case 2: 
            case 6: {
                Box box;
                Box box2 = align.createBox(teXEnvironment);
                if (f2 != Float.POSITIVE_INFINITY) {
                    float f3 = Math.max((f2 - f - (float)(n2 / 2) * box2.getWidth()) / (float)Math.floor((n2 + 3) / 2), 0.0f);
                    box = new StrutBox(f3, 0.0f, 0.0f, 0.0f);
                } else {
                    box = hsep.createBox(teXEnvironment);
                }
                boxArray[n2] = box;
                for (int i = 0; i < n2; ++i) {
                    boxArray[i] = i % 2 == 0 ? box : box2;
                }
                break;
            }
            case 3: 
            case 7: {
                float f4 = f2 != Float.POSITIVE_INFINITY ? Math.max((f2 - f) / 2.0f, 0.0f) : 0.0f;
                Box box = align.createBox(teXEnvironment);
                Box box3 = nullBox;
                boxArray[0] = new StrutBox(f4, 0.0f, 0.0f, 0.0f);
                boxArray[n2] = boxArray[0];
                for (int i = 1; i < n2; ++i) {
                    boxArray[i] = i % 2 == 0 ? box3 : box;
                }
                break;
            }
            case 4: {
                Box box;
                Box box4 = align.createBox(teXEnvironment);
                if (f2 != Float.POSITIVE_INFINITY) {
                    float f5 = Math.max((f2 - f - (float)(n2 / 2) * box4.getWidth()) / (float)Math.floor((n2 - 1) / 2), 0.0f);
                    box = new StrutBox(f5, 0.0f, 0.0f, 0.0f);
                } else {
                    box = hsep.createBox(teXEnvironment);
                }
                boxArray[0] = nullBox;
                boxArray[n2] = boxArray[0];
                for (int i = 1; i < n2; ++i) {
                    boxArray[i] = i % 2 == 0 ? box : box4;
                }
                break;
            }
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            boxArray[0] = nullBox;
            boxArray[n2] = boxArray[0];
        }
        return boxArray;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        int n;
        int n2;
        int n3 = this.matrix.row;
        int n4 = this.matrix.col;
        Box[][] boxArray = new Box[n3][n4];
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[n4];
        float f = 0.0f;
        float f2 = teXEnvironment.getTeXFont().getDefaultRuleThickness(teXEnvironment.getStyle());
        if (this.type == 5) {
            teXEnvironment = teXEnvironment.copy();
            teXEnvironment.setStyle(4);
        }
        ArrayList<MulticolumnAtom> arrayList = new ArrayList<MulticolumnAtom>();
        for (n2 = 0; n2 < n3; ++n2) {
            fArray[n2] = 0.0f;
            fArray2[n2] = 0.0f;
            for (int i = 0; i < n4; ++i) {
                Atom atom = null;
                try {
                    atom = this.matrix.array.get(n2).get(i);
                }
                catch (Exception exception) {
                    boxArray[n2][i - 1].type = 11;
                    i = n4 - 1;
                }
                boxArray[n2][i] = atom == null ? nullBox : atom.createBox(teXEnvironment);
                fArray[n2] = Math.max(boxArray[n2][i].getDepth(), fArray[n2]);
                fArray2[n2] = Math.max(boxArray[n2][i].getHeight(), fArray2[n2]);
                if (boxArray[n2][i].type != 12) {
                    fArray3[i] = Math.max(boxArray[n2][i].getWidth(), fArray3[i]);
                    continue;
                }
                ((MulticolumnAtom)atom).setRowColumn(n2, i);
                arrayList.add((MulticolumnAtom)atom);
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            MulticolumnAtom multicolumnAtom = (MulticolumnAtom)arrayList.get(n2);
            int n5 = multicolumnAtom.getCol();
            int n6 = multicolumnAtom.getRow();
            int n7 = multicolumnAtom.getSkipped();
            float f3 = 0.0f;
            for (int i = n5; i < n5 + n7; ++i) {
                f3 += fArray3[i];
            }
            if (!(boxArray[n6][n5].getWidth() > f3)) continue;
            float f4 = (boxArray[n6][n5].getWidth() - f3) / (float)n7;
            n = n5;
            while (n < n5 + n7) {
                int n8 = n++;
                fArray3[n8] = fArray3[n8] + f4;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            f += fArray3[n2];
        }
        Box[] boxArray2 = this.getColumnSep(teXEnvironment, f);
        for (int i = 0; i < n4 + 1; ++i) {
            f += boxArray2[i].getWidth();
            if (this.vlines.get(i) == null) continue;
            f += this.vlines.get(i).getWidth(teXEnvironment);
        }
        VerticalBox verticalBox = new VerticalBox();
        Box box = vsep_in.createBox(teXEnvironment);
        verticalBox.add(vsep_ext_top.createBox(teXEnvironment));
        float f5 = box.getHeight();
        float f6 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            HorizontalBox horizontalBox = new HorizontalBox();
            block15: for (n = 0; n < n4; ++n) {
                switch (boxArray[i][n].type) {
                    case -1: 
                    case 12: {
                        Object object;
                        Object object2;
                        if (n == 0) {
                            if (this.vlines.get(0) != null) {
                                VlineAtom vlineAtom = this.vlines.get(0);
                                vlineAtom.setHeight(fArray2[i] + fArray[i] + box.getHeight());
                                vlineAtom.setShift(fArray[i] + box.getHeight() / 2.0f);
                                object2 = vlineAtom.createBox(teXEnvironment);
                                horizontalBox.add(new HorizontalBox((Box)object2, boxArray2[0].getWidth() + ((Box)object2).getWidth(), 0));
                            } else {
                                horizontalBox.add(boxArray2[0]);
                            }
                        }
                        boolean bl = true;
                        if (boxArray[i][n].type == -1) {
                            horizontalBox.add(new HorizontalBox(boxArray[i][n], fArray3[n], this.position[n]));
                        } else {
                            object2 = this.generateMulticolumn(teXEnvironment, boxArray2, fArray3, i, n);
                            object = (MulticolumnAtom)this.matrix.array.get(i).get(n);
                            n += ((MulticolumnAtom)object).getSkipped() - 1;
                            horizontalBox.add((Box)object2);
                            bl = ((MulticolumnAtom)object).hasRightVline();
                        }
                        if (bl && this.vlines.get(n + 1) != null) {
                            object2 = this.vlines.get(n + 1);
                            ((VlineAtom)object2).setHeight(fArray2[i] + fArray[i] + box.getHeight());
                            ((VlineAtom)object2).setShift(fArray[i] + box.getHeight() / 2.0f);
                            object = ((VlineAtom)object2).createBox(teXEnvironment);
                            if (n < n4 - 1) {
                                horizontalBox.add(new HorizontalBox((Box)object, boxArray2[n + 1].getWidth() + ((Box)object).getWidth(), 2));
                                continue block15;
                            }
                            horizontalBox.add(new HorizontalBox((Box)object, boxArray2[n + 1].getWidth() + ((Box)object).getWidth(), 1));
                            continue block15;
                        }
                        horizontalBox.add(boxArray2[n + 1]);
                        continue block15;
                    }
                    case 11: {
                        float f7 = teXEnvironment.getTextwidth();
                        f7 = f7 == Float.POSITIVE_INFINITY ? fArray3[n] : f7;
                        horizontalBox = new HorizontalBox(boxArray[i][n], f7, 0);
                        n = n4 - 1;
                        continue block15;
                    }
                    case 13: {
                        Object object = (HlineAtom)this.matrix.array.get(i).get(n);
                        ((HlineAtom)object).setWidth(f);
                        if (i >= 1 && this.matrix.array.get(i - 1).get(n) instanceof HlineAtom) {
                            horizontalBox.add(new StrutBox(0.0f, 2.0f * f2, 0.0f, 0.0f));
                            ((HlineAtom)object).setShift(-box.getHeight() / 2.0f + f2);
                        } else {
                            ((HlineAtom)object).setShift(-box.getHeight() / 2.0f);
                        }
                        horizontalBox.add(((HlineAtom)object).createBox(teXEnvironment));
                        n = n4;
                    }
                }
            }
            if (boxArray[i][0].type != 13) {
                horizontalBox.setHeight(fArray2[i]);
                horizontalBox.setDepth(fArray[i]);
                verticalBox.add(horizontalBox);
                if (i >= n3 - 1) continue;
                verticalBox.add(box);
                continue;
            }
            verticalBox.add(horizontalBox);
        }
        verticalBox.add(vsep_ext_bot.createBox(teXEnvironment));
        f6 = verticalBox.getHeight() + verticalBox.getDepth();
        float f8 = teXEnvironment.getTeXFont().getAxisHeight(teXEnvironment.getStyle());
        verticalBox.setHeight(f6 / 2.0f + f8);
        verticalBox.setDepth(f6 / 2.0f - f8);
        return verticalBox;
    }

    private Box generateMulticolumn(TeXEnvironment teXEnvironment, Box[] boxArray, float[] fArray, int n, int n2) {
        int n3;
        float f = 0.0f;
        MulticolumnAtom multicolumnAtom = (MulticolumnAtom)this.matrix.array.get(n).get(n2);
        int n4 = multicolumnAtom.getSkipped();
        for (n3 = n2; n3 < n2 + n4 - 1; ++n3) {
            f += fArray[n3] + boxArray[n3 + 1].getWidth();
            if (this.vlines.get(n3 + 1) == null) continue;
            f += this.vlines.get(n3 + 1).getWidth(teXEnvironment);
        }
        f += fArray[n3];
        Box box = multicolumnAtom.createBox(teXEnvironment);
        float f2 = box.getWidth();
        if (f2 > f) {
            f = 0.0f;
        }
        multicolumnAtom.setWidth(f);
        box = multicolumnAtom.createBox(teXEnvironment);
        return box;
    }
}

