/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.truetype.TTFontHeader;
import de.intarsys.cwt.font.truetype.TTFontParser;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TTHorizontalHeader;
import de.intarsys.cwt.font.truetype.TTMetrics;
import de.intarsys.cwt.font.truetype.TTNaming;
import de.intarsys.cwt.font.truetype.TTPostScriptInformation;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.cwt.font.truetype.TrueTypeException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class TTFont {
    public static final int ARG_1_AND_2_ARE_WORDS = 1;
    public static final int MORE_COMPONENTS = 32;
    public static final int SFNT_TRUETYPE = 65536;
    public static final byte[] TABLE_CMAP = "cmap".getBytes();
    public static final byte[] TABLE_CVT = "cvt ".getBytes();
    public static final byte[] TABLE_FGPM = "fpgm".getBytes();
    public static final byte[] TABLE_GLYF = "glyf".getBytes();
    public static final byte[] TABLE_HEAD = "head".getBytes();
    public static final byte[] TABLE_HHEA = "hhea".getBytes();
    public static final byte[] TABLE_HMTX = "hmtx".getBytes();
    public static final byte[] TABLE_LOCA = "loca".getBytes();
    public static final byte[] TABLE_MAXP = "maxp".getBytes();
    public static final byte[] TABLE_NAME = "name".getBytes();
    public static final byte[] TABLE_OS2 = "OS/2".getBytes();
    public static final byte[] TABLE_POST = "post".getBytes();
    public static final byte[] TABLE_PREP = "prep".getBytes();
    public static final int WE_HAVE_A_SCALE = 8;
    public static final int WE_HAVE_A_TWO_BY_TWO = 128;
    public static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private Map cmaps;
    private String fontFamilyName = null;
    private TTFontHeader fontHeader;
    private FontStyle fontStyle = FontStyle.REGULAR;
    private int[] glyphWidths;
    private TTHorizontalHeader horizontalHeader;
    private ILocator locator;
    private TTMetrics metrics;
    private TTNaming naming;
    private TTPostScriptInformation postScriptInformation;
    private String psName = null;
    private int sfntVersion;
    private TTTable[] tables;

    public static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public static TTFont createFromLocator(ILocator iLocator) throws IOException {
        TTFont tTFont = new TTFont();
        tTFont.setLocator(iLocator);
        tTFont.initializeFromLocator();
        return tTFont;
    }

    protected TTFont() {
    }

    public Map getCMaps() throws TrueTypeException {
        if (this.cmaps == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.cmaps = tTFontParser.parseTable_cmap(this.getTable(TABLE_CMAP));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.cmaps;
    }

    public Map getCMapsAt(int n, int n2) throws TrueTypeException {
        String string = n + ":" + n2;
        Object object = this.getCMaps().get(string);
        if (object instanceof TTTable) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                Map map = tTFontParser.parseTable_cmap_subtable((TTTable)object);
                this.getCMaps().put(string, map);
                object = map;
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return (Map)object;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public TTFontHeader getFontHeader() throws TrueTypeException {
        if (this.fontHeader == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.fontHeader = tTFontParser.parseTable_head(this.getTable(TABLE_HEAD));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.fontHeader;
    }

    public String getFontName() {
        return this.getPsName();
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public int getGlyphWidth(int n) throws TrueTypeException {
        if (n < this.getGlyphWidths().length) {
            return this.getGlyphWidths()[n];
        }
        return this.getGlyphWidths()[this.getGlyphWidths().length - 1];
    }

    protected int[] getGlyphWidths() throws TrueTypeException {
        if (this.glyphWidths == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.glyphWidths = tTFontParser.parseTable_hmtx(this.getTable(TABLE_HMTX), this.getHorizontalHeader().getNumberOfHMetrics());
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.glyphWidths;
    }

    public TTHorizontalHeader getHorizontalHeader() throws TrueTypeException {
        if (this.horizontalHeader == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.horizontalHeader = tTFontParser.parseTable_hhea(this.getTable(TABLE_HHEA));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.horizontalHeader;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public TTMetrics getMetrics() throws TrueTypeException {
        if (this.metrics == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.metrics = tTFontParser.parseTable_os2(this.getTable(TABLE_OS2));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.metrics;
    }

    public TTNaming getNaming() throws TrueTypeException {
        if (this.naming == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                TTTable tTTable = this.getTable(TABLE_NAME);
                if (tTTable != null) {
                    this.naming = tTFontParser.parseTable_name(tTTable);
                }
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.naming;
    }

    public TTPostScriptInformation getPostScriptInformation() throws TrueTypeException {
        if (this.postScriptInformation == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.postScriptInformation = tTFontParser.parseTable_post(this.getTable(TABLE_POST));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.postScriptInformation;
    }

    public String getPsName() {
        return this.psName;
    }

    public int getSfntVersion() {
        return this.sfntVersion;
    }

    public TTTable getTable(byte[] byArray) {
        int n = 0;
        while (n < this.getTables().length) {
            TTTable tTTable = this.tables[n];
            if (Arrays.equals(tTTable.getName(), byArray)) {
                return tTTable;
            }
            ++n;
        }
        return null;
    }

    public TTTable[] getTables() {
        return this.tables;
    }

    protected void initializeFromLocator() throws IOException {
        IRandomAccess iRandomAccess = null;
        try {
            iRandomAccess = this.getLocator().getRandomAccess();
            TTFontParser tTFontParser = new TTFontParser();
            tTFontParser.parseTables(this);
            try {
                this.setFontName(this);
            }
            catch (TrueTypeException trueTypeException) {
                throw new IOException(trueTypeException.getMessage());
            }
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public void removeCMapsAt(int n, int n2) throws TrueTypeException, IOException {
        TTTable tTTable = this.getTable(TABLE_CMAP);
        if (tTTable == null) {
            return;
        }
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        TTFontSerializer tTFontSerializer = new TTFontSerializer();
        TTFontParser tTFontParser = new TTFontParser();
        try {
            iRandomAccess.seek(0L);
            short s = tTFontParser.readShort(iRandomAccess);
            int n3 = tTFontParser.readUShort(iRandomAccess);
            int n4 = 0;
            long l = iRandomAccess.getOffset();
            long l2 = iRandomAccess.getOffset();
            while (n4 < n3) {
                iRandomAccess.seek(l);
                int n5 = tTFontParser.readUShort(iRandomAccess);
                int n6 = tTFontParser.readUShort(iRandomAccess);
                int n7 = tTFontParser.readInt(iRandomAccess);
                if (n != n5 || n2 != n6) {
                    if (l != l2) {
                        iRandomAccess.seek(l2);
                        tTFontSerializer.writeShort(iRandomAccess, n5);
                        tTFontSerializer.writeShort(iRandomAccess, n6);
                        tTFontSerializer.writeInt(iRandomAccess, n7);
                    }
                    l2 += 8L;
                }
                l += 8L;
                ++n4;
            }
            if (l != l2) {
                iRandomAccess.seek(l2);
                tTFontSerializer.writeShort(iRandomAccess, 0);
                tTFontSerializer.writeShort(iRandomAccess, 0);
                tTFontSerializer.writeInt(iRandomAccess, 0);
                iRandomAccess.seek(0L);
                iRandomAccess.seekBy(2L);
                tTFontSerializer.writeShort(iRandomAccess, n3 - 1);
            }
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
        this.cmaps = null;
    }

    protected void setFontFamilyName(String string) {
        this.fontFamilyName = string;
    }

    protected void setFontName(TTFont tTFont) throws TrueTypeException {
        TTNaming tTNaming = tTFont.getNaming();
        if (tTNaming != null) {
            tTFont.setFontFamilyName(tTNaming.getValue(1));
            String string = tTNaming.getValue(2);
            tTFont.setFontStyle(FontStyle.getFontStyle(string));
            tTFont.setPsName(tTNaming.getValue(6));
            if (tTFont.getPsName() == null) {
                tTFont.setPsName(String.valueOf(tTFont.getFontFamilyName()) + "-" + tTFont.getFontStyle().getId());
            }
        }
    }

    protected void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    protected void setLocator(ILocator iLocator) {
        this.locator = iLocator;
    }

    public void setPsName(String string) {
        this.psName = string;
    }

    protected void setSfntVersion(int n) {
        this.sfntVersion = n;
    }

    protected void setTables(TTTable[] tTTableArray) {
        this.tables = tTTableArray;
    }
}

