/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.IPrediction;
import de.intarsys.pdf.filter.PredictionFactory;
import de.intarsys.pdf.filter.StreamBasedFilter;
import de.intarsys.tools.pool.GenericPool;
import de.intarsys.tools.pool.IPool;
import de.intarsys.tools.pool.IPoolObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class FlateFilter
extends StreamBasedFilter {
    private static IPoolObjectFactory deflaterFactory = new IPoolObjectFactory(){

        public void destroyObject(Object object) throws Exception {
            ((Deflater)object).end();
        }

        public void deactivateObject(Object object) throws Exception {
            ((Deflater)object).reset();
        }

        public Object createObject() throws Exception {
            return new Deflater();
        }

        public void activateObject(Object object) throws Exception {
        }
    };
    private static IPoolObjectFactory inflaterFactory = new IPoolObjectFactory(){

        public void destroyObject(Object object) throws Exception {
            ((Inflater)object).end();
        }

        public void deactivateObject(Object object) throws Exception {
            ((Inflater)object).reset();
        }

        public Object createObject() throws Exception {
            return new Inflater();
        }

        public void activateObject(Object object) throws Exception {
        }
    };
    private static IPool DeflaterPool = new GenericPool(deflaterFactory);
    private static IPool InflaterPool = new GenericPool(inflaterFactory);

    public FlateFilter(COSDictionary cOSDictionary) {
        super(cOSDictionary);
    }

    @Override
    protected InputStream createInputFilterStream(InputStream inputStream) throws IOException {
        Inflater inflater = FlateFilter.borrowInflater();
        return new PDFInflaterOutputStream(inputStream, inflater, 1024);
    }

    @Override
    protected OutputStream createOutputFilterStream(OutputStream outputStream) throws IOException {
        Deflater deflater = FlateFilter.borrowDeflater();
        return new PDFDeflaterOutputStream(outputStream, deflater, 1024);
    }

    protected static Deflater borrowDeflater() throws IOException {
        try {
            return (Deflater)DeflaterPool.checkout(-1L);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("can't create deflater");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected static Inflater borrowInflater() throws IOException {
        try {
            return (Inflater)InflaterPool.checkout(-1L);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("can't create inflater");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected static void returnInflater(Object object) {
        try {
            InflaterPool.checkin(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void returnDeflater(Object object) {
        try {
            DeflaterPool.checkin(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected byte[] decode(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray2 = super.decode(byArray);
        if (this.getOptions() == null) {
            return byArray2;
        }
        IPrediction iPrediction = PredictionFactory.get().createPrediction(this.getOptions());
        return iPrediction.decode(byArray2);
    }

    static class PDFDeflaterOutputStream
    extends DeflaterOutputStream {
        public PDFDeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) {
            super(outputStream, deflater, n);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FlateFilter.returnDeflater(this.def);
        }
    }

    static class PDFInflaterOutputStream
    extends InflaterInputStream {
        public PDFInflaterOutputStream(InputStream inputStream, Inflater inflater, int n) {
            super(inputStream, inflater, n);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FlateFilter.returnInflater(this.inf);
        }
    }
}

