/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import java.util.Set;

public class PDWidgetAnnotation
extends PDAnnotation {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_H = COSName.constant("H");
    public static final COSName CN_H_N = COSName.constant("N");
    public static final COSName CN_H_I = COSName.constant("I");
    public static final COSName CN_H_O = COSName.constant("O");
    public static final COSName CN_H_P = COSName.constant("P");
    public static final COSName CN_H_T = COSName.constant("T");
    public static final COSName DK_MK = COSName.constant("MK");
    public static final COSName CN_Subtype_Widget = COSName.constant("Widget");
    public static final COSName CN_State_Off = COSName.constant("Off");

    protected PDWidgetAnnotation(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    public boolean canReceiveFocus() {
        if (super.canReceiveFocus()) {
            PDAcroFormField pDAcroFormField = this.getAcroFormField();
            return !pDAcroFormField.isReadOnly() && (pDAcroFormField.isTypeTx() || pDAcroFormField.isTypeBtn() || pDAcroFormField.isTypeCh());
        }
        return false;
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Widget;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getAcroFormField().dispose(true);
    }

    public PDAcroFormField getAcroFormField() {
        return (PDAcroFormField)PDAcroFormField.META.createFromCos(this.cosGetDict());
    }

    public COSName getAltAppearanceState() {
        COSObject cOSObject;
        COSName cOSName = null;
        COSName cOSName2 = this.getAppearanceState();
        Set set = this.getAppearanceStates();
        set.add(COSName.create("Off"));
        Object object = set.iterator();
        while (object.hasNext()) {
            cOSObject = (COSName)object.next();
            if (((COSName)cOSObject).equals(cOSName2)) continue;
            cOSName = cOSObject;
            break;
        }
        if (this.getAcroFormField().isTypeBtn() && (cOSObject = ((PDAFButtonField)(object = (PDAFButtonField)this.getAcroFormField().getLogicalRoot())).cosGetOptions()) != null && !CN_State_Off.equals(cOSName)) {
            COSString cOSString = ((COSArray)cOSObject).get(Integer.parseInt(cOSName.stringValue())).asString();
            cOSName = COSName.create(cOSString.stringValue());
        }
        return cOSName;
    }

    public PDAppearanceCharacteristics getAppearanceCharacteristics() {
        return (PDAppearanceCharacteristics)PDAppearanceCharacteristics.META.createFromCos(this.cosGetField(DK_MK));
    }

    public COSName getHighlightingMode() {
        COSName cOSName = this.cosGetField(DK_H).asName();
        if (cOSName != null) {
            return cOSName;
        }
        return CN_H_I;
    }

    @Override
    public String getSubtypeLabel() {
        return "Widget";
    }

    public boolean isOff() {
        COSName cOSName = this.getAppearanceState();
        return cOSName == null || cOSName.equals(CN_State_Off);
    }

    @Override
    public boolean isWidgetAnnotation() {
        return true;
    }

    public void setAppearanceCharacteristics(PDAppearanceCharacteristics pDAppearanceCharacteristics) {
        this.setFieldObject(DK_MK, pDAppearanceCharacteristics);
    }

    public void setHighlightingMode(COSName cOSName) {
        if (cOSName == null || CN_H_I.equals(cOSName)) {
            this.cosRemoveField(DK_H);
        } else {
            this.cosSetField(DK_H, cOSName);
        }
    }

    public void transform(CDSRectangle cDSRectangle, CDSMatrix cDSMatrix) {
        int n = 0;
        PDAppearanceCharacteristics pDAppearanceCharacteristics = this.getAppearanceCharacteristics();
        if (pDAppearanceCharacteristics != null) {
            n = pDAppearanceCharacteristics.getRotation();
        }
        PDAnnotationTools.transform(cDSRectangle, cDSMatrix, n);
    }

    public static class MetaClass
    extends PDAnnotation.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDWidgetAnnotation(cOSObject);
        }
    }
}

