/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.XRefEntryVisitorException;

public class STXRefEntryFree
extends STXRefEntry {
    private STXRefEntryFree next = this;
    private STXRefEntryFree prev = this;
    private int nextFreeObject;

    public STXRefEntryFree(int n, int n2, int n3) {
        super(n, n2);
        this.nextFreeObject = n3;
    }

    @Override
    public void accept(IXRefEntryVisitor iXRefEntryVisitor) throws XRefEntryVisitorException {
        iXRefEntryVisitor.visitFromFree(this);
    }

    @Override
    public STXRefEntry copy() {
        return new STXRefEntryFree(this.getObjectNumber(), this.getGenerationNumber(), this.getNextFreeObjectNumber());
    }

    public void enqueue(STXRefEntryFree sTXRefEntryFree) {
        int n = this.getPrev().getObjectNumber();
        if (n == 0 || n < sTXRefEntryFree.getObjectNumber()) {
            sTXRefEntryFree.setNext(this);
            sTXRefEntryFree.setPrev(this.getPrev());
            this.getPrev().setNext(sTXRefEntryFree);
            this.setPrev(sTXRefEntryFree);
        } else {
            this.getPrev().enqueue(sTXRefEntryFree);
        }
    }

    @Override
    public STXRefEntryOccupied fill(int n) {
        this.unlink();
        return null;
    }

    @Override
    public long getColumn1() {
        return this.getNextFreeObjectNumber();
    }

    @Override
    public int getColumn2() {
        return this.getGenerationNumber();
    }

    protected STXRefEntryFree getNext() {
        return this.next;
    }

    public int getNextFreeObjectNumber() {
        return this.nextFreeObject;
    }

    protected STXRefEntryFree getPrev() {
        return this.prev;
    }

    @Override
    public boolean isFree() {
        return true;
    }

    @Override
    public COSObject load(STDocument sTDocument, ISystemSecurityHandler iSystemSecurityHandler) {
        return null;
    }

    private void setNext(STXRefEntryFree sTXRefEntryFree) {
        this.next = sTXRefEntryFree;
    }

    private void setPrev(STXRefEntryFree sTXRefEntryFree) {
        this.prev = sTXRefEntryFree;
    }

    @Override
    protected void unlink() {
        this.getPrev().setNext(this.getNext());
        this.getNext().setPrev(this.getPrev());
        this.setPrev(this);
        this.setNext(this);
    }
}

