/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class UnpackParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = -8889630614812210583L;
    public static final String F_ARG = "f";
    public static final String D_ARG = "d";
    public static final String O_ARG = "o";
    private File outputFile;
    private File inputDirectory;
    private PdfFile[] inputFileList;

    public UnpackParsedCommand() {
    }

    public UnpackParsedCommand(File outputFile, File inputDirectory, PdfFile[] inputFileList) {
        this.outputFile = outputFile;
        this.inputDirectory = inputDirectory;
        this.inputFileList = inputFileList;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public PdfFile[] getInputFileList() {
        return this.inputFileList;
    }

    public void setInputFileList(PdfFile[] inputFileList) {
        this.inputFileList = inputFileList;
    }

    public final String getCommand() {
        return "unpack";
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.outputFile == null ? "" : "[outputDir=" + this.outputFile.getAbsolutePath() + "]");
        if (this.inputFileList != null) {
            for (int i = 0; i < this.inputFileList.length; ++i) {
                retVal.append(this.inputFileList[i] == null ? "" : "[inputFileList[" + i + "]=" + this.inputFileList[i].getFile().getAbsolutePath() + "]");
            }
        }
        retVal.append(this.inputDirectory == null ? "" : "[inputDirectory=" + this.inputDirectory.getAbsolutePath() + "]");
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }
}

