/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.DecryptParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;
import org.pdfsam.console.utils.perfix.PrefixParser;

public class DecryptCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(DecryptCmdExecutor.class.getPackage().getName());
    private PdfReader pdfReader = null;
    private PdfStamper pdfStamper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof DecryptParsedCommand) {
            DecryptParsedCommand inputCommand = (DecryptParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            try {
                PdfFile[] fileList = inputCommand.getInputFileList();
                for (int i = 0; i < fileList.length; ++i) {
                    try {
                        PrefixParser prefixParser = new PrefixParser(inputCommand.getOutputFilesPrefix(), fileList[i].getFile().getName());
                        File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                        this.pdfReader = PdfUtility.readerFor(fileList[i]);
                        this.pdfReader.removeUnusedObjects();
                        this.pdfReader.consolidateNamedDestinations();
                        LOG.debug("Creating a new document.");
                        Character pdfVersion = inputCommand.getOutputPdfVersion();
                        this.pdfStamper = pdfVersion != null ? new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), inputCommand.getOutputPdfVersion().charValue()) : new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), this.pdfReader.getPdfVersion());
                        HashMap meta = this.pdfReader.getInfo();
                        meta.put("Creator", "pdfsam-console (Ver. 2.4.3e)");
                        this.setCompressionSettingOnStamper(inputCommand, this.pdfStamper);
                        this.pdfStamper.setMoreInfo(meta);
                        this.pdfStamper.close();
                        this.pdfReader.close();
                        File outFile = new File(inputCommand.getOutputFile(), prefixParser.generateFileName());
                        FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
                        LOG.debug("Decrypted file " + outFile.getCanonicalPath() + " created.");
                        this.setPercentageOfWorkDone((i + 1) * 1000 / fileList.length);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Error decrypting file " + fileList[i].getFile().getName(), e);
                    }
                }
                LOG.info("Pdf files decrypted in " + inputCommand.getOutputFile().getAbsolutePath() + ".");
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfStamper(this.pdfStamper);
    }
}

