/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;

    public InstanceOfExpression(Expression expression, TypeReference typeReference) {
        this.expression = expression;
        this.type = typeReference;
        typeReference.bits |= 0x40000000;
        this.bits |= 0x7C0;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = typeReference.sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FieldBinding fieldBinding;
        LocalVariableBinding localVariableBinding = this.expression.localVariableBinding();
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            FlowInfo flowInfo2 = flowInfo.copy();
            flowInfo2.markAsComparedEqualToNonNull(localVariableBinding);
            flowContext.recordUsingNullReference(blockScope, localVariableBinding, this.expression, 1025, flowInfo);
            return FlowInfo.conditional(flowInfo2, flowInfo.copy());
        }
        if (this.expression instanceof Reference && blockScope.compilerOptions().enableSyntacticNullAnalysisForFields && (fieldBinding = ((Reference)this.expression).lastFieldBinding()) != null && (fieldBinding.type.tagBits & 2L) == 0L) {
            flowContext.recordNullCheckedFieldReference((Reference)this.expression, 1);
        }
        return this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        this.expression.generateCode(blockScope, codeStream, true);
        codeStream.instance_of(this.type, this.type.resolvedType);
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.expression.printExpression(n, stringBuffer).append(" instanceof ");
        return this.type.print(0, stringBuffer);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        TypeBinding typeBinding2 = this.type.resolveType(blockScope, true);
        if (typeBinding != null && typeBinding2 != null && typeBinding2.hasNullTypeAnnotations() && (!typeBinding.isCompatibleWith(typeBinding2) || NullAnnotationMatching.analyse(typeBinding2, typeBinding, -1).isAnyMismatch())) {
            blockScope.problemReporter().nullAnnotationUnsupportedLocation(this.type);
        }
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        if (!typeBinding2.isReifiable()) {
            blockScope.problemReporter().illegalInstanceOfGenericType(typeBinding2, this);
        } else if (typeBinding2.isValidBinding() && (typeBinding != TypeBinding.NULL && typeBinding.isBaseType() || !this.checkCastTypesCompatibility(blockScope, typeBinding2, typeBinding, null))) {
            blockScope.problemReporter().notCompatibleTypesError(this, typeBinding, typeBinding2);
        }
        this.resolvedType = TypeBinding.BOOLEAN;
        return this.resolvedType;
    }

    @Override
    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
        if (this.expression.resolvedType != TypeBinding.NULL) {
            scope.problemReporter().unnecessaryInstanceof(this, typeBinding);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
            this.type.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

