/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;
import jcmdline.dto.PdfFile;

public class PdfFileParam
extends AbstractParameter {
    public static final int NO_ATTRIBUTES = 65535;
    public static final int EXISTS = 65534;
    public static final int IS_READABLE = 65519;
    public static final int IS_WRITEABLE = 65503;
    public static final String DEFAULT_FILE_OPTION_LABEL = Strings.get("PdfFileParam.defaultFileOptionLabel");
    private int attributes;

    public PdfFileParam(String tag, String desc) {
        this(tag, desc, 65535, true, false, false);
    }

    public PdfFileParam(String tag, String desc, boolean optional) {
        this(tag, desc, 65535, optional, false, false);
    }

    public PdfFileParam(String tag, String desc, int attributes) {
        this(tag, desc, attributes, true, false, false);
    }

    public PdfFileParam(String tag, String desc, int attributes, boolean optional) {
        this(tag, desc, attributes, optional, false, false);
    }

    public PdfFileParam(String tag, String desc, int attributes, boolean optional, boolean multiValued) {
        this(tag, desc, attributes, optional, multiValued, false);
    }

    public PdfFileParam(String tag, String desc, int attributes, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setAttributes(attributes);
        this.setDesc(desc);
        this.optional = optional;
        this.multiValued = multiValued;
        this.hidden = hidden;
        this.setOptionLabel(DEFAULT_FILE_OPTION_LABEL);
    }

    public PdfFile getPdfFile() {
        PdfFile retVal = null;
        if (!this.set) {
            throw new RuntimeException(Strings.get("PdfFileParam.valueNotSet", new Object[]{this.tag}));
        }
        retVal = this.getPdfFile((String)this.values.get(0));
        return retVal;
    }

    public Collection getPdfFiles() {
        ArrayList<PdfFile> vals = new ArrayList<PdfFile>(this.values.size());
        Iterator itr = this.values.iterator();
        while (itr.hasNext()) {
            vals.add(this.getPdfFile((String)itr.next()));
        }
        return vals;
    }

    public void validateValue(String val) throws CmdLineException {
        super.validateValue(val);
        PdfFile f = null;
        try {
            f = this.getPdfFile(val);
        }
        catch (Exception e) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65534) && !f.getFile().exists()) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65519) && !f.getFile().canRead()) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65503) && !f.getFile().canWrite()) {
            this.throwIllegalValueException(val);
        }
    }

    public boolean attrSpecified(int attr) {
        if (attr != 65534 && attr != 65535 && attr != 65519 && attr != 65503) {
            return false;
        }
        return ((this.attributes | attr) ^ 0xFFFF) != 0;
    }

    public void setAttributes(int attributes) {
        if ((attributes ^ 0xFFFF) >= 64) {
            throw new IllegalArgumentException(Strings.get("PdfFileParam.invalidAttributes", new Object[]{new Integer(attributes)}));
        }
        this.attributes = attributes;
    }

    public int getAttributes() {
        return this.attributes;
    }

    private void throwIllegalValueException(String val) throws CmdLineException {
        String s1 = Strings.get("FileParam.file");
        String s2 = this.attrSpecified(65534) || this.attrSpecified(65519) || this.attrSpecified(65503) ? Strings.get("PdfFileParam.an_existing") : Strings.get("PdfFileParam.a");
        String s3 = "";
        if (this.attrSpecified(65519)) {
            s3 = this.attrSpecified(65503) ? Strings.get("FileParam.readable_writeable") : Strings.get("PdfFileParam.readable");
        } else if (this.attrSpecified(65503)) {
            s3 = Strings.get("PdfFileParam.writeable");
        }
        throw new CmdLineException(Strings.get("PdfFileParam.illegalValue", new Object[]{s2, s1, s3, val, this.tag}));
    }

    private PdfFile getPdfFile(String value) {
        PdfFile retVal = null;
        int k = value.toLowerCase().lastIndexOf(".pdf:");
        retVal = k < 0 ? new PdfFile(new File(value), null) : new PdfFile(new File(value.substring(0, k + 4)), value.substring(k + 5, value.length()));
        return retVal;
    }
}

