/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeReference;

public abstract class NativeObject
implements INativeObject {
    public static final int SIZE_BYTE = 1;
    public static final int SIZE_INT = 4;
    public static final int SHIFT_INT = 2;
    public static final int SIZE_LONGLONG = 8;
    public static final int SHIFT_LONGLONG = 3;
    public static final int SIZE_LONG = NativeInterface.get().longSize();
    public static final int SHIFT_LONG = SIZE_LONG == 4 ? 2 : 3;
    public static final int SIZE_PTR = NativeInterface.get().pointerSize();
    public static final int SIZE_SHORT = 2;
    public static boolean DEBUG = true;
    protected INativeHandle handle;

    protected NativeObject() {
    }

    protected NativeObject(INativeHandle iNativeHandle) {
        this.handle = iNativeHandle;
    }

    protected void allocate() {
        int n = this.getByteCount();
        this.handle = NativeInterface.get().allocate(n);
    }

    public INativeObject cast(INativeType iNativeType) {
        return iNativeType.createNative(this.handle);
    }

    public INativeObject createReference() {
        NativeReference nativeReference = NativeReference.create(this.getNativeType());
        nativeReference.setValue(this);
        return nativeReference;
    }

    public byte getByte(int n) {
        return this.handle.getByte(n);
    }

    public byte[] getByteArray(int n, int n2) {
        return this.handle.getByteArray(n, n2);
    }

    public abstract int getByteCount();

    @Override
    public byte[] getBytes() {
        return this.handle.getByteArray(0, this.getByteCount());
    }

    public long getCLong(int n) {
        return this.handle.getCLong(n);
    }

    public int getInt(int n) {
        return this.handle.getInt(n);
    }

    @Override
    public INativeHandle getNativeHandle() {
        return this.handle;
    }

    public INativeHandle getNativeHandle(int n) {
        return this.handle.getNativeHandle(n);
    }

    @Override
    public abstract INativeType getNativeType();

    public short getShort(int n) {
        return this.handle.getShort(n);
    }

    public String getString(int n) {
        return this.handle.getString(n);
    }

    public String getWideString(int n) {
        return this.handle.getWideString(n);
    }

    public boolean isNull() {
        return this.handle == null || this.handle.getAddress() == 0L;
    }

    public void setByte(int n, byte by) {
        this.handle.setByte(n, by);
    }

    public void setByteArray(int n, byte[] byArray, int n2, int n3) {
        this.handle.setByteArray(n, byArray, n2, n3);
    }

    public void setCLong(int n, long l) {
        this.handle.setCLong(n, l);
    }

    public void setInt(int n, int n2) {
        this.handle.setInt(n, n2);
    }

    public void setNativeHandle(int n, INativeHandle iNativeHandle) {
        this.handle.setNativeHandle(n, iNativeHandle);
    }

    public void setShort(int n, short s) {
        this.handle.setShort(n, s);
    }

    public void setString(int n, String string) {
        this.handle.setString(n, string);
    }

    public void setWideString(int n, String string) {
        this.handle.setWideString(n, string);
    }

    public String toNestedString() {
        return this.toString();
    }
}

