/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ArgsSigner {
    protected IArgs createHashArgs(MessageDigest messageDigest, IArgs iArgs) throws GeneralSecurityException {
        Args args = Args.create();
        try {
            this.updateHash(messageDigest, iArgs);
        }
        catch (Exception exception) {
            Throwable throwable;
            Throwable throwable2 = throwable = exception.getCause() == null ? exception : exception.getCause();
            if (throwable instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)throwable;
            }
            throw new GeneralSecurityException(throwable);
        }
        args.put("algorithm", (Object)messageDigest.getAlgorithm());
        byte[] byArray = messageDigest.digest();
        args.put("value", (Object)new String(Base64.encode(byArray)));
        return args;
    }

    protected String createSignatureValue(Signature signature, PrivateKey privateKey, IArgs iArgs) throws GeneralSecurityException {
        signature.initSign(privateKey);
        try {
            this.updateSignature(signature, iArgs);
        }
        catch (Exception exception) {
            Throwable throwable;
            Throwable throwable2 = throwable = exception.getCause() == null ? exception : exception.getCause();
            if (throwable instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)throwable;
            }
            throw new GeneralSecurityException(throwable);
        }
        byte[] byArray = signature.sign();
        return new String(Base64.encode(byArray));
    }

    protected IArgs createSignedArgs(IArgs iArgs, Signature signature, List<String> list, MessageDigest messageDigest) throws GeneralSecurityException {
        Args args = Args.create();
        args.put("version", (Object)"1.0");
        args.put("algorithm", (Object)signature.getAlgorithm());
        String string = StringTools.join(list, ";");
        args.put("select", (Object)string);
        IArgs iArgs2 = this.createSignedContentArgs(iArgs, list);
        IArgs iArgs3 = this.createHashArgs(messageDigest, iArgs2);
        args.put("hash", (Object)iArgs3);
        return args;
    }

    protected IArgs createSignedContentArgs(IArgs iArgs, List<String> list) {
        Args args = Args.create();
        for (String string : list) {
            this.updateSubtree(args, iArgs, string);
        }
        return args;
    }

    protected IArgs createSignerArgs(PublicKey publicKey, List<Certificate> list) {
        Args args = Args.create();
        if (publicKey != null) {
            Args args2 = Args.create();
            args.put("key", (Object)args2);
            args2.put("type", (Object)publicKey.getFormat());
            byte[] byArray = publicKey.getEncoded();
            args2.put("value", (Object)new String(Base64.encode(byArray)));
        }
        return args;
    }

    public IArgs sign(IArgs iArgs, List<String> list, MessageDigest messageDigest, Signature signature, PrivateKey privateKey, PublicKey publicKey, List<Certificate> list2) throws GeneralSecurityException {
        Args args = Args.create();
        args.put("type", (Object)"ArgDSig");
        Args args2 = Args.create();
        args.put("value", (Object)args2);
        IArgs iArgs2 = this.createSignedArgs(iArgs, signature, list, messageDigest);
        args2.put("signed", (Object)iArgs2);
        IArgs iArgs3 = this.createSignerArgs(publicKey, list2);
        args2.put("signer", (Object)iArgs3);
        String string = this.createSignatureValue(signature, privateKey, iArgs2);
        args2.put("value", (Object)string);
        return args;
    }

    protected void updateHash(final MessageDigest messageDigest, IArgs iArgs) throws IOException {
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                messageDigest.update(byArray, n, n2);
            }

            @Override
            public void write(int n) throws IOException {
                messageDigest.update((byte)n);
            }
        };
        this.writeArgs(outputStream, iArgs);
    }

    protected void updateSignature(final Signature signature, IArgs iArgs) throws IOException {
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                try {
                    signature.update(byArray, n, n2);
                }
                catch (SignatureException signatureException) {
                    throw new IOException(signatureException);
                }
            }

            @Override
            public void write(int n) throws IOException {
                try {
                    signature.update((byte)n);
                }
                catch (SignatureException signatureException) {
                    throw new IOException(signatureException);
                }
            }
        };
        this.writeArgs(outputStream, iArgs);
    }

    protected void updateSubtree(IArgs iArgs, IArgs iArgs2, String string) {
        if ("*".equals(string)) {
            ArgTools.putAll(iArgs, iArgs2);
        } else if (string.startsWith("!")) {
            string = string.substring(1);
            ArgTools.putPath(iArgs, string, null);
        } else {
            Object object = ArgTools.getObject(iArgs2, string, null);
            ArgTools.putPath(iArgs, string, object);
        }
    }

    protected void writeArg(OutputStream outputStream, String string, Object object) throws IOException, UnsupportedEncodingException {
        outputStream.write(string.getBytes("UTF-8"));
        outputStream.write("=".getBytes("UTF-8"));
        if (object instanceof IArgs) {
            outputStream.write("{\n".getBytes("UTF-8"));
            this.writeArgs(outputStream, (IArgs)object);
            outputStream.write("\n}".getBytes("UTF-8"));
        } else {
            String string2 = String.valueOf(object);
            outputStream.write(string2.getBytes("UTF-8"));
        }
        outputStream.write("\n".getBytes("UTF-8"));
    }

    protected void writeArgs(OutputStream outputStream, IArgs iArgs) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(iArgs.names());
        if (arrayList.isEmpty()) {
            int n = 0;
            while (n < iArgs.size()) {
                String string = "" + n;
                Object object = iArgs.get(n);
                this.writeArg(outputStream, string, object);
                ++n;
            }
        } else {
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                Object object = iArgs.get(string);
                this.writeArg(outputStream, string2, object);
            }
        }
    }
}

