/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.merge.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.utils.FileExtensionUtility;
import org.pdfsam.i18n.GettextResource;

public class SaveListAsXmlAction
extends AbstractAction {
    private static final long serialVersionUID = -1905012939581899825L;
    private static final Logger LOG = Logger.getLogger((String)SaveListAsXmlAction.class.getPackage().getName());
    private JPdfSelectionPanel selectionPanel;

    public SaveListAsXmlAction(JPdfSelectionPanel selectionPanel) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Export as xml"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Export the selection list in xml format"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/saveXml.png")));
        this.selectionPanel = selectionPanel;
    }

    public void actionPerformed(ActionEvent e) {
        Object[] rows = this.selectionPanel.getTableRows();
        if (!ArrayUtils.isEmpty((Object[])rows)) {
            try {
                JFileChooser fileChooser = SharedJFileChooser.getInstance((SharedJFileChooserType)SharedJFileChooserType.XML_FILE, (int)0);
                if (fileChooser.showSaveDialog((Component)this.selectionPanel) == 0) {
                    File selectedFile = FileExtensionUtility.ensureExtension((File)fileChooser.getSelectedFile(), (String)"xml");
                    this.writeXmlFile((PdfSelectionTableItem[])rows, selectedFile);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to save xml file."), (Throwable)ex);
            }
        }
    }

    public void writeXmlFile(PdfSelectionTableItem[] rows, File selectedFile) throws Exception {
        if (selectedFile != null && rows != null) {
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("filelist");
            for (int i = 0; i < rows.length; ++i) {
                PdfSelectionTableItem row = rows[i];
                Element node = root.addElement("file");
                node.addAttribute("value", row.getInputFile().getAbsolutePath());
                String pwd = row.getPassword();
                if (pwd == null || pwd.length() <= 0) continue;
                node.addAttribute("password", pwd);
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(selectedFile));
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter xmlWriter = new XMLWriter((OutputStream)bos, format);
            xmlWriter.write(document);
            xmlWriter.flush();
            xmlWriter.close();
            LOG.info((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"File xml saved."));
        } else {
            LOG.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error saving xml file, output file is null."));
        }
    }
}

