/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;

public class PKCS11Configuration {
    private final String name;
    private final String library;
    private final String description;
    private final int slotId;
    private final int slotListIndex;

    private PKCS11Configuration(String string, String string2, String string3, int n, int n2) {
        this.name = string;
        this.library = string2;
        this.description = string3;
        this.slotId = n;
        this.slotListIndex = n2;
    }

    public String getName() {
        return this.name;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSlotListIndex() {
        return this.slotListIndex;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("name = \"").append(PKCS11Configuration.escapeBackslashesAndQuotationMarks(this.name)).append("\"\n");
        stringBuilder.append("library = ").append(this.library).append('\n');
        if (this.description != null && !this.description.isEmpty()) {
            stringBuilder.append("description = ").append(this.description).append('\n');
        }
        if (this.slotListIndex != -1) {
            stringBuilder.append("slotListIndex = ").append(this.slotListIndex);
        } else {
            stringBuilder.append("slot = ").append(this.slotId);
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static String escapeBackslashesAndQuotationMarks(String string) {
        String[] stringArray = new String[]{"\\", "\""};
        String[] stringArray2 = new String[]{"\\\\", "\\\""};
        return StringUtils.replaceEach(string, stringArray, stringArray2);
    }

    public InputStream toInpuStream() {
        return new ByteArrayInputStream(this.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static PCKS11ConfigurationBuilder builder() {
        return new PCKS11ConfigurationBuilder();
    }

    public static final class PCKS11ConfigurationBuilder {
        private String name;
        private String library;
        private String description;
        private int slotId = -1;
        private int slotListIndex = 0;

        private PCKS11ConfigurationBuilder() {
        }

        public PCKS11ConfigurationBuilder setName(String string) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Parameter name must not be null or empty.");
            }
            this.name = string;
            return this;
        }

        public PCKS11ConfigurationBuilder setLibrary(String string) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Parameter library must not be null or empty.");
            }
            this.library = string;
            return this;
        }

        public PCKS11ConfigurationBuilder setDescription(String string) {
            this.description = string;
            return this;
        }

        public PCKS11ConfigurationBuilder setSlotListIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Parameter slotListIndex must be greater or equal to zero.");
            }
            this.slotListIndex = n;
            this.slotId = -1;
            return this;
        }

        public final PCKS11ConfigurationBuilder setSlotId(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Parameter slotId must be greater or equal to zero.");
            }
            this.slotId = n;
            this.slotListIndex = -1;
            return this;
        }

        public PKCS11Configuration build() {
            this.validateBuilderState();
            return new PKCS11Configuration(this.name, this.library, this.description, this.slotId, this.slotListIndex);
        }

        private void validateBuilderState() {
            if (this.name == null) {
                throw new IllegalStateException("A name must be set.");
            }
            if (this.library == null) {
                throw new IllegalStateException("A library must be set.");
            }
        }
    }
}

