/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.brk.BreakAPI;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointMessageHandler;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.brk.BreakpointsOptionsPanel;
import org.zaproxy.zap.extension.brk.BreakpointsPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.extension.brk.BreakpointsTableModel;
import org.zaproxy.zap.extension.brk.BreakpointsUiManagerInterface;
import org.zaproxy.zap.extension.brk.PopupMenuEditBreak;
import org.zaproxy.zap.extension.brk.PopupMenuRemove;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointMessage;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointsUiManagerInterface;
import org.zaproxy.zap.extension.brk.impl.http.ProxyListenerBreak;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionBreak
extends ExtensionAdaptor
implements SessionChangedListener,
OptionsChangedListener {
    public static final String NAME = "ExtensionBreak";
    private static final Logger logger = Logger.getLogger(ExtensionBreak.class);
    private BreakPanel breakPanel = null;
    private ProxyListenerBreak proxyListener = null;
    private BreakpointsPanel breakpointsPanel = null;
    private PopupMenuEditBreak popupMenuEditBreak = null;
    private PopupMenuRemove popupMenuRemove = null;
    private BreakpointMessageHandler breakpointMessageHandler;
    private DialogType currentDialogType = DialogType.NONE;
    private Map<Class<? extends BreakpointMessageInterface>, BreakpointsUiManagerInterface> mapBreakpointUiManager;
    private Map<Class<? extends Message>, BreakpointsUiManagerInterface> mapMessageUiManager;
    private Control.Mode mode = Control.getSingleton().getMode();
    private BreakpointsParam breakpointsParams;
    private BreakpointsOptionsPanel breakpointsOptionsPanel;
    private HttpBreakpointsUiManagerInterface httpBreakpoints;
    private ZapMenuItem menuBreakOnRequests = null;
    private ZapMenuItem menuBreakOnResponses = null;
    private ZapMenuItem menuStep = null;
    private ZapMenuItem menuContinue = null;
    private ZapMenuItem menuDrop = null;
    private ZapMenuItem menuHttpBreakpoint = null;
    private BreakAPI api = new BreakAPI(this);

    public ExtensionBreak() {
        this.initialize();
    }

    public ExtensionBreak(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(24);
    }

    public BreakPanel getBreakPanel() {
        if (this.breakPanel == null) {
            this.breakPanel = new BreakPanel(this, this.getOptionsParam());
            this.breakPanel.setName(Constant.messages.getString("tab.break"));
        }
        return this.breakPanel;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getOptionsParam());
        if (this.getView() != null) {
            this.breakpointMessageHandler = new BreakpointMessageHandler(this.getBreakPanel());
            this.breakpointMessageHandler.setEnabledBreakpoints(this.getBreakpointsModel().getBreakpointsEnabledList());
            ExtensionHookView extensionHookView = extensionHook.getHookView();
            extensionHookView.addWorkPanel(this.getBreakPanel());
            extensionHookView.addOptionPanel(this.getOptionsPanel());
            extensionHook.getHookMenu().addAnalyseMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookView().addStatusPanel(this.getBreakpointsPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuEdit());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuDelete());
            this.mapBreakpointUiManager = new HashMap<Class<? extends BreakpointMessageInterface>, BreakpointsUiManagerInterface>();
            this.mapMessageUiManager = new HashMap<Class<? extends Message>, BreakpointsUiManagerInterface>();
            this.httpBreakpoints = new HttpBreakpointsUiManagerInterface(extensionHook.getHookMenu(), this);
            this.addBreakpointsUiManager(this.httpBreakpoints);
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToggleBreakOnRequests());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToggleBreakOnResponses());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuStep());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuContinue());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuDrop());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuAddHttpBreakpoint());
            extensionHook.addProxyListener(this.getProxyListenerBreak());
            API.getInstance().registerApiImplementor(this.api);
            extensionHook.addSessionListener(this);
            extensionHook.addOptionsChangedListener(this);
            ExtensionHelp.enableHelpKey(this.getBreakPanel(), "ui.tabs.break");
            ExtensionHelp.enableHelpKey(this.getBreakpointsPanel(), "ui.tabs.breakpoints");
        }
    }

    private BreakpointsParam getOptionsParam() {
        if (this.breakpointsParams == null) {
            this.breakpointsParams = new BreakpointsParam();
        }
        return this.breakpointsParams;
    }

    private BreakpointsOptionsPanel getOptionsPanel() {
        if (this.breakpointsOptionsPanel == null) {
            this.breakpointsOptionsPanel = new BreakpointsOptionsPanel();
        }
        return this.breakpointsOptionsPanel;
    }

    private BreakpointsPanel getBreakpointsPanel() {
        if (this.breakpointsPanel == null) {
            this.breakpointsPanel = new BreakpointsPanel(this);
        }
        return this.breakpointsPanel;
    }

    public void addBreakpoint(BreakpointMessageInterface breakpointMessageInterface) {
        this.getBreakpointsPanel().addBreakpoint(breakpointMessageInterface);
        this.getBreakpointsPanel().setTabFocus();
    }

    public void editBreakpoint(BreakpointMessageInterface breakpointMessageInterface, BreakpointMessageInterface breakpointMessageInterface2) {
        this.getBreakpointsPanel().editBreakpoint(breakpointMessageInterface, breakpointMessageInterface2);
    }

    public void removeBreakpoint(BreakpointMessageInterface breakpointMessageInterface) {
        this.getBreakpointsPanel().removeBreakpoint(breakpointMessageInterface);
    }

    public List<BreakpointMessageInterface> getBreakpointsList() {
        return this.getBreakpointsModel().getBreakpointsList();
    }

    public BreakpointMessageInterface getUiSelectedBreakpoint() {
        return this.getBreakpointsPanel().getSelectedBreakpoint();
    }

    public void addBreakpointsUiManager(BreakpointsUiManagerInterface breakpointsUiManagerInterface) {
        this.mapBreakpointUiManager.put(breakpointsUiManagerInterface.getBreakpointClass(), breakpointsUiManagerInterface);
        this.mapMessageUiManager.put(breakpointsUiManagerInterface.getMessageClass(), breakpointsUiManagerInterface);
    }

    public void removeBreakpointsUiManager(BreakpointsUiManagerInterface breakpointsUiManagerInterface) {
        this.mapBreakpointUiManager.remove(breakpointsUiManagerInterface.getBreakpointClass());
        this.mapMessageUiManager.remove(breakpointsUiManagerInterface.getMessageClass());
    }

    public void setBreakAllRequests(boolean bl) {
        this.getBreakPanel().setBreakAllRequests(bl);
    }

    public void setBreakAllResponses(boolean bl) {
        this.getBreakPanel().setBreakAllResponses(bl);
    }

    public void addHttpBreakpoint(String string, String string2, String string3, boolean bl, boolean bl2) {
        HttpBreakpointMessage.Match match;
        HttpBreakpointMessage.Location location;
        try {
            location = HttpBreakpointMessage.Location.valueOf(string2);
        }
        catch (Exception exception) {
            throw new InvalidParameterException("location must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Location.values()));
        }
        try {
            match = HttpBreakpointMessage.Match.valueOf(string3);
        }
        catch (Exception exception) {
            throw new InvalidParameterException("match must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Match.values()));
        }
        this.addBreakpoint(new HttpBreakpointMessage(string, location, match, bl, bl2));
    }

    public void removeHttpBreakpoint(String string, String string2, String string3, boolean bl, boolean bl2) {
        HttpBreakpointMessage.Match match;
        HttpBreakpointMessage.Location location;
        try {
            location = HttpBreakpointMessage.Location.valueOf(string2);
        }
        catch (Exception exception) {
            throw new InvalidParameterException("location must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Location.values()));
        }
        try {
            match = HttpBreakpointMessage.Match.valueOf(string3);
        }
        catch (Exception exception) {
            throw new InvalidParameterException("match must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Match.values()));
        }
        this.removeBreakpoint(new HttpBreakpointMessage(string, location, match, bl, bl2));
    }

    public void addUiBreakpoint(Message message) {
        BreakpointsUiManagerInterface breakpointsUiManagerInterface = this.getBreakpointUiManager(message.getClass());
        if (breakpointsUiManagerInterface != null) {
            breakpointsUiManagerInterface.handleAddBreakpoint(message);
        }
    }

    private BreakpointsUiManagerInterface getBreakpointUiManager(Class<?> clazz) {
        if (!Message.class.isAssignableFrom(clazz)) {
            return null;
        }
        BreakpointsUiManagerInterface breakpointsUiManagerInterface = this.mapMessageUiManager.get(clazz);
        if (breakpointsUiManagerInterface == null) {
            breakpointsUiManagerInterface = this.getBreakpointUiManager(clazz.getSuperclass());
        }
        return breakpointsUiManagerInterface;
    }

    public void editUiSelectedBreakpoint() {
        BreakpointsUiManagerInterface breakpointsUiManagerInterface;
        BreakpointMessageInterface breakpointMessageInterface = this.getBreakpointsPanel().getSelectedBreakpoint();
        if (breakpointMessageInterface != null && (breakpointsUiManagerInterface = this.mapBreakpointUiManager.get(breakpointMessageInterface.getClass())) != null) {
            breakpointsUiManagerInterface.handleEditBreakpoint(breakpointMessageInterface);
        }
    }

    public void removeUiSelectedBreakpoint() {
        BreakpointsUiManagerInterface breakpointsUiManagerInterface;
        BreakpointMessageInterface breakpointMessageInterface = this.getBreakpointsPanel().getSelectedBreakpoint();
        if (breakpointMessageInterface != null && (breakpointsUiManagerInterface = this.mapBreakpointUiManager.get(breakpointMessageInterface.getClass())) != null) {
            breakpointsUiManagerInterface.handleRemoveBreakpoint(breakpointMessageInterface);
        }
    }

    private BreakpointsTableModel getBreakpointsModel() {
        return (BreakpointsTableModel)this.getBreakpointsPanel().getBreakpoints().getModel();
    }

    private ProxyListenerBreak getProxyListenerBreak() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerBreak(this.getModel(), this);
        }
        return this.proxyListener;
    }

    private PopupMenuEditBreak getPopupMenuEdit() {
        if (this.popupMenuEditBreak == null) {
            this.popupMenuEditBreak = new PopupMenuEditBreak();
            this.popupMenuEditBreak.setExtension(this);
        }
        return this.popupMenuEditBreak;
    }

    private PopupMenuRemove getPopupMenuDelete() {
        if (this.popupMenuRemove == null) {
            this.popupMenuRemove = new PopupMenuRemove();
            this.popupMenuRemove.setExtension(this);
        }
        return this.popupMenuRemove;
    }

    private ZapMenuItem getMenuToggleBreakOnRequests() {
        if (this.menuBreakOnRequests == null) {
            this.menuBreakOnRequests = new ZapMenuItem("menu.tools.brk.req", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuBreakOnRequests.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionBreak.this.getOptionsParam().getButtonMode() == 1) {
                        ExtensionBreak.this.getBreakPanel().setBreakAll(!ExtensionBreak.this.getBreakPanel().isBreakAll());
                    } else {
                        ExtensionBreak.this.getBreakPanel().setBreakAllRequests(!ExtensionBreak.this.getBreakPanel().isBreakRequest());
                    }
                }
            });
        }
        return this.menuBreakOnRequests;
    }

    private ZapMenuItem getMenuToggleBreakOnResponses() {
        if (this.menuBreakOnResponses == null) {
            this.menuBreakOnResponses = new ZapMenuItem("menu.tools.brk.resp", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.menuBreakOnResponses.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionBreak.this.getOptionsParam().getButtonMode() == 1) {
                        ExtensionBreak.this.getBreakPanel().setBreakAll(!ExtensionBreak.this.getBreakPanel().isBreakAll());
                    } else {
                        ExtensionBreak.this.getBreakPanel().setBreakAllResponses(!ExtensionBreak.this.getBreakPanel().isBreakResponse());
                    }
                }
            });
        }
        return this.menuBreakOnResponses;
    }

    private ZapMenuItem getMenuStep() {
        if (this.menuStep == null) {
            this.menuStep = new ZapMenuItem("menu.tools.brk.step", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuStep.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionBreak.this.getBreakPanel().isHoldMessage()) {
                        ExtensionBreak.this.getBreakPanel().step();
                    }
                }
            });
        }
        return this.menuStep;
    }

    private ZapMenuItem getMenuContinue() {
        if (this.menuContinue == null) {
            this.menuContinue = new ZapMenuItem("menu.tools.brk.cont", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuContinue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionBreak.this.getBreakPanel().isHoldMessage()) {
                        ExtensionBreak.this.getBreakPanel().cont();
                    }
                }
            });
        }
        return this.menuContinue;
    }

    private ZapMenuItem getMenuDrop() {
        if (this.menuDrop == null) {
            this.menuDrop = new ZapMenuItem("menu.tools.brk.drop", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuDrop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionBreak.this.getBreakPanel().isHoldMessage()) {
                        ExtensionBreak.this.getBreakPanel().drop();
                    }
                }
            });
        }
        return this.menuDrop;
    }

    private ZapMenuItem getMenuAddHttpBreakpoint() {
        if (this.menuHttpBreakpoint == null) {
            this.menuHttpBreakpoint = new ZapMenuItem("menu.tools.brk.custom", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuHttpBreakpoint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "";
                    Component component = View.getSingleton().getMainFrame().getFocusOwner();
                    if (component != null) {
                        if (component instanceof JList) {
                            Object e = ((JList)component).getSelectedValue();
                            try {
                                if (e != null && e instanceof HistoryReference && ((HistoryReference)e).getURI() != null) {
                                    string = ((HistoryReference)e).getURI().toString();
                                }
                            }
                            catch (Exception exception) {}
                        } else if (component instanceof JTree) {
                            TreePath treePath = ((JTree)component).getSelectionPath();
                            try {
                                if (treePath != null && treePath.getLastPathComponent() instanceof SiteNode) {
                                    string = ((SiteNode)treePath.getLastPathComponent()).getHistoryReference().getURI().toString();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    ExtensionBreak.this.httpBreakpoints.handleAddBreakpoint(string);
                }
            });
        }
        return this.menuHttpBreakpoint;
    }

    public boolean canAddBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.ADD;
    }

    public boolean canEditBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.EDIT;
    }

    public boolean canRemoveBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.REMOVE;
    }

    public void dialogShown(DialogType dialogType) {
        this.currentDialogType = dialogType;
    }

    public void dialogClosed() {
        this.currentDialogType = DialogType.NONE;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("brk.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionAboutToChange(Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionAboutToChange();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionBreak.this.sessionAboutToChange();
                    }
                });
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public void sessionChanged(Session session) {
        if (this.getView() == null) {
            return;
        }
        this.getBreakPanel().init();
    }

    private void sessionAboutToChange() {
        if (this.getView() == null) {
            return;
        }
        this.getBreakPanel().reset();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void destroy() {
        if (this.breakPanel != null) {
            this.breakPanel.savePanels();
        }
    }

    public boolean messageReceivedFromClient(Message message) {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return true;
        }
        return this.breakpointMessageHandler.handleMessageReceivedFromClient(message, this.mode.equals((Object)Control.Mode.protect));
    }

    public boolean messageReceivedFromServer(Message message) {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return true;
        }
        return this.breakpointMessageHandler.handleMessageReceivedFromServer(message, this.mode.equals((Object)Control.Mode.protect));
    }

    public List<BreakpointMessageInterface> getBreakpointsEnabledList() {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return new ArrayList<BreakpointMessageInterface>();
        }
        return this.getBreakpointsModel().getBreakpointsEnabledList();
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        this.mode = mode;
        if (this.getView() == null) {
            return;
        }
        this.getBreakPanel().sessionModeChanged(mode);
    }

    public void setBreakOnId(String string, boolean bl) {
        logger.debug((Object)("setBreakOnId " + string + " " + bl));
        if (bl) {
            this.breakpointMessageHandler.getEnabledKeyBreakpoints().add(string);
        } else {
            this.breakpointMessageHandler.getEnabledKeyBreakpoints().remove(string);
        }
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        if (View.isInitialised()) {
            this.getBreakPanel().setButtonMode(optionsParam.getParamSet(BreakpointsParam.class).getButtonMode());
        }
    }

    @Override
    public void optionsLoaded() {
        if (View.isInitialised()) {
            this.getBreakPanel().setButtonMode(this.getOptionsParam().getButtonMode());
        }
    }

    public boolean isInScopeOnly() {
        return this.getOptionsParam().isInScopeOnly();
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    public static enum DialogType {
        NONE,
        ADD,
        EDIT,
        REMOVE;

    }
}

