/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public abstract class Chart
extends Region {
    private static final int MIN_WIDTH_TO_LEAVE_FOR_CHART_CONTENT = 200;
    private static final int MIN_HEIGHT_TO_LEAVE_FOR_CHART_CONTENT = 150;
    private final Label titleLabel = new Label();
    private final Pane chartContent = new Pane(){

        @Override
        protected void layoutChildren() {
            double d = this.getInsets().getTop();
            double d2 = this.getInsets().getLeft();
            double d3 = this.getInsets().getBottom();
            double d4 = this.getInsets().getRight();
            double d5 = this.getWidth();
            double d6 = this.getHeight();
            double d7 = this.snapSize(d5 - (d2 + d4));
            double d8 = this.snapSize(d6 - (d + d3));
            Chart.this.layoutChartChildren(this.snapPosition(d), this.snapPosition(d2), d7, d8);
        }
    };
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this.chartContent);
    private StringProperty title = new StringPropertyBase(){

        @Override
        protected void invalidated() {
            Chart.this.titleLabel.setText(this.get());
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "title";
        }
    };
    private ObjectProperty<Side> titleSide = new StyleableObjectProperty<Side>(Side.TOP){

        @Override
        protected void invalidated() {
            Chart.this.requestLayout();
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.TITLE_SIDE;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "titleSide";
        }
    };
    private final ObjectProperty<Node> legend = new ObjectPropertyBase<Node>(){
        private Node old = null;

        @Override
        protected void invalidated() {
            Node node = (Node)this.get();
            if (this.old != null) {
                Chart.this.getChildren().remove(this.old);
            }
            if (node != null) {
                Chart.this.getChildren().add(node);
                node.setVisible(Chart.this.isLegendVisible());
            }
            this.old = node;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legend";
        }
    };
    private final BooleanProperty legendVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            Chart.this.requestLayout();
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.LEGEND_VISIBLE;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legendVisible";
        }
    };
    private ObjectProperty<Side> legendSide = new StyleableObjectProperty<Side>(Side.BOTTOM){

        @Override
        protected void invalidated() {
            Side side = (Side)((Object)this.get());
            Node node = Chart.this.getLegend();
            if (node instanceof Legend) {
                ((Legend)node).setVertical(Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side));
            }
            Chart.this.requestLayout();
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.LEGEND_SIDE;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legendSide";
        }
    };
    private BooleanProperty animated = new SimpleBooleanProperty(this, "animated", true);

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String string) {
        this.title.set(string);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final Side getTitleSide() {
        return (Side)((Object)this.titleSide.get());
    }

    public final void setTitleSide(Side side) {
        this.titleSide.set(side);
    }

    public final ObjectProperty<Side> titleSideProperty() {
        return this.titleSide;
    }

    protected final Node getLegend() {
        return (Node)this.legend.getValue();
    }

    protected final void setLegend(Node node) {
        this.legend.setValue(node);
    }

    protected final ObjectProperty<Node> legendProperty() {
        return this.legend;
    }

    public final boolean isLegendVisible() {
        return this.legendVisible.getValue();
    }

    public final void setLegendVisible(boolean bl) {
        this.legendVisible.setValue(bl);
    }

    public final BooleanProperty legendVisibleProperty() {
        return this.legendVisible;
    }

    public final Side getLegendSide() {
        return (Side)((Object)this.legendSide.get());
    }

    public final void setLegendSide(Side side) {
        this.legendSide.set(side);
    }

    public final ObjectProperty<Side> legendSideProperty() {
        return this.legendSide;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean bl) {
        this.animated.set(bl);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    protected ObservableList<Node> getChartChildren() {
        return this.chartContent.getChildren();
    }

    public Chart() {
        this.titleLabel.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Node[])new Node[]{this.titleLabel, this.chartContent});
        this.getStyleClass().add("chart");
        this.titleLabel.getStyleClass().add("chart-title");
        this.chartContent.getStyleClass().add("chart-content");
        this.chartContent.setManaged(false);
    }

    void animate(KeyFrame ... keyFrameArray) {
        this.animator.animate(keyFrameArray);
    }

    protected void animate(Animation animation) {
        this.animator.animate(animation);
    }

    protected void requestChartLayout() {
        this.chartContent.requestLayout();
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && this.impl_isTreeVisible() && this.getScene() != null;
    }

    protected abstract void layoutChartChildren(double var1, double var3, double var5, double var7);

    @Override
    protected void layoutChildren() {
        double d = this.getInsets().getTop();
        double d2 = this.getInsets().getLeft();
        double d3 = this.getInsets().getBottom();
        double d4 = this.getInsets().getRight();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (this.getTitle() != null) {
            double d7;
            this.titleLabel.setVisible(true);
            if (this.getTitleSide().equals((Object)Side.TOP)) {
                d7 = this.snapSize(this.titleLabel.prefHeight(d5 - d2 - d4));
                this.titleLabel.resizeRelocate(d2, d, d5 - d2 - d4, d7);
                d += d7;
            } else if (this.getTitleSide().equals((Object)Side.BOTTOM)) {
                d7 = this.snapSize(this.titleLabel.prefHeight(d5 - d2 - d4));
                this.titleLabel.resizeRelocate(d2, d6 - d3 - d7, d5 - d2 - d4, d7);
                d3 += d7;
            } else if (this.getTitleSide().equals((Object)Side.LEFT)) {
                d7 = this.snapSize(this.titleLabel.prefWidth(d6 - d - d3));
                this.titleLabel.resizeRelocate(d2, d, d7, d6 - d - d3);
                d2 += d7;
            } else if (this.getTitleSide().equals((Object)Side.RIGHT)) {
                d7 = this.snapSize(this.titleLabel.prefWidth(d6 - d - d3));
                this.titleLabel.resizeRelocate(d5 - d4 - d7, d, d7, d6 - d - d3);
                d4 += d7;
            }
        } else {
            this.titleLabel.setVisible(false);
        }
        Node node = this.getLegend();
        if (node != null) {
            boolean bl = this.isLegendVisible();
            if (bl) {
                if (this.getLegendSide().equals((Object)Side.TOP)) {
                    double d8 = this.snapSize(node.prefHeight(d5 - d2 - d4));
                    double d9 = this.snapSize(node.prefWidth(-1.0));
                    node.resizeRelocate(d2 + (d5 - d2 - d4 - d9) / 2.0, d, d9, d8);
                    if (d6 - d3 - d - d8 < 150.0) {
                        bl = false;
                    } else {
                        d += d8;
                    }
                } else if (this.getLegendSide().equals((Object)Side.BOTTOM)) {
                    double d10 = this.snapSize(node.prefHeight(d5 - d2 - d4));
                    double d11 = this.snapSize(node.prefWidth(-1.0));
                    node.resizeRelocate(d2 + (d5 - d2 - d4 - d11) / 2.0, d6 - d3 - d10, d11, d10);
                    if (d6 - d3 - d - d10 < 150.0) {
                        bl = false;
                    } else {
                        d3 += d10;
                    }
                } else if (this.getLegendSide().equals((Object)Side.LEFT)) {
                    double d12 = this.snapSize(node.prefWidth(d6 - d - d3));
                    double d13 = this.snapSize(node.prefHeight(-1.0));
                    node.resizeRelocate(d2, d + (d6 - d - d3 - d13) / 2.0, d12, d13);
                    if (d5 - d2 - d4 - d12 < 200.0) {
                        bl = false;
                    } else {
                        d2 += d12;
                    }
                } else if (this.getLegendSide().equals((Object)Side.RIGHT)) {
                    double d14 = this.snapSize(node.prefWidth(d6 - d - d3));
                    double d15 = this.snapSize(node.prefHeight(-1.0));
                    node.resizeRelocate(d5 - d4 - d14, d + (d6 - d - d3 - d15) / 2.0, d14, d15);
                    if (d5 - d2 - d4 - d14 < 200.0) {
                        bl = false;
                    } else {
                        d4 += d14;
                    }
                }
            }
            node.setVisible(bl);
        }
        this.chartContent.resizeRelocate(d2, d, d5 - d2 - d4, d6 - d - d3);
    }

    @Override
    protected double computeMinHeight(double d) {
        return 150.0;
    }

    @Override
    protected double computeMinWidth(double d) {
        return 200.0;
    }

    @Override
    protected double computePrefWidth(double d) {
        return 500.0;
    }

    @Override
    protected double computePrefHeight(double d) {
        return 400.0;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Chart.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Chart, Side> TITLE_SIDE = new StyleableProperty<Chart, Side>("-fx-title-side", new EnumConverter(Side.class), Side.TOP){

            @Override
            public boolean isSettable(Chart chart) {
                return chart.titleSide == null || !chart.titleSide.isBound();
            }

            @Override
            public WritableValue<Side> getWritableValue(Chart chart) {
                return chart.titleSideProperty();
            }
        };
        private static final StyleableProperty<Chart, Side> LEGEND_SIDE = new StyleableProperty<Chart, Side>("-fx-legend-side", new EnumConverter(Side.class), Side.BOTTOM){

            @Override
            public boolean isSettable(Chart chart) {
                return chart.legendSide == null || !chart.legendSide.isBound();
            }

            @Override
            public WritableValue<Side> getWritableValue(Chart chart) {
                return chart.legendSideProperty();
            }
        };
        private static final StyleableProperty<Chart, Boolean> LEGEND_VISIBLE = new StyleableProperty<Chart, Boolean>("-fx-legend-visible", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Chart chart) {
                return chart.legendVisible == null || !chart.legendVisible.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Chart chart) {
                return chart.legendVisibleProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, TITLE_SIDE, LEGEND_VISIBLE, LEGEND_SIDE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

