/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IScopedPlatformPreferences;
import de.intarsys.tools.preferences.PreferencesChangeEvent;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class PreferencesAdapter
implements IPreferences,
INotificationSupport,
PreferenceChangeListener,
IBasicAccessSupport {
    private final Map<String, PreferencesAdapter> children = new HashMap<String, PreferencesAdapter>();
    private final Preferences jPrefs;
    private final PreferencesAdapter parent;
    private EventDispatcher dispatcher;
    private final Object lock = new Object();
    private final PreferencesAdapter root;
    public static final String NODE_METADATA = "__metadata";
    public static final String MODIFIER_NULL = "null";

    public PreferencesAdapter(PreferencesAdapter preferencesAdapter, Preferences preferences) {
        this.parent = preferencesAdapter;
        this.jPrefs = preferences;
        this.root = preferencesAdapter != null ? preferencesAdapter.root : this;
    }

    @Override
    public String absolutePath() {
        return this.jPrefs.absolutePath();
    }

    @Override
    public synchronized void addNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher(this);
            this.jPrefs.addPreferenceChangeListener(this);
        }
        this.dispatcher.addNotificationListener(eventType, iNotificationListener);
    }

    @Override
    public Object basicGetValue(String string) throws FieldException {
        try {
            if (this.nodeExists(string)) {
                return this.node(string);
            }
        }
        catch (BackingStoreException backingStoreException) {
            throw new FieldAccessException(string);
        }
        return this.get(string);
    }

    @Override
    public Object basicSetValue(String string, Object object) throws FieldException {
        String string2 = this.get(string);
        if (object == null) {
            this.remove(string);
        } else {
            String string3;
            try {
                string3 = ConverterRegistry.get().convert(object, String.class);
            }
            catch (ConversionException conversionException) {
                string3 = String.valueOf(object);
            }
            this.put(string, string3);
        }
        return string2;
    }

    @Override
    public IPreferences[] children() {
        ArrayList<IPreferences> arrayList = new ArrayList<IPreferences>();
        String[] stringArray = this.childrenNames();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(this.node(stringArray[n]));
            ++n;
        }
        return arrayList.toArray(new IPreferences[arrayList.size()]);
    }

    @Override
    public String[] childrenNames() {
        try {
            return this.jPrefs.childrenNames();
        }
        catch (BackingStoreException backingStoreException) {
            return new String[0];
        }
    }

    @Override
    public void clear() throws BackingStoreException {
        this.jPrefs.clear();
    }

    protected PreferencesAdapter createPreferencesNode(String string) {
        return new PreferencesAdapter(this, this.jPrefs.node(string));
    }

    @Override
    public void flush() {
        try {
            this.jPrefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    @Override
    public String get(String string) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return null;
        }
        return this.jPrefs.get(string, null);
    }

    @Override
    public String get(String string, String string2) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return string2;
        }
        return this.jPrefs.get(string, string2);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return bl;
        }
        return this.jPrefs.getBoolean(string, bl);
    }

    @Override
    public byte[] getByteArray(String string, byte[] byArray) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return byArray;
        }
        return this.jPrefs.getByteArray(string, byArray);
    }

    @Override
    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    @Override
    public double getDouble(String string, double d) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return d;
        }
        return this.jPrefs.getDouble(string, d);
    }

    @Override
    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    @Override
    public float getFloat(String string, float f) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return f;
        }
        return this.jPrefs.getFloat(string, f);
    }

    @Override
    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    @Override
    public int getInt(String string, int n) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return n;
        }
        return this.jPrefs.getInt(string, n);
    }

    @Override
    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    @Override
    public long getLong(String string, long l) {
        if (this.hasModifier(string, MODIFIER_NULL)) {
            return l;
        }
        return this.jPrefs.getLong(string, l);
    }

    protected Preferences getMetadata() {
        return this.jPrefs.node(NODE_METADATA);
    }

    @Override
    public String getModifierString(String string) {
        return this.getMetadata().get(string, null);
    }

    @Override
    public boolean hasModifier(String string, String string2) {
        String string3 = this.getModifierString(string);
        if (string3 == null) {
            return false;
        }
        return string3.indexOf(string2) >= 0;
    }

    @Override
    public String[] keys() {
        try {
            return this.jPrefs.keys();
        }
        catch (BackingStoreException backingStoreException) {
            return new String[0];
        }
    }

    @Override
    public String name() {
        return this.jPrefs.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IPreferences node(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (string.equals("")) {
                return this;
            }
            if (string.equals("/")) {
                return this.root;
            }
            if (string.charAt(0) != '/') {
                return this.node(new StringTokenizer(string, "/", true));
            }
        }
        return this.root.node(new StringTokenizer(string.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPreferences node(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        if (string.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        Object object = this.lock;
        synchronized (object) {
            PreferencesAdapter preferencesAdapter = this.children.get(string);
            if (preferencesAdapter == null) {
                preferencesAdapter = this.createPreferencesNode(string);
                this.children.put(string, preferencesAdapter);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return preferencesAdapter;
            }
            stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("Path ends with slash");
            }
            return preferencesAdapter.node(stringTokenizer);
        }
    }

    @Override
    public boolean nodeExists(String string) throws BackingStoreException {
        return this.jPrefs.nodeExists(string);
    }

    @Override
    public IPreferences parent() {
        return this.parent;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        this.triggerChange(preferenceChangeEvent);
    }

    @Override
    public Map<String, String> properties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.keys();
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n], this.get(stringArray[n]));
            ++n;
        }
        return hashMap;
    }

    @Override
    public void put(String string, boolean bl) {
        this.jPrefs.putBoolean(string, bl);
    }

    @Override
    public void put(String string, byte[] byArray) {
        if (byArray == null) {
            this.jPrefs.remove(string);
        } else {
            this.jPrefs.putByteArray(string, byArray);
        }
    }

    @Override
    public void put(String string, double d) {
        this.jPrefs.putDouble(string, d);
    }

    @Override
    public void put(String string, float f) {
        this.jPrefs.putFloat(string, f);
    }

    @Override
    public void put(String string, int n) {
        this.jPrefs.putInt(string, n);
    }

    @Override
    public void put(String string, long l) {
        this.jPrefs.putLong(string, l);
    }

    @Override
    public void put(String string, String string2) {
        if (string2 == null) {
            this.jPrefs.remove(string);
        } else {
            this.jPrefs.put(string, string2);
        }
    }

    @Override
    public void putBoolean(String string, boolean bl) {
        this.jPrefs.putBoolean(string, bl);
    }

    @Override
    public void putByteArray(String string, byte[] byArray) {
        if (byArray == null) {
            this.jPrefs.remove(string);
        } else {
            this.jPrefs.putByteArray(string, byArray);
        }
    }

    @Override
    public void putDouble(String string, double d) {
        this.jPrefs.putDouble(string, d);
    }

    @Override
    public void putFloat(String string, float f) {
        this.jPrefs.putFloat(string, f);
    }

    @Override
    public void putInt(String string, int n) {
        this.jPrefs.putInt(string, n);
    }

    @Override
    public void putLong(String string, long l) {
        this.jPrefs.putLong(string, l);
    }

    @Override
    public void remove(String string) {
        this.jPrefs.remove(string);
        this.removeModifiers(string);
    }

    public void removeModifiers(String string) {
        this.getMetadata().remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Can't remove the root!");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            this.jPrefs.removeNode();
            this.parent.children.remove(this.jPrefs.name());
        }
    }

    @Override
    public synchronized void removeNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(eventType, iNotificationListener);
        if (this.dispatcher.isEmpty()) {
            this.jPrefs.removePreferenceChangeListener(this);
        }
    }

    @Override
    public IPreferences restrict(String string) {
        if (this.jPrefs instanceof IScopedPlatformPreferences) {
            return new PreferencesAdapter(null, ((IScopedPlatformPreferences)((Object)this.jPrefs)).restrict(string));
        }
        return this;
    }

    @Override
    public void setModifierString(String string, String string2) {
        if (string2 == null) {
            this.getMetadata().remove(string);
        } else {
            this.getMetadata().put(string, string2);
        }
    }

    @Override
    public void sync() throws BackingStoreException {
        this.jPrefs.sync();
    }

    protected void triggerChange(PreferenceChangeEvent preferenceChangeEvent) {
        PreferencesChangeEvent preferencesChangeEvent = new PreferencesChangeEvent(this);
        preferencesChangeEvent.setKey(preferenceChangeEvent.getKey());
        preferencesChangeEvent.setNewValue(preferenceChangeEvent.getNewValue());
        this.triggerEvent(preferencesChangeEvent);
    }

    protected void triggerEvent(Event event) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent(event);
    }
}

