/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    int modelHandle;
    int checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int sortDirection;
    int ignoreCell;
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    @Override
    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.ownerDraw) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, n, false);
        return this.items[n];
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    int cellDataProc(int n, int n2, int n3, int n4, int n5) {
        if (n2 == this.ignoreCell) {
            return 0;
        }
        int n6 = OS.gtk_tree_model_get_path(n3, n4);
        int[] nArray = new int[1];
        OS.memmove(nArray, OS.gtk_tree_path_get_indices(n6), 4);
        TableItem tableItem = this._getItem(nArray[0]);
        OS.gtk_tree_path_free(n6);
        if (tableItem != null) {
            OS.g_object_set_qdata(n2, Display.SWT_OBJECT_INDEX2, tableItem.handle);
        }
        boolean bl = OS.GTK_IS_CELL_RENDERER_PIXBUF(n2);
        boolean bl2 = OS.GTK_IS_CELL_RENDERER_TEXT(n2);
        if (bl2 && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(n2, -1, -1);
        }
        if (!bl && !bl2) {
            return 0;
        }
        int n7 = -1;
        boolean bl3 = false;
        if (this.columnCount == 0) {
            n7 = 5;
            bl3 = this.firstCustomDraw;
        } else {
            TableColumn tableColumn = (TableColumn)this.display.getWidget(n);
            if (tableColumn != null) {
                n7 = tableColumn.modelIndex;
                bl3 = tableColumn.customDraw;
            }
        }
        if (n7 == -1) {
            return 0;
        }
        boolean bl4 = false;
        if ((this.style & 0x10000000) != 0 && !tableItem.cached) {
            this.lastIndexOf = nArray[0];
            bl4 = this.checkData(tableItem);
        }
        int[] nArray2 = new int[1];
        if (bl4) {
            nArray2[0] = 0;
            if (bl) {
                OS.gtk_tree_model_get(n3, n4, n7 + 0, nArray2, -1);
                OS.g_object_set(n2, OS.GTK3 ? OS.gicon : OS.pixbuf, nArray2[0], 0);
                if (nArray2[0] != 0) {
                    OS.g_object_unref(nArray2[0]);
                }
            } else {
                OS.gtk_tree_model_get(n3, n4, n7 + 1, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.text, nArray2[0], 0);
                    OS.g_free(nArray2[0]);
                }
            }
        }
        if (bl3) {
            if (!this.ownerDraw) {
                nArray2[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n7 + 3, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.cell_background_gdk, nArray2[0], 0);
                    OS.gdk_color_free(nArray2[0]);
                }
            }
            if (!bl) {
                nArray2[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n7 + 2, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.foreground_gdk, nArray2[0], 0);
                    OS.gdk_color_free(nArray2[0]);
                }
                nArray2[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n7 + 4, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.font_desc, nArray2[0], 0);
                    OS.pango_font_description_free(nArray2[0]);
                }
            }
        }
        if (bl4) {
            this.ignoreCell = n2;
            this.setScrollWidth(n, tableItem);
            this.ignoreCell = 0;
        }
        return 0;
    }

    boolean checkData(TableItem tableItem) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0, 0, this.handle);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0, 0, this.handle);
            if (tableItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int calculateWidth(int n, int n2) {
        OS.gtk_tree_view_column_cell_set_cell_data(n, this.modelHandle, n2, false, false);
        int n3 = 0;
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0);
        n3 += 2 * nArray[0];
        int n4 = 0;
        n4 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(n) : OS.gtk_tree_view_column_get_cell_renderers(n);
        if (n4 == 0) {
            return 0;
        }
        int n5 = n4;
        while (n5 != 0) {
            int n6 = OS.g_list_data(n5);
            if (n6 != 0) {
                this.gtk_cell_renderer_get_preferred_size(n6, this.handle, nArray, null);
                n3 += nArray[0];
            }
            n5 = OS.g_list_next(n5);
        }
        OS.g_list_free(n4);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_tree_view_get_rules_hint(this.handle)) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, nArray, 0);
            n3 += 2 * nArray[0];
        }
        return n3;
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.clear();
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            for (int i = n; i <= n2; ++i) {
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                tableItem.clear();
            }
        }
    }

    public void clear(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (0 <= nArray[n] && nArray[n] < this.itemCount) continue;
            this.error(6);
        }
        for (n = 0; n < nArray.length; ++n) {
            TableItem tableItem = this.items[nArray[n]];
            if (tableItem == null) continue;
            tableItem.clear();
        }
    }

    public void clearAll() {
        this.checkWidget();
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null) continue;
            tableItem.clear();
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (OS.GTK3 && point.y == 0 && n2 == -1) {
            point.y = this.getItemCount() * this.getItemHeight();
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    void createColumn(TableColumn tableColumn, int n) {
        Object object;
        int n2;
        int n3 = 5;
        if (this.columnCount != 0) {
            int n4;
            int n5;
            n2 = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            object = new boolean[n2];
            for (n5 = 0; n5 < this.columnCount; ++n5) {
                int n6 = this.columns[n5].modelIndex;
                for (n4 = 0; n4 < 5; ++n4) {
                    object[n6 + n4] = true;
                }
            }
            while (n3 < n2 && object[n3]) {
                ++n3;
            }
            if (n3 == n2) {
                n5 = this.modelHandle;
                int[] nArray = this.getColumnTypes(this.columnCount + 4);
                n4 = OS.gtk_list_store_newv(nArray.length, nArray);
                if (n4 == 0) {
                    this.error(2);
                }
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                for (int i = 0; i < this.itemCount; ++i) {
                    int n7 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    if (n7 == 0) {
                        this.error(2);
                    }
                    OS.gtk_list_store_append(n4, n7);
                    TableItem tableItem = this.items[i];
                    if (tableItem != null) {
                        int n8;
                        int n9 = tableItem.handle;
                        for (n8 = 0; n8 < 2; ++n8) {
                            OS.gtk_tree_model_get(n5, n9, n8, nArray3, -1);
                            OS.gtk_list_store_set(n4, n7, n8, nArray3[0], -1);
                        }
                        for (n8 = 2; n8 < n2; ++n8) {
                            OS.gtk_tree_model_get(n5, n9, n8, nArray2, -1);
                            OS.gtk_list_store_set(n4, n7, n8, nArray2[0], -1);
                            if (nArray2[0] == 0) continue;
                            if (nArray[n8] == OS.G_TYPE_STRING()) {
                                OS.g_free(nArray2[0]);
                                continue;
                            }
                            if (nArray[n8] == OS.GDK_TYPE_COLOR()) {
                                OS.gdk_color_free(nArray2[0]);
                                continue;
                            }
                            if (nArray[n8] == OS.GDK_TYPE_PIXBUF()) {
                                OS.g_object_unref(nArray2[0]);
                                continue;
                            }
                            if (nArray[n8] != OS.PANGO_TYPE_FONT_DESCRIPTION()) continue;
                            OS.pango_font_description_free(nArray2[0]);
                        }
                        OS.gtk_list_store_remove(n5, n9);
                        OS.g_free(n9);
                        tableItem.handle = n7;
                        continue;
                    }
                    OS.g_free(n7);
                }
                OS.gtk_tree_view_set_model(this.handle, n4);
                this.setModel(n4);
            }
        }
        if ((n2 = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            object = this.columns[0];
            this.createRenderers(object.handle, object.modelIndex, false, object.style);
        }
        this.createRenderers(n2, n3, n == 0, tableColumn == null ? 0 : tableColumn.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(n2, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(n2, 2);
        }
        OS.gtk_tree_view_column_set_resizable(n2, true);
        OS.gtk_tree_view_column_set_clickable(n2, true);
        OS.gtk_tree_view_column_set_min_width(n2, 0);
        OS.gtk_tree_view_insert_column(this.handle, n2, n);
        if (this.columnCount != 0) {
            OS.gtk_tree_view_column_set_visible(n2, false);
        }
        if (tableColumn != null) {
            tableColumn.handle = n2;
            tableColumn.modelIndex = n3;
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n10 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n10 + 1);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] nArray = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_list_store_newv(nArray.length, nArray);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(n3, n2);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n4 = (this.style & 0x100) != 0 ? 1 : 2;
        int n5 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n4, n5);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0);
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        }
    }

    void createItem(TableColumn tableColumn, int n) {
        int n2;
        int n3;
        int n4;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            tableColumn.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(tableColumn.handle, 2);
            OS.gtk_tree_view_column_set_visible(tableColumn.handle, false);
            tableColumn.modelIndex = 5;
            this.createRenderers(tableColumn.handle, tableColumn.modelIndex, true, tableColumn.style);
            tableColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(tableColumn, n);
        }
        int n5 = this.gtk_box_new(0, false, 3);
        if (n5 == 0) {
            this.error(2);
        }
        if ((n4 = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((n3 = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add(n5, n3);
        OS.gtk_container_add(n5, n4);
        OS.gtk_widget_show(n5);
        OS.gtk_widget_show(n4);
        tableColumn.labelHandle = n4;
        tableColumn.imageHandle = n3;
        OS.gtk_tree_view_column_set_widget(tableColumn.handle, n5);
        if (OS.GTK3) {
            tableColumn.buttonHandle = OS.gtk_tree_view_column_get_button(tableColumn.handle);
        } else {
            n2 = OS.gtk_widget_get_parent(n5);
            while (n2 != this.handle) {
                if (OS.GTK_IS_BUTTON(n2)) {
                    tableColumn.buttonHandle = n2;
                    break;
                }
                n2 = OS.gtk_widget_get_parent(n2);
            }
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        if ((this.state & 0x4000) != 0) {
            tableColumn.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            for (n2 = 0; n2 < this.itemCount; ++n2) {
                Font[] fontArray;
                TableItem tableItem = this.items[n2];
                if (tableItem == null || (fontArray = tableItem.cellFont) == null) continue;
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n, fontArray2, n + 1, this.columnCount - n - 1);
                tableItem.cellFont = fontArray2;
            }
        }
        if (!this.isVisible()) {
            OS.gtk_container_resize_children(this.handle);
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.drawCount <= 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        tableItem.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (tableItem.handle == 0) {
            this.error(2);
        }
        if (n == this.itemCount) {
            OS.gtk_list_store_append(this.modelHandle, tableItem.handle);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, tableItem.handle, n);
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
    }

    void createRenderers(int n, int n2, boolean bl, int n3) {
        int n4;
        int n5;
        OS.gtk_tree_view_column_clear(n);
        if ((this.style & 0x20) != 0 && bl) {
            OS.gtk_tree_view_column_pack_start(n, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.active, 0);
            OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.inconsistent, 1);
            if (!this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.cell_background_gdk, 3);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(n, this.checkRenderer, this.display.cellDataProc, this.handle, 0);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, n);
            }
        }
        int n6 = n5 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0) : OS.gtk_cell_renderer_pixbuf_new();
        if (n5 == 0) {
            this.error(2);
        } else if (!this.ownerDraw && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(n5, 16, 16);
        }
        int n7 = n4 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0) : OS.gtk_cell_renderer_text_new();
        if (n4 == 0) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(n5, Display.SWT_OBJECT_INDEX1, n);
            OS.g_object_set_qdata(n4, Display.SWT_OBJECT_INDEX1, n);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(n5, OS.mode, 1, 0);
        }
        if ((n3 & 0x20000) != 0) {
            OS.g_object_set(n4, OS.xalign, 1.0f, 0);
            OS.gtk_tree_view_column_pack_end(n, n4, true);
            OS.gtk_tree_view_column_pack_end(n, n5, false);
            OS.gtk_tree_view_column_set_alignment(n, 1.0f);
        } else if ((n3 & 0x1000000) != 0) {
            OS.g_object_set(n4, OS.xalign, 0.5f, 0);
            OS.gtk_tree_view_column_pack_start(n, n5, false);
            OS.gtk_tree_view_column_pack_end(n, n4, true);
            OS.gtk_tree_view_column_set_alignment(n, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(n, n5, false);
            OS.gtk_tree_view_column_pack_start(n, n4, true);
            OS.gtk_tree_view_column_set_alignment(n, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(n, n5, OS.GTK3 ? OS.gicon : OS.pixbuf, n2 + 0);
        if (!this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(n, n5, OS.cell_background_gdk, 3);
            OS.gtk_tree_view_column_add_attribute(n, n4, OS.cell_background_gdk, 3);
        }
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.text, n2 + 1);
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.foreground_gdk, 2);
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.font_desc, 4);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != n) continue;
                bl2 = this.columns[i].customDraw;
                break;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(n, n4, this.display.cellDataProc, this.handle, 0);
            OS.gtk_tree_view_column_set_cell_data_func(n, n5, this.display.cellDataProc, this.handle, 0);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_iter(n2, this._getItem((int)n).handle);
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        for (int i = n; i <= n2; ++i) {
            if (i < 0 || i >= this.itemCount) continue;
            OS.gtk_tree_selection_unselect_iter(n3, this._getItem((int)i).handle);
        }
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || n2 >= this.itemCount) continue;
            OS.gtk_tree_selection_unselect_iter(n, this._getItem((int)n2).handle);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TableColumn tableColumn) {
        int n;
        for (n = 0; n < this.columnCount && this.columns[n] != tableColumn; ++n) {
        }
        if (n == this.columnCount) {
            return;
        }
        int n2 = tableColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = tableColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, n2);
        if (this.columnCount == 0) {
            int n3 = this.modelHandle;
            int[] nArray = this.getColumnTypes(1);
            int n4 = OS.gtk_list_store_newv(nArray.length, nArray);
            if (n4 == 0) {
                this.error(2);
            }
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            for (int i = 0; i < this.itemCount; ++i) {
                int n5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (n5 == 0) {
                    this.error(2);
                }
                OS.gtk_list_store_append(n4, n5);
                TableItem tableItem = this.items[i];
                if (tableItem != null) {
                    int n6;
                    int n7 = tableItem.handle;
                    for (n6 = 0; n6 < 2; ++n6) {
                        OS.gtk_tree_model_get(n3, n7, n6, nArray3, -1);
                        OS.gtk_list_store_set(n4, n5, n6, nArray3[0], -1);
                    }
                    for (n6 = 2; n6 < 5; ++n6) {
                        OS.gtk_tree_model_get(n3, n7, n6, nArray2, -1);
                        OS.gtk_list_store_set(n4, n5, n6, nArray2[0], -1);
                        if (nArray2[0] == 0) continue;
                        if (n6 == 2 || n6 == 3) {
                            OS.gdk_color_free(nArray2[0]);
                            continue;
                        }
                        if (n6 != 4) continue;
                        OS.pango_font_description_free(nArray2[0]);
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 0, nArray2, -1);
                    OS.gtk_list_store_set(n4, n5, 5, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.g_object_unref(nArray2[0]);
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 1, nArray2, -1);
                    OS.gtk_list_store_set(n4, n5, 6, nArray2[0], -1);
                    OS.g_free(nArray2[0]);
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 2, nArray2, -1);
                    OS.gtk_list_store_set(n4, n5, 7, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.gdk_color_free(nArray2[0]);
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 3, nArray2, -1);
                    OS.gtk_list_store_set(n4, n5, 8, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.gdk_color_free(nArray2[0]);
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 4, nArray2, -1);
                    OS.gtk_list_store_set(n4, n5, 9, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.pango_font_description_free(nArray2[0]);
                    }
                    OS.gtk_list_store_remove(n3, n7);
                    OS.g_free(n7);
                    tableItem.handle = n5;
                    continue;
                }
                OS.g_free(n5);
            }
            OS.gtk_tree_view_set_model(this.handle, n4);
            this.setModel(n4);
            this.createColumn(null, 0);
        } else {
            for (int i = 0; i < this.itemCount; ++i) {
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                int n8 = tableItem.handle;
                int n9 = tableColumn.modelIndex;
                OS.gtk_list_store_set(this.modelHandle, n8, n9 + 0, 0, -1);
                OS.gtk_list_store_set(this.modelHandle, n8, n9 + 1, 0, -1);
                OS.gtk_list_store_set(this.modelHandle, n8, n9 + 2, 0, -1);
                OS.gtk_list_store_set(this.modelHandle, n8, n9 + 3, 0, -1);
                OS.gtk_list_store_set(this.modelHandle, n8, n9 + 4, 0, -1);
                Font[] fontArray = tableItem.cellFont;
                if (fontArray == null) continue;
                if (this.columnCount == 0) {
                    tableItem.cellFont = null;
                    continue;
                }
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                tableItem.cellFont = fontArray2;
            }
            if (n == 0) {
                TableColumn tableColumn2 = this.columns[0];
                this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, true, tableColumn2.style);
            }
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n10 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n10 + 1);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != tableItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_remove(this.modelHandle, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = false;
        if (bl) {
            int[] nArray = new int[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, nArray, null, null, null)) {
                if (nArray[0] != 0) {
                    int n3 = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                        bl4 = true;
                    }
                    OS.gtk_tree_path_free(nArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl3 = super.dragDetect(n, n2, bl, false, blArray)) && bl4 && blArray != null) {
            blArray[0] = true;
        }
        return bl3;
    }

    @Override
    int eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return OS.GTK_VERSION >= OS.VERSION(2, 12, 0);
    }

    @Override
    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        for (int i = 0; i < this.columnCount; ++i) {
            TableColumn tableColumn = this.columns[i];
            if (tableColumn.toolTipText == null) continue;
            tableColumn.setToolTipText(shell2, null);
            tableColumn.setToolTipText(shell, tableColumn.toolTipText);
        }
    }

    @Override
    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        int n = this.gtk_widget_get_window(this.fixedHandle);
        int n2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n2, nArray, nArray2);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.gdk_window_get_origin(n, nArray3, nArray4);
        int n3 = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(n3, gtkAllocation);
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        return new Rectangle(nArray3[0] - nArray[0], nArray4[0] - nArray2[0], n4, n5);
    }

    @Override
    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        this.gdk_window_get_size(OS.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        return nArray[0];
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    int[] getColumnTypes(int n) {
        int[] nArray = new int[5 + n * 5];
        nArray[0] = OS.G_TYPE_BOOLEAN();
        nArray[1] = OS.G_TYPE_BOOLEAN();
        nArray[2] = OS.GDK_TYPE_COLOR();
        nArray[3] = OS.GDK_TYPE_COLOR();
        nArray[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        for (int i = 5; i < nArray.length; i += 5) {
            nArray[i + 0] = OS.GDK_TYPE_PIXBUF();
            nArray[i + 1] = OS.G_TYPE_STRING();
            nArray[i + 2] = OS.GDK_TYPE_COLOR();
            nArray[i + 3] = OS.GDK_TYPE_COLOR();
            nArray[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        }
        return nArray;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int n = OS.gtk_tree_view_get_columns(this.handle);
        if (n == 0) {
            return new int[0];
        }
        int n2 = 0;
        int n3 = OS.g_list_length(n);
        int[] nArray = new int[n3];
        int n4 = n;
        while (n4 != 0) {
            int n5 = OS.g_list_data(n4);
            if (n5 != 0) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columns[i].handle != n5) continue;
                    nArray[n2++] = i;
                    break;
                }
            }
            n4 = OS.g_list_next(n4);
        }
        OS.g_list_free(n);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    TableItem getFocusItem() {
        int[] nArray = new int[1];
        OS.gtk_tree_view_get_cursor(this.handle, nArray, null);
        if (nArray[0] == 0) {
            return null;
        }
        TableItem tableItem = null;
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        if (n != 0) {
            int[] nArray2 = new int[]{-1};
            OS.memmove(nArray2, n, 4);
            tableItem = this._getItem(nArray2[0]);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return tableItem;
    }

    @Override
    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            int n = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                int n2 = this.columns[i].buttonHandle;
                if (n2 == 0) continue;
                this.gtk_widget_get_preferred_size(n2, gtkRequisition);
                n = Math.max(n, gtkRequisition.height);
            }
            return n;
        }
        OS.gtk_widget_realize(this.handle);
        int n = this.gtk_widget_get_window(this.fixedHandle);
        int n3 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        OS.gdk_window_get_origin(n3, null, nArray);
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n, null, nArray2);
        return nArray[0] - nArray2[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int[] nArray = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, point.x, point.y, nArray, null, null, null)) {
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        TableItem tableItem = null;
        if (n != 0) {
            int[] nArray2 = new int[1];
            OS.memmove(nArray2, n, 4);
            tableItem = this._getItem(nArray2[0]);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return tableItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            int n = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(n, null, null, null, nArray, nArray2);
            int n2 = nArray2[0];
            if (OS.GTK3) {
                int n3 = this.getTextRenderer(n);
                OS.gtk_cell_renderer_get_preferred_height_for_width(n3, this.handle, 0, nArray2, null);
                n2 += nArray2[0];
            }
            this.ignoreSize = false;
            return n2;
        }
        int n = 0;
        int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, n4);
        int n5 = Math.max(1, this.columnCount);
        for (int i = 0; i < n5; ++i) {
            int n6 = OS.gtk_tree_view_get_column(this.handle, i);
            OS.gtk_tree_view_column_cell_set_cell_data(n6, this.modelHandle, n4, false, false);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(n6, null, null, null, nArray, nArray3);
            n = Math.max(n, nArray3[0]);
        }
        OS.g_free(n4);
        return n;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < this.itemCount; ++i) {
                tableItemArray[i] = this._getItem(i);
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    int getPixbufRenderer(int n) {
        int n2 = 0;
        n2 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(n) : OS.gtk_tree_view_column_get_cell_renderers(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = OS.g_list_length(n2);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = OS.g_list_nth_data(n2, i);
            if (!OS.GTK_IS_CELL_RENDERER_PIXBUF(n5)) continue;
            n4 = n5;
            break;
        }
        OS.g_list_free(n2);
        return n4;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        int n2 = OS.gtk_tree_selection_get_selected_rows(n, null);
        if (n2 != 0) {
            int n3;
            int n4 = OS.g_list_length(n2);
            int[] nArray = new int[n4];
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                n3 = OS.g_list_nth_data(n2, i);
                int n6 = OS.gtk_tree_path_get_indices(n3);
                if (n6 != 0) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, n6, 4);
                    nArray[n5] = nArray2[0];
                    ++n5;
                }
                OS.gtk_tree_path_free(n3);
            }
            OS.g_list_free(n2);
            TableItem[] tableItemArray = new TableItem[n5];
            for (n3 = 0; n3 < tableItemArray.length; ++n3) {
                tableItemArray[n3] = this._getItem(nArray[n3]);
            }
            return tableItemArray;
        }
        return new TableItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(n);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        int n2 = OS.gtk_tree_selection_get_selected_rows(n, null);
        if (n2 != 0) {
            int n3 = OS.g_list_length(n2);
            int[] nArray = new int[1];
            for (int i = 0; i < n3; ++i) {
                int n4 = OS.g_list_nth_data(n2, i);
                int n5 = OS.gtk_tree_path_get_indices(n4);
                if (n5 != 0) {
                    OS.memmove(nArray, n5, 4);
                    for (int j = i; j < n3; ++j) {
                        n4 = OS.g_list_nth_data(n2, j);
                        OS.gtk_tree_path_free(n4);
                    }
                    break;
                }
                OS.gtk_tree_path_free(n4);
            }
            OS.g_list_free(n2);
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        int n2 = OS.gtk_tree_selection_get_selected_rows(n, null);
        if (n2 != 0) {
            int n3 = OS.g_list_length(n2);
            int[] nArray = new int[n3];
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = OS.g_list_nth_data(n2, i);
                int n6 = OS.gtk_tree_path_get_indices(n5);
                if (n6 != 0) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, n6, 4);
                    nArray[n4] = nArray2[0];
                    ++n4;
                }
                OS.gtk_tree_path_free(n5);
            }
            OS.g_list_free(n2);
            int[] nArray3 = new int[n4];
            System.arraycopy(nArray, 0, nArray3, 0, n4);
            return nArray3;
        }
        return new int[0];
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    int getTextRenderer(int n) {
        int n2 = 0;
        n2 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(n) : OS.gtk_tree_view_column_get_cell_renderers(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = OS.g_list_length(n2);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = OS.g_list_nth_data(n2, i);
            if (!OS.GTK_IS_CELL_RENDERER_TEXT(n5)) continue;
            n4 = n5;
            break;
        }
        OS.g_list_free(n2);
        return n4;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, nArray, null, null, null)) {
            return 0;
        }
        if (nArray[0] == 0) {
            return 0;
        }
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        int[] nArray2 = new int[1];
        if (n != 0) {
            OS.memmove(nArray2, n, 4);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return nArray2[0];
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        int n3;
        int[] nArray;
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        int n4 = super.gtk_button_press_event(n, n2);
        if (n4 != 0) {
            return n4;
        }
        int n5 = gdkEventButton.button;
        if (n5 == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                n4 = 1;
            }
            OS.gtk_tree_path_free(nArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_view_set_cursor(this.handle, nArray[0], 0, false);
            OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_path_free(nArray[0]);
        }
        if (!this.gtk_widget_has_focus(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return n4;
    }

    @Override
    int gtk_button_release_event(int n, int n2) {
        int n3 = OS.GDK_EVENT_WINDOW(n2);
        if (n3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_button_release_event(n, n2);
    }

    @Override
    int gtk_changed(int n) {
        TableItem tableItem = this.getFocusItem();
        if (tableItem != null) {
            Event event = new Event();
            event.item = tableItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0;
    }

    @Override
    int gtk_event_after(int n, int n2) {
        switch (OS.GDK_EVENT_TYPE(n2)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0) != 0) break;
                this.gtk_expose_event(n, n2);
            }
        }
        return super.gtk_event_after(n, n2);
    }

    void drawInheritedBackground(int n, int n2) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            Object object;
            int n3 = OS.gtk_tree_view_get_bin_window(this.handle);
            int n4 = 0;
            if (n != 0) {
                object = new GdkEventExpose();
                OS.memmove((GdkEventExpose)object, n, GdkEventExpose.sizeof);
                if (n3 != object.window) {
                    return;
                }
                n4 = object.region;
            }
            object = new int[1];
            int[] nArray = new int[1];
            this.gdk_window_get_size(n3, (int[])object, nArray);
            int n5 = 0;
            if (this.itemCount != 0) {
                int n6 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, n6, 0, this.itemCount - 1);
                int n7 = OS.gtk_tree_model_get_path(this.modelHandle, n6);
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(this.handle, n7, 0, gdkRectangle);
                n5 = gdkRectangle.y + gdkRectangle.height;
                OS.gtk_tree_path_free(n7);
                OS.g_free(n6);
            }
            if (nArray[0] > n5) {
                this.drawBackground(control, n3, n2, n4, 0, n5, object[0], nArray[0] - n5);
            }
        }
    }

    @Override
    int gtk_draw(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawInheritedBackground(0, n2);
        return super.gtk_draw(n, n2);
    }

    @Override
    int gtk_expose_event(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawInheritedBackground(n2, 0);
        return super.gtk_expose_event(n, n2);
    }

    @Override
    int gtk_motion_notify_event(int n, int n2) {
        int n3 = OS.GDK_EVENT_WINDOW(n2);
        if (n3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_motion_notify_event(n, n2);
    }

    @Override
    int gtk_row_activated(int n, int n2, int n3) {
        Object object;
        TableItem tableItem = null;
        int n4 = OS.gtk_tree_path_get_indices(n2);
        if (n4 != 0) {
            object = new int[]{-1};
            OS.memmove((int[])object, n4, 4);
            tableItem = this._getItem((int)object[0]);
        }
        object = new Event();
        ((Event)object).item = tableItem;
        this.sendSelectionEvent(14, (Event)object, false);
        return 0;
    }

    @Override
    int gtk_row_deleted(int n, int n2) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_deleted);
        }
        return 0;
    }

    @Override
    int gtk_row_inserted(int n, int n2, int n3) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_inserted);
        }
        return 0;
    }

    @Override
    int gtk_start_interactive_search(int n) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(n, OS.start_interactive_search);
            return 1;
        }
        return 0;
    }

    @Override
    int gtk_toggled(int n, int n2) {
        int n3 = OS.gtk_tree_path_new_from_string(n2);
        if (n3 == 0) {
            return 0;
        }
        int n4 = OS.gtk_tree_path_get_indices(n3);
        if (n4 != 0) {
            int[] nArray = new int[1];
            OS.memmove(nArray, n4, 4);
            TableItem tableItem = this._getItem(nArray[0]);
            tableItem.setChecked(!tableItem.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = tableItem;
            this.sendSelectionEvent(13, event, false);
        }
        OS.gtk_tree_path_free(n3);
        return 0;
    }

    @Override
    void gtk_widget_size_request(int n, GtkRequisition gtkRequisition) {
        int n2;
        boolean bl;
        int n3;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(n, gtkRequisition);
            return;
        }
        int n4 = n3 = OS.gtk_tree_view_get_columns(this.handle);
        boolean bl2 = bl = n3 != 0;
        while (n4 != 0) {
            n2 = OS.g_list_data(n4);
            if (OS.gtk_tree_view_column_get_visible(n2)) {
                bl = false;
                break;
            }
            n4 = OS.g_list_next(n4);
        }
        n2 = 0;
        if (bl) {
            n2 = OS.g_list_data(n3);
            OS.gtk_tree_view_column_set_visible(n2, true);
        }
        super.gtk_widget_size_request(n, gtkRequisition);
        if (bl) {
            OS.gtk_tree_view_column_set_visible(n2, false);
        }
        if (n3 != 0) {
            OS.g_list_free(n3);
        }
    }

    void hideFirstColumn() {
        int n = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(n, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(n, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != tableColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            for (int i = 0; i < this.itemCount; ++i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        } else {
            for (int i = this.itemCount - 1; i >= 0; --i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(null, Integer.toString(n), true);
        int n3 = OS.gtk_tree_path_new_from_string(byArray);
        boolean bl = OS.gtk_tree_selection_path_is_selected(n2, n3);
        OS.gtk_tree_path_free(n3);
        return bl;
    }

    @Override
    boolean mnemonicHit(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            int n = this.columns[i].labelHandle;
            if (n == 0 || !this.mnemonicHit(n, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            int n = this.columns[i].labelHandle;
            if (n == 0 || !this.mnemonicMatch(n, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    int paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            int n = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 5, true, 0);
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn tableColumn = this.columns[i];
                this.createRenderers(tableColumn.handle, tableColumn.modelIndex, i == 0, tableColumn.style);
            }
        }
    }

    @Override
    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    @Override
    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            for (n = 0; n < this.itemCount; ++n) {
                item = this.items[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.checkRenderer != 0) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(15);
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        TableItem tableItem = this.items[n];
        boolean bl = false;
        if (tableItem != null) {
            bl = tableItem.isDisposed();
            if (!bl) {
                OS.memmove(n2, tableItem.handle, OS.GtkTreeIter_sizeof());
                tableItem.release(false);
            }
        } else {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        }
        if (!bl) {
            int n3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_list_store_remove(this.modelHandle, n2);
            OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
            System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
            this.items[this.itemCount] = null;
        }
        OS.g_free(n2);
    }

    public void remove(int n, int n2) {
        int n3;
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n4 = OS.gtk_tree_view_get_selection(this.handle);
        int n5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n5 == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        for (n3 = n2; n3 >= n; --n3) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n5, 0, n3);
            TableItem tableItem = this.items[n3];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            OS.g_signal_handlers_block_matched(n4, 16, 0, 0, 0, 0, 6);
            OS.gtk_list_store_remove(this.modelHandle, n5);
            OS.g_signal_handlers_unblock_matched(n4, 16, 0, 0, 0, 0, 6);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(n5);
        n3 = n2 + 1;
        System.arraycopy(this.items, n3, this.items, n, this.itemCount - n3);
        for (int i = this.itemCount - (n3 - n); i < this.itemCount; ++i) {
            this.items[i] = null;
        }
        this.itemCount -= n3 - n;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        int n4 = -1;
        int n5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n5 == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            int n6 = nArray2[i];
            if (n6 == n4) continue;
            TableItem tableItem = this.items[n6];
            boolean bl = false;
            if (tableItem != null) {
                bl = tableItem.isDisposed();
                if (!bl) {
                    OS.memmove(n5, tableItem.handle, OS.GtkTreeIter_sizeof());
                    tableItem.release(false);
                }
            } else {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, n5, 0, n6);
            }
            if (!bl) {
                OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
                OS.gtk_list_store_remove(this.modelHandle, n5);
                OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
                System.arraycopy(this.items, n6 + 1, this.items, n6, --this.itemCount - n6);
                this.items[this.itemCount] = null;
            }
            n4 = n6;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(n5);
    }

    public void removeAll() {
        this.checkWidget();
        for (int i = this.itemCount - 1; i >= 0; --i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_list_store_clear(this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        this.resetCustomDraw();
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n2 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendMeasureEvent(int n, int n2, int n3) {
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(n) && this.hooks(41)) {
            int n4;
            int[] nArray;
            int n5;
            int n6 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX2);
            TableItem tableItem = null;
            boolean bl = false;
            if (n6 != 0) {
                n5 = OS.gtk_tree_model_get_path(this.modelHandle, n6);
                nArray = new int[1];
                OS.memmove(nArray, OS.gtk_tree_path_get_indices(n5), 4);
                n4 = nArray[0];
                tableItem = this._getItem(n4);
                int n7 = OS.gtk_tree_view_get_selection(this.handle);
                bl = OS.gtk_tree_selection_path_is_selected(n7, n5);
                OS.gtk_tree_path_free(n5);
            }
            if (tableItem != null) {
                Object object;
                n5 = 0;
                if (this.columnCount > 0) {
                    int n8 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX1);
                    for (n4 = 0; n4 < this.columnCount; ++n4) {
                        if (this.columns[n4].handle != n8) continue;
                        n5 = n4;
                        break;
                    }
                }
                nArray = new int[1];
                int[] nArray2 = new int[1];
                if (n2 != 0) {
                    OS.memmove(nArray, n2, 4);
                }
                if (n3 != 0) {
                    OS.memmove(nArray2, n3, 4);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_get_preferred_height_for_width(n, this.handle, nArray[0], nArray2, null);
                }
                Image image = tableItem.getImage(n5);
                int n9 = 0;
                if (image != null) {
                    object = image.getBounds();
                    n9 = ((Rectangle)object).width;
                }
                nArray[0] = nArray[0] + n9;
                object = new GC(this);
                ((GC)object).setFont(tableItem.getFont(n5));
                Event event = new Event();
                event.item = tableItem;
                event.index = n5;
                event.gc = object;
                event.width = nArray[0];
                event.height = nArray2[0];
                if (bl) {
                    event.detail = 2;
                }
                this.sendEvent(41, event);
                ((Resource)object).dispose();
                nArray[0] = event.width - n9;
                if (nArray2[0] < event.height) {
                    nArray2[0] = event.height;
                }
                if (n2 != 0) {
                    OS.memmove(n2, nArray, 4);
                }
                if (n3 != 0) {
                    OS.memmove(n3, nArray2, 4);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_set_fixed_size(n, nArray[0], nArray2[0]);
                }
            }
        }
    }

    @Override
    int rendererGetPreferredWidthProc(int n, int n2, int n3, int n4) {
        int n5 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, n5);
        OS.call(gtkCellRendererClass.get_preferred_width, n, n2, n3, n4);
        this.sendMeasureEvent(n, n3, 0);
        return 0;
    }

    @Override
    int rendererGetSizeProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, n8);
        OS.call_get_size(gtkCellRendererClass.get_size, n, this.handle, n3, n4, n5, n6, n7);
        this.sendMeasureEvent(n, n6, n7);
        return 0;
    }

    @Override
    int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.rendererRender(n, n2, 0, n3, n4, n5, 0, n6);
        return 0;
    }

    @Override
    int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.rendererRender(n, 0, n2, n3, n4, n5, n6, n7);
        return 0;
    }

    void rendererRender(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Object object;
        Object object2;
        Object object3;
        int n9;
        int n10;
        TableItem tableItem = null;
        int n11 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX2);
        if (n11 != 0) {
            n10 = OS.gtk_tree_model_get_path(this.modelHandle, n11);
            int[] nArray = new int[1];
            OS.memmove(nArray, OS.gtk_tree_path_get_indices(n10), 4);
            n9 = nArray[0];
            tableItem = this._getItem(n9);
            OS.gtk_tree_path_free(n10);
        }
        n10 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX1);
        int n12 = 0;
        if (this.columnCount > 0) {
            for (n9 = 0; n9 < this.columnCount; ++n9) {
                if (this.columns[n9].handle != n10) continue;
                n12 = n9;
                break;
            }
        }
        if (tableItem != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(n) || OS.GTK_IS_CELL_RENDERER_PIXBUF(n) && (n12 != 0 || (this.style & 0x20) == 0))) {
            int n13;
            Control control;
            this.drawFlags = n8;
            this.drawState = 16;
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, 3, nArray, -1);
            if (nArray[0] == 0) {
                int n14 = this.columnCount == 0 ? 5 : this.columns[n12].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, n14 + 3, nArray, -1);
            }
            if (nArray[0] != 0) {
                this.drawState |= 8;
                OS.gdk_color_free(nArray[0]);
            }
            if ((n8 & 1) != 0) {
                this.drawState |= 2;
            }
            if (!(OS.GTK3 && (n8 & 1) != 0 || (n8 & 0x10) == 0)) {
                this.drawState |= 4;
            }
            object3 = new GdkRectangle();
            int n15 = OS.gtk_tree_model_get_path(this.modelHandle, n11);
            OS.gtk_tree_view_get_background_area(this.handle, n15, n10, (GdkRectangle)object3);
            OS.gtk_tree_path_free(n15);
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                if (n2 != 0) {
                    Cairo.cairo_save(n2);
                    Cairo.cairo_reset_clip(n2);
                }
                this.drawBackground(control, n3, n2, 0, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                if (n2 != 0) {
                    Cairo.cairo_restore(n2);
                }
            }
            if ((n13 = this.getTextRenderer(n10)) != 0) {
                this.gtk_cell_renderer_get_preferred_size(n13, this.handle, null, null);
            }
            if (this.hooks(40)) {
                Object object4;
                boolean bl;
                boolean bl2 = bl = (this.drawState & 2) != 0;
                if (bl) {
                    object4 = this.findBackgroundControl();
                    if (object4 == null) {
                        object4 = this;
                    }
                    if (n2 != 0) {
                        Cairo.cairo_save(n2);
                        Cairo.cairo_reset_clip(n2);
                    }
                    this.drawBackground((Control)object4, n3, n2, 0, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                    if (n2 != 0) {
                        Cairo.cairo_restore(n2);
                    }
                }
                object4 = new GC(this);
                if ((this.drawState & 2) != 0) {
                    ((GC)object4).setBackground(this.display.getSystemColor(26));
                    ((GC)object4).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object4).setBackground(tableItem.getBackground(n12));
                    ((GC)object4).setForeground(tableItem.getForeground(n12));
                }
                ((GC)object4).setFont(tableItem.getFont(n12));
                if ((this.style & 0x8000000) != 0) {
                    ((GdkRectangle)object3).x = this.getClientWidth() - ((GdkRectangle)object3).width - ((GdkRectangle)object3).x;
                }
                ((GC)object4).setClipping(((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                object2 = new Event();
                ((Event)object2).item = tableItem;
                ((Event)object2).index = n12;
                ((Event)object2).gc = object4;
                ((Event)object2).x = ((GdkRectangle)object3).x;
                ((Event)object2).y = ((GdkRectangle)object3).y;
                ((Event)object2).width = ((GdkRectangle)object3).width;
                ((Event)object2).height = ((GdkRectangle)object3).height;
                ((Event)object2).detail = this.drawState;
                this.sendEvent(40, (Event)object2);
                this.drawForeground = null;
                int n16 = this.drawState = ((Event)object2).doit ? ((Event)object2).detail : 0;
                if (OS.GTK_VERSION >= OS.VERSION(3, 9, 0)) {
                    this.drawState |= 0x10;
                }
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    int n17;
                    if (OS.GTK3) {
                        Cairo.cairo_save(n2);
                        Cairo.cairo_reset_clip(n2);
                        n17 = OS.gtk_widget_get_style_context(n4);
                        OS.gtk_style_context_save(n17);
                        OS.gtk_style_context_add_class(n17, OS.GTK_STYLE_CLASS_CELL);
                        OS.gtk_style_context_set_state(n17, 4);
                        OS.gtk_render_background(n17, n2, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                        OS.gtk_style_context_restore(n17);
                        Cairo.cairo_restore(n2);
                    } else {
                        n17 = OS.gtk_widget_get_style(n4);
                        object = Converter.wcsToMbcs(null, "cell_odd", true);
                        OS.gtk_paint_flat_box(n17, n3, 3, 0, (GdkRectangle)object3, n4, (byte[])object, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                    }
                } else if (bl) {
                    this.drawForeground = ((GC)object4).getForeground().handle;
                }
                ((Resource)object4).dispose();
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gC = new GC(this);
            gC.setBackground(tableItem.getBackground(n12));
            object3 = new GdkRectangle();
            OS.memmove((GdkRectangle)object3, n5, GdkRectangle.sizeof);
            gC.fillRectangle(((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
            gC.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(n)) {
            int n18 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
            object3 = new GtkCellRendererClass();
            OS.memmove((GtkCellRendererClass)object3, n18);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(n)) {
                OS.g_object_set(n, OS.foreground_gdk, this.drawForeground, 0);
            }
            if (OS.GTK3) {
                OS.call(((GtkCellRendererClass)object3).render, n, n2, n4, n5, n6, this.drawFlags);
            } else {
                OS.call(((GtkCellRendererClass)object3).render, n, n3, n4, n5, n6, n7, this.drawFlags);
            }
        }
        if (tableItem != null && OS.GTK_IS_CELL_RENDERER_TEXT(n) && this.hooks(42)) {
            Object object5;
            GdkRectangle gdkRectangle = new GdkRectangle();
            int n19 = OS.gtk_tree_model_get_path(this.modelHandle, n11);
            OS.gtk_tree_view_get_background_area(this.handle, n19, n10, gdkRectangle);
            OS.gtk_tree_path_free(n19);
            this.ignoreSize = true;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.gtk_cell_renderer_get_preferred_size(n, this.handle, nArray2, null);
            OS.gtk_tree_view_column_cell_get_position(n10, n, nArray, null);
            this.ignoreSize = false;
            Image image = tableItem.getImage(n12);
            int n20 = 0;
            if (image != null) {
                object2 = image.getBounds();
                n20 = ((Rectangle)object2).width;
            }
            nArray[0] = nArray[0] - n20;
            nArray2[0] = nArray2[0] + n20;
            object2 = new GC(this);
            if ((this.drawState & 2) != 0) {
                if (this.gtk_widget_has_focus(this.handle) || OS.GTK3) {
                    object5 = this.display.getSystemColor(26);
                    object = this.display.getSystemColor(27);
                } else {
                    object5 = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_INACTIVE);
                    object = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_TEXT_INACTIVE);
                }
                ((GC)object2).setBackground((Color)object5);
                ((GC)object2).setForeground((Color)object);
            } else {
                ((GC)object2).setBackground(tableItem.getBackground(n12));
                object5 = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : tableItem.getForeground(n12);
                ((GC)object2).setForeground((Color)object5);
            }
            ((GC)object2).setFont(tableItem.getFont(n12));
            if ((this.style & 0x8000000) != 0) {
                gdkRectangle.x = this.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
            }
            ((GC)object2).setClipping(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            object5 = new Event();
            ((Event)object5).item = tableItem;
            ((Event)object5).index = n12;
            ((Event)object5).gc = object2;
            ((Event)object5).x = gdkRectangle.x + nArray[0];
            ((Event)object5).y = gdkRectangle.y;
            ((Event)object5).width = nArray2[0];
            ((Event)object5).height = gdkRectangle.height;
            ((Event)object5).detail = this.drawState;
            this.sendEvent(42, (Event)object5);
            ((Resource)object2).dispose();
        }
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (!bl) continue;
            int n2 = OS.gtk_tree_view_get_column(this.handle, i);
            int n3 = this.getTextRenderer(n2);
            OS.gtk_tree_view_column_set_cell_data_func(n2, n3, 0, 0, 0);
            if (this.columnCount == 0) continue;
            this.columns[i].customDraw = false;
        }
        this.firstCustomDraw = false;
    }

    @Override
    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.itemCount; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskin(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                item = this.columns[n2];
                if (item.isDisposed()) continue;
                item.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void select(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        TableItem tableItem = this._getItem(n);
        OS.gtk_tree_selection_select_iter(n2, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        boolean bl = this.showFirstColumn();
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        for (int i = n; i <= n2; ++i) {
            TableItem tableItem = this._getItem(i);
            OS.gtk_tree_selection_select_iter(n3, tableItem.handle);
        }
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (0 > n3 || n3 >= this.itemCount) continue;
            TableItem tableItem = this._getItem(n3);
            OS.gtk_tree_selection_select_iter(n2, tableItem.handle);
        }
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_select_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void selectFocusIndex(int n) {
        if (0 > n || n >= this.itemCount) {
            return;
        }
        TableItem tableItem = this._getItem(n);
        int n2 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_view_set_cursor(this.handle, n2, 0, false);
        OS.gtk_tree_selection_select_iter(n3, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_path_free(n2);
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
        } else {
            GdkColor gdkColor2 = this.getDisplay().COLOR_LIST_SELECTION;
            GdkRGBA gdkRGBA = new GdkRGBA();
            gdkRGBA.alpha = 1.0;
            gdkRGBA.red = (float)(gdkColor2.red & 0xFFFF) / 65535.0f;
            gdkRGBA.green = (float)(gdkColor2.green & 0xFFFF) / 65535.0f;
            gdkRGBA.blue = (float)(gdkColor2.blue & 0xFFFF) / 65535.0f;
            OS.gtk_widget_override_background_color(this.handle, 4, gdkRGBA);
        }
    }

    @Override
    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n < 0 || n >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = this.columns[nArray[n2]].handle;
            int n3 = n2 == 0 ? 0 : this.columns[nArray[n2 - 1]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, n, n3);
        }
    }

    @Override
    void setFontDescription(int n) {
        super.setFontDescription(n);
        TableColumn[] tableColumnArray = this.getColumns();
        for (int i = 0; i < tableColumnArray.length; ++i) {
            if (tableColumnArray[i] == null) continue;
            tableColumnArray[i].setFontDescription(n);
        }
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor, false);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, bl);
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(n, this.itemCount - 1);
        int n2 = Math.max(4, (n + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n2];
        System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        this.items = tableItemArray;
        if (bl) {
            int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (n3 == 0) {
                this.error(2);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            for (int i = this.itemCount; i < n; ++i) {
                OS.gtk_list_store_append(this.modelHandle, n3);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
            OS.g_free(n3);
            this.itemCount = n;
        } else {
            for (int i = this.itemCount; i < n; ++i) {
                new TableItem(this, 0, i, true);
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_rules_hint(this.handle, bl);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
        }
    }

    void setModel(int n) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = n;
        this.display.addWidget(this.modelHandle, this);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        int n;
        super.setOrientation(bl);
        for (n = 0; n < this.itemCount; ++n) {
            if (this.items[n] == null) continue;
            this.items[n].setOrientation(bl);
        }
        for (n = 0; n < this.columnCount; ++n) {
            if (this.columns[n] == null) continue;
            this.columns[n].setOrientation(bl);
        }
    }

    @Override
    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    void setParentWindow(int n) {
        int n2 = this.eventWindow();
        OS.gtk_widget_set_parent_window(n, n2);
    }

    @Override
    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] tableItemArray = new TableItem[n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
            this.items = tableItemArray;
        }
    }

    void setScrollWidth(int n, TableItem tableItem) {
        int n2;
        if (this.columnCount != 0 || this.currentItem == tableItem) {
            return;
        }
        int n3 = OS.gtk_tree_view_column_get_fixed_width(n);
        if (n3 < (n2 = this.calculateWidth(n, tableItem.handle))) {
            OS.gtk_tree_view_column_set_fixed_width(n, n2);
        }
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(TableItem tableItem) {
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        int n = tableItemArray.length;
        if (n != 0 && ((this.style & 4) == 0 || n <= 1)) {
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                int n2 = this.indexOf(tableItemArray[i]);
                if (n2 == -1) continue;
                if (bl2) {
                    bl2 = false;
                    this.selectFocusIndex(n2);
                    continue;
                }
                this.select(n2);
            }
            this.showSelection();
        }
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return;
        }
        int n2 = OS.gtk_tree_model_get_path(this.modelHandle, this._getItem((int)n).handle);
        OS.gtk_tree_view_scroll_to_cell(this.handle, n2, 0, true, 0.0f, 0.0f);
        OS.gtk_tree_path_free(n2);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, 0, tableColumn.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle2);
        if (gdkRectangle.x < gdkRectangle2.x) {
            OS.gtk_tree_view_scroll_to_point(this.handle, gdkRectangle.x, -1);
        } else {
            int n = Math.min(gdkRectangle2.width, gdkRectangle.width);
            if (gdkRectangle.x + n > gdkRectangle2.x + gdkRectangle2.width) {
                int n2 = gdkRectangle.x + n - gdkRectangle2.width;
                OS.gtk_tree_view_scroll_to_point(this.handle, n2, -1);
            }
        }
    }

    boolean showFirstColumn() {
        int n;
        int n2 = Math.max(1, this.columnCount);
        for (n = 0; n < n2; ++n) {
            int n3 = OS.gtk_tree_view_get_column(this.handle, n);
            if (!OS.gtk_tree_view_column_get_visible(n3)) continue;
            return false;
        }
        n = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(n, true);
        return true;
    }

    public void showItem(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if (tableItem.parent != this) {
            return;
        }
        this.showItem(tableItem.handle);
    }

    void showItem(int n) {
        int n2 = OS.gtk_tree_model_get_path(this.modelHandle, n);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, n2, 0, gdkRectangle2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        } else {
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        }
        if (nArray2[0] < gdkRectangle.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, n2, 0, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        } else {
            int n3 = Math.min(gdkRectangle.height, gdkRectangle2.height);
            if (nArray2[0] + n3 > gdkRectangle.y + gdkRectangle.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, n2, 0, true, 1.0f, 0.0f);
                nArray2[0] = nArray2[0] + (gdkRectangle2.height - gdkRectangle.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
            }
        }
        OS.gtk_tree_path_free(n2);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.getSelection();
        if (tableItemArray.length == 0) {
            return;
        }
        TableItem tableItem = tableItemArray[0];
        this.showItem(tableItem.handle);
    }

    @Override
    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        int n = this.parentingHandle();
        int n2 = OS.gtk_container_get_children(n);
        if (n2 == 0) {
            return;
        }
        int n3 = n2;
        while (n3 != 0) {
            int n4 = OS.g_list_data(n3);
            if (n4 != 0) {
                OS.gtk_widget_queue_resize(n4);
            }
            n3 = OS.g_list_next(n3);
        }
        OS.g_list_free(n2);
    }

    @Override
    int windowProc(int n, int n2, int n3) {
        switch (n3) {
            case 19: {
                Control control;
                if (this.itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
                int n4 = OS.gtk_tree_view_get_bin_window(n);
                if (n4 != gdkEventExpose.window) break;
                this.drawBackground(control, n4, gdkEventExpose.region, gdkEventExpose.area_x, gdkEventExpose.area_y, gdkEventExpose.area_width, gdkEventExpose.area_height);
            }
        }
        return super.windowProc(n, n2, n3);
    }
}

