/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.pdfsam.console.business.ConsoleServicesFacade;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class ConsoleClient {
    private static final Logger LOG = Logger.getLogger(ConsoleClient.class.getPackage().getName());
    private static final String consoleLogLevelProperty = "pdfsam.log.console.level";
    private static final String fileLogLevelProperty = "pdfsam.log.file.level";
    private static final String filenameLogLevelProperty = "pdfsam.log.file.filename";
    private static final String CONSOLE_APPENDER_NAME = "CONSOLE";
    private static final String FILE_APPENDER_NAME = "FILE";
    private static ConsoleServicesFacade serviceFacade;

    public static void main(String[] args) {
        ConsoleClient.initLoggingFramework();
        try {
            if (args == null || args.length == 0) {
                args = new String[]{"-help"};
            }
            if ((serviceFacade = new ConsoleServicesFacade()) != null) {
                AbstractParsedCommand parsedCommand = serviceFacade.parseAndValidate(args);
                if (parsedCommand != null) {
                    serviceFacade.execute(parsedCommand);
                }
            } else {
                LOG.fatal("Unable to reach services, service facade is null.");
            }
        }
        catch (Throwable t) {
            LOG.fatal("Error executing ConsoleClient", t);
            System.exit(1);
        }
    }

    private static void initLoggingFramework() {
        try {
            String consoleLevel = System.getProperty(consoleLogLevelProperty, "DEBUG");
            String fileLevel = System.getProperty(fileLogLevelProperty, "DEBUG");
            String fileName = System.getProperty(filenameLogLevelProperty);
            ConsoleAppender consoleAppender = (ConsoleAppender)Logger.getRootLogger().getAppender(CONSOLE_APPENDER_NAME);
            if (consoleAppender != null) {
                Level consoleThreshold = Level.toLevel(consoleLevel, Level.DEBUG);
                consoleAppender.setThreshold(consoleThreshold);
                LOG.debug("Console LOG level set to " + consoleThreshold);
            }
            if (fileName != null) {
                PatternLayout layout = new PatternLayout("%d{ABSOLUTE} %-5p %x %m%n");
                FileAppender fileAppender = new FileAppender(layout, fileName, false);
                fileAppender.setName(FILE_APPENDER_NAME);
                Level fileThreshold = Level.toLevel(fileLevel, Level.DEBUG);
                fileAppender.setThreshold(fileThreshold);
                Logger.getRootLogger().addAppender(fileAppender);
                LOG.debug("Added fileAppender (" + fileName + ") at level " + fileThreshold);
            }
        }
        catch (Exception e) {
            System.err.println("Error configuring logging framework: " + e.getMessage());
        }
    }
}

