/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.Iterator;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.PageRotation;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.RotateParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.exceptions.console.RotateException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class RotateCmdValidator
extends AbstractCmdValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        StringParam rOption;
        PdfFileParam fOption;
        RotateParsedCommand parsedCommandDTO = new RotateParsedCommand();
        if (cmdLineHandler == null) throw new ConsoleException(2);
        FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
        if (!oOption.isSet()) {
            throw new ParseException(15);
        }
        File outFile = oOption.getFile();
        ValidationUtility.assertValidDirectory(outFile);
        parsedCommandDTO.setOutputFile(outFile);
        StringParam pOption = (StringParam)cmdLineHandler.getOption("p");
        if (pOption.isSet()) {
            parsedCommandDTO.setOutputFilesPrefix(pOption.getValue());
        }
        if ((fOption = (PdfFileParam)cmdLineHandler.getOption("f")).isSet()) {
            Iterator fIterator = fOption.getPdfFiles().iterator();
            while (fIterator.hasNext()) {
                PdfFile currentFile = (PdfFile)fIterator.next();
                ValidationUtility.assertValidPdfExtension(currentFile.getFile().getName());
            }
            parsedCommandDTO.setInputFileList(FileUtility.getPdfFiles(fOption.getPdfFiles()));
        }
        if (!(rOption = (StringParam)cmdLineHandler.getOption("r")).isSet()) return parsedCommandDTO;
        PageRotation[] rotations = ValidationUtility.getPagesRotation(rOption.getValue(), false);
        if (rotations.length != 1) throw new RotateException(1, new String[]{rOption.getValue()});
        parsedCommandDTO.setRotation(rotations[0]);
        return parsedCommandDTO;
    }
}

