/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import org.apache.log4j.Logger;
import org.dom4j.Node;
import org.pdfsam.guiclient.GuiClient;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.guiclient.plugins.models.PluginDataModel;
import org.pdfsam.guiclient.plugins.models.PluginsTableModel;
import org.pdfsam.i18n.GettextResource;

public class JInfoPanel
extends AbstractPlugablePanel {
    private static final long serialVersionUID = 8500896540097187242L;
    private static final Logger log = Logger.getLogger(JInfoPanel.class.getPackage().getName());
    private JTable tablePlugins;
    private JTextPane textInfoArea;
    private final JScrollPane textInfoScrollPanel = new JScrollPane();
    private String javaHome = "";
    private String javaVersion = "";
    private String configPath = "";
    private Map<PluginDataModel, AbstractPlugablePanel> plugins;
    private final InfoFocusPolicy infoFocusPolicy = new InfoFocusPolicy();
    private static final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private static final String PLUGIN_VERSION = "0.0.4e";

    public JInfoPanel(Map<PluginDataModel, AbstractPlugablePanel> plugins) {
        this.plugins = plugins;
        this.initialize();
    }

    private void initialize() {
        this.setPanelIcon("/images/info.png");
        try {
            this.javaHome = System.getProperty("java.home");
            this.javaVersion = System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version");
            this.configPath = Configuration.getInstance().getConfigurationInformations();
        }
        catch (Exception e) {
            log.error("error:", e);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.textInfoScrollPanel.setPreferredSize(new Dimension(300, 100));
        this.textInfoArea = new JTextPane();
        this.textInfoArea.setFont(new Font("Dialog", 0, 9));
        this.textInfoArea.setPreferredSize(new Dimension(300, 100));
        this.textInfoArea.setBorder(new EtchedBorder(1));
        this.textInfoArea.setContentType("text/html");
        this.textInfoArea.setText("<html><head></head><body>" + GuiClient.getApplicationName() + "<br><br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Version: ") + GuiClient.getVersion() + "<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Console version: ") + "2.4.3e" + "<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Developed by: ") + PLUGIN_AUTHOR + "<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Build date: ") + GuiClient.getBuildDate() + "<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Java home: ") + this.javaHome + "<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Java version: ") + this.javaVersion + "<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Max memory: ") + Runtime.getRuntime().maxMemory() / 0x100000L + "Mb<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Configuration file: ") + this.configPath + "<br>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Website: ") + "<a href=\"http://www.pdfsam.org\" title=\"pdfsam\">http://www.pdfsam.org</a>" + "<br><br>" + this.getThanksText() + "</body></html>");
        this.textInfoArea.setEditable(false);
        this.textInfoScrollPanel.setViewportView(this.textInfoArea);
        JScrollPane installedPluginsScrollPanel = new JScrollPane();
        installedPluginsScrollPanel.setPreferredSize(new Dimension(300, 100));
        this.tablePlugins = new JTable();
        PluginsTableModel tablePluginsModel = new PluginsTableModel(this.plugins);
        String[] i18nColumnsName = new String[]{GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Name"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Version"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Author")};
        tablePluginsModel.setColumnNames(i18nColumnsName);
        this.tablePlugins.setModel(tablePluginsModel);
        this.tablePlugins.setGridColor(Color.LIGHT_GRAY);
        this.tablePlugins.setFocusable(false);
        this.tablePlugins.setRowSelectionAllowed(false);
        this.tablePlugins.setIntercellSpacing(new Dimension(2, 2));
        this.tablePlugins.setBorder(new EtchedBorder(1));
        installedPluginsScrollPanel.setViewportView(this.tablePlugins);
        this.add(this.textInfoScrollPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(installedPluginsScrollPanel);
    }

    @Override
    public String getPluginAuthor() {
        return PLUGIN_AUTHOR;
    }

    @Override
    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"About");
    }

    @Override
    public String getVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        return arg0;
    }

    @Override
    public void loadJobNode(Node arg0) throws LoadJobException {
        log.debug(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unimplemented method for JInfoPanel"));
    }

    protected String getThanksText() {
        String[] contributors = new String[]{"SourceForge", "Freshmeat", "Launchpad", "Rosetta translators", "Ubuntu", "iText", "GNU", "OpenOffice", "jcmdline", "JGoodies", "Eclipse", "Xenoage Software", "Elisa Bortolotti", "Bigpapa", "Alberto Bortolotti", "Chiara Casamatti", "dom4j", "jaxen", "log4j", "BouncyCastle", "All the donors and contributors"};
        StringBuilder contributes = new StringBuilder(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Contributes: "));
        for (int i = 0; i < contributors.length; ++i) {
            contributes.append(contributors[i]).append(" - ");
        }
        return contributes.toString();
    }

    @Override
    public FocusTraversalPolicy getFocusPolicy() {
        return this.infoFocusPolicy;
    }

    @Override
    public void resetPanel() {
    }

    public class InfoFocusPolicy
    extends FocusTraversalPolicy {
        @Override
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(JInfoPanel.this.textInfoArea)) {
                return JInfoPanel.this.textInfoArea;
            }
            return JInfoPanel.this.textInfoArea;
        }

        @Override
        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(JInfoPanel.this.textInfoArea)) {
                return JInfoPanel.this.textInfoArea;
            }
            return JInfoPanel.this.textInfoArea;
        }

        @Override
        public Component getDefaultComponent(Container CycleRootComp) {
            return JInfoPanel.this.textInfoArea;
        }

        @Override
        public Component getLastComponent(Container CycleRootComp) {
            return JInfoPanel.this.textInfoArea;
        }

        @Override
        public Component getFirstComponent(Container CycleRootComp) {
            return JInfoPanel.this.textInfoArea;
        }
    }
}

