/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFImageMetadata;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

class GIFWritableImageMetadata
extends GIFImageMetadata {
    static final String NATIVE_FORMAT_NAME = "javax_imageio_gif_image_1.0";

    GIFWritableImageMetadata() {
        super(true, NATIVE_FORMAT_NAME, "com.sun.media.imageioimpl.plugins.gif.GIFImageMetadataFormat", null, null);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void reset() {
        this.imageLeftPosition = 0;
        this.imageTopPosition = 0;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.interlaceFlag = false;
        this.sortFlag = false;
        this.localColorTable = null;
        this.disposalMethod = 0;
        this.userInputFlag = false;
        this.transparentColorFlag = false;
        this.delayTime = 0;
        this.transparentColorIndex = 0;
        this.hasPlainTextExtension = false;
        this.textGridLeft = 0;
        this.textGridTop = 0;
        this.textGridWidth = 0;
        this.textGridHeight = 0;
        this.characterCellWidth = 0;
        this.characterCellHeight = 0;
        this.textForegroundColor = 0;
        this.textBackgroundColor = 0;
        this.text = null;
        this.applicationIDs = null;
        this.authenticationCodes = null;
        this.applicationData = null;
        this.comments = null;
    }

    private byte[] fromISO8859(String data) {
        try {
            return data.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return new String("").getBytes();
        }
    }

    protected void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(NATIVE_FORMAT_NAME)) {
            GIFWritableImageMetadata.fatal(node, "Root must be javax_imageio_gif_image_1.0");
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String name = node.getNodeName();
            if (name.equals("ImageDescriptor")) {
                this.imageLeftPosition = GIFWritableImageMetadata.getIntAttribute(node, "imageLeftPosition", -1, true, true, 0, 65535);
                this.imageTopPosition = GIFWritableImageMetadata.getIntAttribute(node, "imageTopPosition", -1, true, true, 0, 65535);
                this.imageWidth = GIFWritableImageMetadata.getIntAttribute(node, "imageWidth", -1, true, true, 1, 65535);
                this.imageHeight = GIFWritableImageMetadata.getIntAttribute(node, "imageHeight", -1, true, true, 1, 65535);
                this.interlaceFlag = GIFWritableImageMetadata.getBooleanAttribute(node, "interlaceFlag", false, true);
                continue;
            }
            if (name.equals("LocalColorTable")) {
                int sizeOfLocalColorTable = GIFWritableImageMetadata.getIntAttribute(node, "sizeOfLocalColorTable", true, 2, 256);
                if (sizeOfLocalColorTable != 2 && sizeOfLocalColorTable != 4 && sizeOfLocalColorTable != 8 && sizeOfLocalColorTable != 16 && sizeOfLocalColorTable != 32 && sizeOfLocalColorTable != 64 && sizeOfLocalColorTable != 128 && sizeOfLocalColorTable != 256) {
                    GIFWritableImageMetadata.fatal(node, "Bad value for LocalColorTable attribute sizeOfLocalColorTable!");
                }
                this.sortFlag = GIFWritableImageMetadata.getBooleanAttribute(node, "sortFlag", false, true);
                this.localColorTable = this.getColorTable(node, "ColorTableEntry", true, sizeOfLocalColorTable);
                continue;
            }
            if (name.equals("GraphicControlExtension")) {
                String disposalMethodName = GIFWritableImageMetadata.getStringAttribute(node, "disposalMethod", null, true, disposalMethodNames);
                this.disposalMethod = 0;
                while (!disposalMethodName.equals(disposalMethodNames[this.disposalMethod])) {
                    ++this.disposalMethod;
                }
                this.userInputFlag = GIFWritableImageMetadata.getBooleanAttribute(node, "userInputFlag", false, true);
                this.transparentColorFlag = GIFWritableImageMetadata.getBooleanAttribute(node, "transparentColorFlag", false, true);
                this.delayTime = GIFWritableImageMetadata.getIntAttribute(node, "delayTime", -1, true, true, 0, 65535);
                this.transparentColorIndex = GIFWritableImageMetadata.getIntAttribute(node, "transparentColorIndex", -1, true, true, 0, 65535);
                continue;
            }
            if (name.equals("PlainTextExtension")) {
                this.hasPlainTextExtension = true;
                this.textGridLeft = GIFWritableImageMetadata.getIntAttribute(node, "textGridLeft", -1, true, true, 0, 65535);
                this.textGridTop = GIFWritableImageMetadata.getIntAttribute(node, "textGridTop", -1, true, true, 0, 65535);
                this.textGridWidth = GIFWritableImageMetadata.getIntAttribute(node, "textGridWidth", -1, true, true, 1, 65535);
                this.textGridHeight = GIFWritableImageMetadata.getIntAttribute(node, "textGridHeight", -1, true, true, 1, 65535);
                this.characterCellWidth = GIFWritableImageMetadata.getIntAttribute(node, "characterCellWidth", -1, true, true, 1, 65535);
                this.characterCellHeight = GIFWritableImageMetadata.getIntAttribute(node, "characterCellHeight", -1, true, true, 1, 65535);
                this.textForegroundColor = GIFWritableImageMetadata.getIntAttribute(node, "textForegroundColor", -1, true, true, 0, 255);
                this.textBackgroundColor = GIFWritableImageMetadata.getIntAttribute(node, "textBackgroundColor", -1, true, true, 0, 255);
                String textString = GIFWritableImageMetadata.getStringAttribute(node, "text", "", false, null);
                this.text = this.fromISO8859(textString);
                continue;
            }
            if (name.equals("ApplicationExtensions")) {
                IIOMetadataNode applicationExtension = (IIOMetadataNode)node.getFirstChild();
                if (!applicationExtension.getNodeName().equals("ApplicationExtension")) {
                    GIFWritableImageMetadata.fatal(node, "Only a ApplicationExtension may be a child of a ApplicationExtensions!");
                }
                String applicationIDString = GIFWritableImageMetadata.getStringAttribute(applicationExtension, "applicationID", null, true, null);
                String authenticationCodeString = GIFWritableImageMetadata.getStringAttribute(applicationExtension, "authenticationCode", null, true, null);
                Object applicationExtensionData = applicationExtension.getUserObject();
                if (applicationExtensionData == null || !(applicationExtensionData instanceof byte[])) {
                    GIFWritableImageMetadata.fatal(applicationExtension, "Bad user object in ApplicationExtension!");
                }
                if (this.applicationIDs == null) {
                    this.applicationIDs = new ArrayList();
                    this.authenticationCodes = new ArrayList();
                    this.applicationData = new ArrayList();
                }
                this.applicationIDs.add(this.fromISO8859(applicationIDString));
                this.authenticationCodes.add(this.fromISO8859(authenticationCodeString));
                this.applicationData.add(applicationExtensionData);
                continue;
            }
            if (name.equals("CommentExtensions")) {
                Node commentExtension = node.getFirstChild();
                if (commentExtension == null) continue;
                while (commentExtension != null) {
                    if (!commentExtension.getNodeName().equals("CommentExtension")) {
                        GIFWritableImageMetadata.fatal(node, "Only a CommentExtension may be a child of a CommentExtensions!");
                    }
                    if (this.comments == null) {
                        this.comments = new ArrayList();
                    }
                    String comment = GIFWritableImageMetadata.getStringAttribute(commentExtension, "value", null, true, null);
                    this.comments.add(this.fromISO8859(comment));
                    commentExtension = commentExtension.getNextSibling();
                }
                continue;
            }
            GIFWritableImageMetadata.fatal(node, "Unknown child of root node!");
        }
    }

    protected void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            GIFWritableImageMetadata.fatal(node, "Root must be javax_imageio_1.0");
        }
        block0: for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String childName;
            Node childNode;
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                for (childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    childName = childNode.getNodeName();
                    if (!childName.equals("Palette")) continue;
                    this.localColorTable = this.getColorTable(childNode, "PaletteEntry", false, -1);
                    continue block0;
                }
                continue;
            }
            if (name.equals("Compression")) {
                for (childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    childName = childNode.getNodeName();
                    if (!childName.equals("NumProgressiveScans")) continue;
                    int numProgressiveScans = GIFWritableImageMetadata.getIntAttribute(childNode, "value", 4, false, true, 1, Integer.MAX_VALUE);
                    if (numProgressiveScans <= 1) continue block0;
                    this.interlaceFlag = true;
                    continue block0;
                }
                continue;
            }
            if (name.equals("Dimension")) {
                for (childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    childName = childNode.getNodeName();
                    if (childName.equals("HorizontalPixelOffset")) {
                        this.imageLeftPosition = GIFWritableImageMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 65535);
                        continue;
                    }
                    if (!childName.equals("VerticalPixelOffset")) continue;
                    this.imageTopPosition = GIFWritableImageMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 65535);
                }
                continue;
            }
            if (name.equals("Text")) {
                for (childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    childName = childNode.getNodeName();
                    if (!childName.equals("TextEntry") || !GIFWritableImageMetadata.getAttribute(childNode, "compression", "none", false).equals("none") || !Charset.isSupported(GIFWritableImageMetadata.getAttribute(childNode, "encoding", "ISO-8859-1", false))) continue;
                    String value = GIFWritableImageMetadata.getAttribute(childNode, "value");
                    byte[] comment = this.fromISO8859(value);
                    if (this.comments == null) {
                        this.comments = new ArrayList();
                    }
                    this.comments.add(comment);
                }
                continue;
            }
            if (!name.equals("Transparency")) continue;
            for (childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                childName = childNode.getNodeName();
                if (!childName.equals("TransparentIndex")) continue;
                this.transparentColorIndex = GIFWritableImageMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 255);
                this.transparentColorFlag = true;
                continue block0;
            }
        }
    }

    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(formatName, root);
    }
}

