/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityActions;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletStartupSecuritySettings;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteAppletAction;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionStorage;
import net.sourceforge.jnlp.security.appletextendedsecurity.UrlRegEx;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.AppTrustWarningPanel;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UnsignedAppletTrustConfirmation {
    private static final AppletStartupSecuritySettings securitySettings = AppletStartupSecuritySettings.getInstance();

    private static boolean unsignedConfirmationIsRequired() {
        return AppletSecurityLevel.ALLOW_UNSIGNED != securitySettings.getSecurityLevel();
    }

    private static boolean unsignedAppletsAreForbidden() {
        return AppletSecurityLevel.DENY_UNSIGNED == securitySettings.getSecurityLevel() || AppletSecurityLevel.DENY_ALL == securitySettings.getSecurityLevel();
    }

    public static UnsignedAppletActionEntry getStoredEntry(JNLPFile file, int id) {
        ExecuteAppletAction userAction;
        UnsignedAppletActionStorage userActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        UnsignedAppletActionStorage globalActionStorage = securitySettings.getUnsignedAppletActionGlobalStorage();
        UnsignedAppletActionEntry globalEntry = UnsignedAppletTrustConfirmation.getMatchingItem(globalActionStorage, file, id);
        UnsignedAppletActionEntry userEntry = UnsignedAppletTrustConfirmation.getMatchingItem(userActionStorage, file, id);
        ExecuteAppletAction globalAction = globalEntry == null ? null : globalEntry.getAppletSecurityActions().getAction(id);
        ExecuteAppletAction executeAppletAction = userAction = userEntry == null ? null : userEntry.getAppletSecurityActions().getAction(id);
        if (userAction == ExecuteAppletAction.ALWAYS || userAction == ExecuteAppletAction.NEVER) {
            return userEntry;
        }
        if (globalAction == ExecuteAppletAction.ALWAYS || globalAction == ExecuteAppletAction.NEVER) {
            return globalEntry;
        }
        return userEntry;
    }

    public static ExecuteAppletAction getStoredAction(JNLPFile file, int id) {
        UnsignedAppletActionEntry x = UnsignedAppletTrustConfirmation.getStoredEntry(file, id);
        if (x != null) {
            return x.getAppletSecurityActions().getAction(id);
        }
        return null;
    }

    private static UnsignedAppletActionEntry getMatchingItem(UnsignedAppletActionStorage actionStorage, JNLPFile file, int id) {
        return actionStorage.getMatchingItem(UrlUtils.normalizeUrlAndStripParams(file.getSourceLocation(), true).toString(), UrlUtils.normalizeUrlAndStripParams(file.getCodeBase(), true).toString(), UnsignedAppletTrustConfirmation.toRelativePaths(UnsignedAppletTrustConfirmation.getJars(file), file.getCodeBase().toString()), id);
    }

    static List<String> toRelativePaths(List<String> paths, String rootPath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String path : paths) {
            if (path.startsWith(rootPath)) {
                fileNames.add(path.substring(rootPath.length()));
                continue;
            }
            fileNames.add(path);
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAppletAction(JNLPFile file, ExecuteAppletAction behaviour, boolean rememberForCodeBase, int id) {
        UnsignedAppletActionStorage userActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        userActionStorage.lock();
        try {
            UnsignedAppletActionEntry oldEntry = UnsignedAppletTrustConfirmation.getMatchingItem(userActionStorage, file, id);
            URL codebase = UrlUtils.normalizeUrlAndStripParams(file.getCodeBase(), true);
            URL documentbase = UrlUtils.normalizeUrlAndStripParams(file.getSourceLocation(), true);
            UrlRegEx codebaseRegex = UrlRegEx.quote(codebase.toExternalForm());
            UrlRegEx documentbaseRegex = UrlRegEx.quoteAndStar(UnsignedAppletTrustConfirmation.stripFile(documentbase));
            List<String> archiveMatches = null;
            if (!rememberForCodeBase) {
                documentbaseRegex = UrlRegEx.quote(documentbase.toExternalForm());
                archiveMatches = UnsignedAppletTrustConfirmation.toRelativePaths(UnsignedAppletTrustConfirmation.getJars(file), file.getCodeBase().toString());
            }
            if (oldEntry != null) {
                oldEntry.getAppletSecurityActions().setAction(id, behaviour);
                oldEntry.setTimeStamp(new Date());
                oldEntry.setDocumentBase(documentbaseRegex);
                oldEntry.setCodeBase(codebaseRegex);
                oldEntry.setArchives(archiveMatches);
                userActionStorage.update(oldEntry);
                return;
            }
            UnsignedAppletActionEntry entry = new UnsignedAppletActionEntry(AppletSecurityActions.fromAction(id, behaviour), new Date(), documentbaseRegex, codebaseRegex, archiveMatches);
            userActionStorage.add(entry);
        }
        finally {
            userActionStorage.unlock();
        }
    }

    private static List<String> getJars(JNLPFile file) {
        if (file instanceof PluginBridge) {
            return ((PluginBridge)file).getArchiveJars();
        }
        List<JARDesc> jars = Arrays.asList(file.getResources().getJARs());
        ArrayList<String> result = new ArrayList<String>();
        for (JARDesc jar : jars) {
            result.add(jar.getLocation().toString());
        }
        return result;
    }

    public static void checkUnsignedWithUserIfRequired(JNLPFile file) throws LaunchException {
        boolean appletOK;
        if (UnsignedAppletTrustConfirmation.unsignedAppletsAreForbidden() || JNLPRuntime.isTrustNone()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Not running unsigned applet at " + file.getCodeBase() + " because unsigned applets are disallowed by security policy.");
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletPolicyDenied"));
        }
        if (!UnsignedAppletTrustConfirmation.unsignedConfirmationIsRequired() || JNLPRuntime.isTrustAll()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Running unsigned applet at " + file.getCodeBase() + " does not require confirmation according to security policy.");
            return;
        }
        ExecuteAppletAction storedAction = UnsignedAppletTrustConfirmation.getStoredAction(file, 0);
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Stored action for unsigned applet at " + file.getCodeBase() + " was " + (Object)((Object)storedAction));
        if (storedAction == ExecuteAppletAction.ALWAYS) {
            appletOK = true;
        } else if (storedAction == ExecuteAppletAction.NEVER) {
            appletOK = false;
        } else {
            AppTrustWarningPanel.AppSigningWarningAction warningResponse = SecurityDialogs.showUnsignedWarningDialog(file);
            ExecuteAppletAction executeAction = warningResponse.getAction();
            boolean bl = appletOK = executeAction == ExecuteAppletAction.YES || executeAction == ExecuteAppletAction.ALWAYS;
            if (executeAction != null) {
                UnsignedAppletTrustConfirmation.updateAppletAction(file, executeAction, warningResponse.rememberForCodeBase(), 0);
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Decided action for unsigned applet at " + file.getCodeBase() + " was " + (Object)((Object)executeAction));
        }
        if (!appletOK) {
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletUserDenied"));
        }
    }

    public static void checkPartiallySignedWithUserIfRequired(JNLPClassLoader.SecurityDelegate securityDelegate, JNLPFile file, CertVerifier certVerifier) throws LaunchException {
        boolean appletOK;
        if (JNLPRuntime.isTrustNone()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Running partially signed applet at " + file.getCodeBase() + " with only Sandbox permissions due to -Xtrustnone flag");
            securityDelegate.setRunInSandbox();
            return;
        }
        if (JNLPRuntime.isTrustAll()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Running partially signed applet at " + file.getCodeBase() + " due to -Xtrustall flag");
            return;
        }
        if (!UnsignedAppletTrustConfirmation.unsignedConfirmationIsRequired()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Running partially signed applet at " + file.getCodeBase() + " does not require confirmation according to security policy.");
            return;
        }
        ExecuteAppletAction storedAction = UnsignedAppletTrustConfirmation.getStoredAction(file, 0);
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Stored action for partially signed applet at " + file.getCodeBase() + " was " + (Object)((Object)storedAction));
        if (storedAction == ExecuteAppletAction.ALWAYS) {
            appletOK = true;
        } else if (storedAction == ExecuteAppletAction.NEVER) {
            appletOK = false;
        } else {
            AppTrustWarningPanel.AppSigningWarningAction warningResponse = SecurityDialogs.showPartiallySignedWarningDialog(file, certVerifier, securityDelegate);
            ExecuteAppletAction executeAction = warningResponse.getAction();
            if (executeAction == ExecuteAppletAction.SANDBOX) {
                securityDelegate.setRunInSandbox();
            }
            boolean bl = appletOK = executeAction == ExecuteAppletAction.YES || executeAction == ExecuteAppletAction.ALWAYS || executeAction == ExecuteAppletAction.SANDBOX;
            if (executeAction != null) {
                UnsignedAppletTrustConfirmation.updateAppletAction(file, executeAction, warningResponse.rememberForCodeBase(), 0);
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Decided action for unsigned applet at " + file.getCodeBase() + " was " + (Object)((Object)executeAction));
        }
        if (!appletOK) {
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LPartiallySignedApplet"), Translator.R("LPartiallySignedAppletUserDenied"));
        }
    }

    static String stripFile(URL documentbase) {
        return UnsignedAppletTrustConfirmation.ensureSlashTail(UnsignedAppletTrustConfirmation.stripFileImp(documentbase));
    }

    private static String stripFileImp(URL documentbase) {
        try {
            String normalized = UrlUtils.normalizeUrlAndStripParams(documentbase).toExternalForm().trim();
            if (normalized.endsWith("/") || normalized.endsWith("\\")) {
                return normalized;
            }
            URL middleway = new URL(normalized);
            String file = middleway.getFile();
            int i = Math.max(file.lastIndexOf(47), file.lastIndexOf(92));
            if (i < 0) {
                return normalized;
            }
            String parent = file.substring(0, i + 1);
            String stripped = normalized.replace(file, parent);
            return stripped;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return documentbase.toExternalForm();
        }
    }

    private static String ensureSlashTail(String s) {
        if (s.endsWith("/")) {
            return s;
        }
        if (s.endsWith("\\")) {
            return s;
        }
        if (s.contains("/")) {
            return s + "/";
        }
        if (s.contains("\\")) {
            return s + "\\";
        }
        return s + "/";
    }
}

