/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.image.BufferedImage;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class LCMSImageLayout {
    public static final int SWAPFIRST = 16384;
    public static final int DOSWAP = 1024;
    public static final int PT_RGB_8 = LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_8 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_16 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(2);
    public static final int PT_RGBA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ARGB_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x4000;
    public static final int PT_BGR_8 = 0x400 | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ABGR_8 = 0x400 | LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_BGRA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x400 | 0x4000;
    public static final int DT_BYTE = 0;
    public static final int DT_SHORT = 1;
    public static final int DT_INT = 2;
    public static final int DT_DOUBLE = 3;
    boolean isIntPacked = false;
    int pixelType;
    int dataType;
    int width;
    int height;
    int nextRowOffset;
    private int nextPixelOffset;
    int offset;
    Object dataArray;
    private int dataArrayLength;

    public static int BYTES_SH(int x) {
        return x;
    }

    public static int EXTRA_SH(int x) {
        return x << 7;
    }

    public static int CHANNELS_SH(int x) {
        return x << 3;
    }

    private LCMSImageLayout(int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this.pixelType = pixelType;
        this.width = np;
        this.height = 1;
        this.nextPixelOffset = pixelSize;
        this.nextRowOffset = LCMSImageLayout.safeMult(pixelSize, np);
        this.offset = 0;
    }

    private LCMSImageLayout(int width, int height, int pixelType, int pixelSize) throws ImageLayoutException {
        this.pixelType = pixelType;
        this.width = width;
        this.height = height;
        this.nextPixelOffset = pixelSize;
        this.nextRowOffset = LCMSImageLayout.safeMult(pixelSize, width);
        this.offset = 0;
    }

    public LCMSImageLayout(byte[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 0;
        this.dataArray = data;
        this.dataArrayLength = data.length;
        this.verify();
    }

    public LCMSImageLayout(short[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 1;
        this.dataArray = data;
        this.dataArrayLength = 2 * data.length;
        this.verify();
    }

    public LCMSImageLayout(int[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 2;
        this.dataArray = data;
        this.dataArrayLength = 4 * data.length;
        this.verify();
    }

    public LCMSImageLayout(double[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 3;
        this.dataArray = data;
        this.dataArrayLength = 8 * data.length;
        this.verify();
    }

    public LCMSImageLayout(BufferedImage image) throws ImageLayoutException {
        switch (image.getType()) {
            case 1: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 2: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 4: {
                this.pixelType = PT_ABGR_8;
                this.isIntPacked = true;
                break;
            }
            case 5: {
                this.pixelType = PT_BGR_8;
                break;
            }
            case 6: {
                this.pixelType = PT_ABGR_8;
                break;
            }
            case 10: {
                this.pixelType = PT_GRAY_8;
                break;
            }
            case 11: {
                this.pixelType = PT_GRAY_16;
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 4: {
                IntegerComponentRaster intRaster = (IntegerComponentRaster)image.getRaster();
                this.nextRowOffset = LCMSImageLayout.safeMult(4, intRaster.getScanlineStride());
                this.nextPixelOffset = LCMSImageLayout.safeMult(4, intRaster.getPixelStride());
                this.offset = LCMSImageLayout.safeMult(4, intRaster.getDataOffset(0));
                this.dataArray = intRaster.getDataStorage();
                this.dataArrayLength = 4 * intRaster.getDataStorage().length;
                this.dataType = 2;
                break;
            }
            case 5: 
            case 6: {
                ByteComponentRaster byteRaster = (ByteComponentRaster)image.getRaster();
                this.nextRowOffset = byteRaster.getScanlineStride();
                this.nextPixelOffset = byteRaster.getPixelStride();
                int firstBand = image.getSampleModel().getNumBands() - 1;
                this.offset = byteRaster.getDataOffset(firstBand);
                this.dataArray = byteRaster.getDataStorage();
                this.dataArrayLength = byteRaster.getDataStorage().length;
                this.dataType = 0;
                break;
            }
            case 10: {
                ByteComponentRaster byteRaster = (ByteComponentRaster)image.getRaster();
                this.nextRowOffset = byteRaster.getScanlineStride();
                this.nextPixelOffset = byteRaster.getPixelStride();
                this.offset = byteRaster.getDataOffset(0);
                this.dataArray = byteRaster.getDataStorage();
                this.dataArrayLength = byteRaster.getDataStorage().length;
                this.dataType = 0;
                break;
            }
            case 11: {
                ShortComponentRaster shortRaster = (ShortComponentRaster)image.getRaster();
                this.nextRowOffset = LCMSImageLayout.safeMult(2, shortRaster.getScanlineStride());
                this.nextPixelOffset = LCMSImageLayout.safeMult(2, shortRaster.getPixelStride());
                this.offset = LCMSImageLayout.safeMult(2, shortRaster.getDataOffset(0));
                this.dataArray = shortRaster.getDataStorage();
                this.dataArrayLength = 2 * shortRaster.getDataStorage().length;
                this.dataType = 1;
            }
        }
        this.verify();
    }

    public static boolean isSupported(BufferedImage image) {
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private void verify() throws ImageLayoutException {
        if (this.offset < 0 || this.offset >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
        if (this.nextPixelOffset != LCMSImageLayout.getBytesPerPixel(this.pixelType)) {
            throw new ImageLayoutException("Invalid image layout");
        }
        int lastScanOffset = LCMSImageLayout.safeMult(this.nextRowOffset, this.height - 1);
        int lastPixelOffset = LCMSImageLayout.safeMult(this.nextPixelOffset, this.width - 1);
        int off = LCMSImageLayout.safeAdd(this.offset, lastPixelOffset = LCMSImageLayout.safeAdd(lastPixelOffset, lastScanOffset));
        if (off < 0 || off >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
    }

    static int safeAdd(int a, int b) throws ImageLayoutException {
        long res = a;
        if ((res += (long)b) < Integer.MIN_VALUE || res > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)res;
    }

    static int safeMult(int a, int b) throws ImageLayoutException {
        long res = a;
        if ((res *= (long)b) < Integer.MIN_VALUE || res > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)res;
    }

    private static int getBytesPerPixel(int pixelType) {
        int bytesPerSample = 7 & pixelType;
        int colorSamplesPerPixel = 0xF & pixelType >> 3;
        int extraSamplesPerPixel = 7 & pixelType >> 7;
        return bytesPerSample * (colorSamplesPerPixel + extraSamplesPerPixel);
    }

    public static class ImageLayoutException
    extends Exception {
        public ImageLayoutException(String message) {
            super(message);
        }
    }
}

