/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TypedAtom;
import org.scilab.forge.jlatexmath.VerticalBox;

public class BigOperatorAtom
extends Atom {
    private Atom under = null;
    private Atom over = null;
    protected Atom base = null;
    private boolean limitsSet = false;
    private boolean limits = false;

    public BigOperatorAtom(Atom atom, Atom atom2, Atom atom3) {
        this.base = atom;
        this.under = atom2;
        this.over = atom3;
        this.type = 1;
    }

    public BigOperatorAtom(Atom atom, Atom atom2, Atom atom3, boolean bl) {
        this(atom, atom2, atom3);
        this.limits = bl;
        this.limitsSet = true;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        float f;
        float f2;
        Box box;
        Object object;
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        RowAtom rowAtom = null;
        Atom atom = this.base;
        if (this.base instanceof TypedAtom) {
            object = ((TypedAtom)this.base).getBase();
            if (object instanceof RowAtom && ((RowAtom)object).lookAtLastAtom && this.base.type_limits != 2) {
                this.base = ((RowAtom)object).getLastAtom();
                rowAtom = (RowAtom)object;
            } else {
                this.base = object;
            }
        }
        if (this.limitsSet && !this.limits || !this.limitsSet && n >= 2 || this.base.type_limits == 1 || this.base.type_limits == 0 && n >= 2) {
            if (rowAtom != null) {
                rowAtom.add(new ScriptsAtom(this.base, this.under, this.over));
                object = rowAtom.createBox(teXEnvironment);
                rowAtom.getLastAtom();
                rowAtom.add(this.base);
                this.base = atom;
                return object;
            }
            return new ScriptsAtom(this.base, this.under, this.over).createBox(teXEnvironment);
        }
        if (this.base instanceof SymbolAtom && this.base.type == 1) {
            object = teXFont.getChar(((SymbolAtom)this.base).getName(), n);
            box = this.base.createBox(teXEnvironment);
            f2 = ((Char)object).getItalic();
        } else {
            f2 = 0.0f;
            box = new HorizontalBox(this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(teXEnvironment));
        }
        object = null;
        Box box2 = null;
        if (this.over != null) {
            object = this.over.createBox(teXEnvironment.supStyle());
        }
        if (this.under != null) {
            box2 = this.under.createBox(teXEnvironment.subStyle());
        }
        float f3 = Math.max(Math.max(object == null ? 0.0f : ((Box)object).getWidth(), box.getWidth()), box2 == null ? 0.0f : box2.getWidth());
        object = BigOperatorAtom.changeWidth((Box)object, f3);
        box = BigOperatorAtom.changeWidth(box, f3);
        box2 = BigOperatorAtom.changeWidth(box2, f3);
        VerticalBox verticalBox = new VerticalBox();
        float f4 = teXFont.getBigOpSpacing5(n);
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.over != null) {
            verticalBox.add(new StrutBox(0.0f, f4, 0.0f, 0.0f));
            ((Box)object).setShift(f2 / 2.0f);
            verticalBox.add((Box)object);
            f5 = Math.max(teXFont.getBigOpSpacing1(n), teXFont.getBigOpSpacing3(n) - ((Box)object).getDepth());
            verticalBox.add(new StrutBox(0.0f, f5, 0.0f, 0.0f));
            f6 = verticalBox.getHeight() + verticalBox.getDepth();
        }
        verticalBox.add(box);
        if (this.under != null) {
            f = Math.max(teXFont.getBigOpSpacing2(n), teXFont.getBigOpSpacing4(n) - box2.getHeight());
            verticalBox.add(new StrutBox(0.0f, f, 0.0f, 0.0f));
            box2.setShift(-f2 / 2.0f);
            verticalBox.add(box2);
            verticalBox.add(new StrutBox(0.0f, f4, 0.0f, 0.0f));
        }
        f = box.getHeight();
        float f7 = verticalBox.getHeight() + verticalBox.getDepth();
        if (object != null) {
            f += f4 + f5 + ((Box)object).getHeight() + ((Box)object).getDepth();
        }
        verticalBox.setHeight(f);
        verticalBox.setDepth(f7 - f);
        if (rowAtom != null) {
            HorizontalBox horizontalBox = new HorizontalBox(rowAtom.createBox(teXEnvironment));
            rowAtom.add(this.base);
            horizontalBox.add(verticalBox);
            this.base = atom;
            return horizontalBox;
        }
        return verticalBox;
    }

    private static Box changeWidth(Box box, float f) {
        if (box != null && Math.abs(f - box.getWidth()) > 1.0E-7f) {
            return new HorizontalBox(box, f, 2);
        }
        return box;
    }
}

