/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import java.awt.Color;

public class AwtColorTools {
    public static Color getBorderColor(PDWidgetAnnotation pDWidgetAnnotation) {
        return AwtColorTools.toColor(PDAnnotationTools.getBorderColor((PDWidgetAnnotation)pDWidgetAnnotation));
    }

    public static float[] getBorderColorRGB(PDWidgetAnnotation pDWidgetAnnotation) {
        return AwtColorTools.toRGB(PDAnnotationTools.getBorderColor((PDWidgetAnnotation)pDWidgetAnnotation));
    }

    public static Color getFillColor(PDWidgetAnnotation pDWidgetAnnotation) {
        return AwtColorTools.toColor(PDAnnotationTools.getFillColor((PDWidgetAnnotation)pDWidgetAnnotation));
    }

    public static float[] getFillColorRGB(PDWidgetAnnotation pDWidgetAnnotation) {
        return AwtColorTools.toRGB(PDAnnotationTools.getFillColor((PDWidgetAnnotation)pDWidgetAnnotation));
    }

    public static Color toColor(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length == 1) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            float[] fArray2 = awtColorSpace.getRGB(fArray);
            return new Color(fArray2[0], fArray2[1], fArray2[2]);
        }
        if (fArray.length == 4) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            float[] fArray3 = awtColorSpace.getRGB(fArray);
            return new Color(fArray3[0], fArray3[1], fArray3[2]);
        }
        if (fArray.length == 3) {
            return new Color(fArray[0], fArray[1], fArray[2]);
        }
        return null;
    }

    public static Color toColor(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 1) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            float[] fArray = awtColorSpace.getRGB(new float[]{(float)nArray[0] / 255.0f, (float)nArray[1] / 255.0f, (float)nArray[2] / 255.0f});
            return new Color(fArray[0], fArray[1], fArray[2]);
        }
        if (nArray.length == 4) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            float[] fArray = awtColorSpace.getRGB(new float[]{(float)nArray[0] / 255.0f, (float)nArray[1] / 255.0f, (float)nArray[2] / 255.0f});
            return new Color(fArray[0], fArray[1], fArray[2]);
        }
        if (nArray.length == 3) {
            return new Color(nArray[0], nArray[1], nArray[2]);
        }
        return null;
    }

    public static float[] toFloatArray(Color color) {
        if (color == null) {
            return null;
        }
        return color.getRGBColorComponents(null);
    }

    public static int[] toIntArray(Color color) {
        if (color == null) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static float[] toRGB(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length == 1) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            return awtColorSpace.getRGB(fArray);
        }
        if (fArray.length == 4) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            return awtColorSpace.getRGB(fArray);
        }
        if (fArray.length == 3) {
            return fArray;
        }
        return null;
    }

    public static int[] toRGB(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 1) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceGray);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            float[] fArray = awtColorSpace.getRGB(new float[]{(float)nArray[0] / 255.0f, (float)nArray[1] / 255.0f, (float)nArray[2] / 255.0f});
            return new int[]{(int)((double)(fArray[0] * 255.0f) + 0.5), (int)((double)(fArray[1] * 255.0f) + 0.5), (int)((double)(fArray[2] * 255.0f) + 0.5)};
        }
        if (nArray.length == 4) {
            PDColorSpace pDColorSpace = PDColorSpace.getSingleton((COSName)PDColorSpace.CN_CS_DeviceCMYK);
            AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
            float[] fArray = awtColorSpace.getRGB(new float[]{(float)nArray[0] / 255.0f, (float)nArray[1] / 255.0f, (float)nArray[2] / 255.0f});
            return new int[]{(int)((double)(fArray[0] * 255.0f) + 0.5), (int)((double)(fArray[1] * 255.0f) + 0.5), (int)((double)(fArray[2] * 255.0f) + 0.5)};
        }
        if (nArray.length == 3) {
            return nArray;
        }
        return null;
    }
}

