/*
 * This declarations of the PIC16F707 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-09-15 14:38:39 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F707_H__
#define __PIC16F707_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTB_ADDR              0x0006
#define PORTC_ADDR              0x0007
#define PORTD_ADDR              0x0008
#define PORTE_ADDR              0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define PIR2_ADDR               0x000D
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define TMR2_ADDR               0x0011
#define T2CON_ADDR              0x0012
#define SSPBUF_ADDR             0x0013
#define SSPCON_ADDR             0x0014
#define CCPR1_ADDR              0x0015
#define CCPR1L_ADDR             0x0015
#define CCPR1H_ADDR             0x0016
#define CCP1CON_ADDR            0x0017
#define RCSTA_ADDR              0x0018
#define TXREG_ADDR              0x0019
#define RCREG_ADDR              0x001A
#define CCPR2_ADDR              0x001B
#define CCPR2L_ADDR             0x001B
#define CCPR2H_ADDR             0x001C
#define CCP2CON_ADDR            0x001D
#define ADRES_ADDR              0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define TRISC_ADDR              0x0087
#define TRISD_ADDR              0x0088
#define TRISE_ADDR              0x0089
#define PIE1_ADDR               0x008C
#define PIE2_ADDR               0x008D
#define PCON_ADDR               0x008E
#define T1GCON_ADDR             0x008F
#define OSCCON_ADDR             0x0090
#define OSCTUNE_ADDR            0x0091
#define PR2_ADDR                0x0092
#define SSPADD_ADDR             0x0093
#define SSPMSK_ADDR             0x0093
#define SSPSTAT_ADDR            0x0094
#define WPUB_ADDR               0x0095
#define IOCB_ADDR               0x0096
#define T3CON_ADDR              0x0097
#define TXSTA_ADDR              0x0098
#define SPBRG_ADDR              0x0099
#define TMR3_ADDR               0x009A
#define TMR3L_ADDR              0x009A
#define TMR3H_ADDR              0x009B
#define APFCON_ADDR             0x009C
#define FVRCON_ADDR             0x009D
#define T3GCON_ADDR             0x009E
#define ADCON1_ADDR             0x009F
#define TACON_ADDR              0x0105
#define CPSBCON0_ADDR           0x0106
#define CPSBCON1_ADDR           0x0107
#define CPSACON0_ADDR           0x0108
#define CPSACON1_ADDR           0x0109
#define PMDATL_ADDR             0x010C
#define PMADRL_ADDR             0x010D
#define PMDATH_ADDR             0x010E
#define PMADRH_ADDR             0x010F
#define TMRA_ADDR               0x0110
#define TBCON_ADDR              0x0111
#define TMRB_ADDR               0x0112
#define DACCON0_ADDR            0x0113
#define DACCON1_ADDR            0x0114
#define ANSELA_ADDR             0x0185
#define ANSELB_ADDR             0x0186
#define ANSELC_ADDR             0x0187
#define ANSELD_ADDR             0x0188
#define ANSELE_ADDR             0x0189
#define PMCON1_ADDR             0x018C

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned CPSA3              : 1;
    unsigned AN4                : 1;
    unsigned OSC2               : 1;
    unsigned OSC1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CPSA0              : 1;
    unsigned CPSA1              : 1;
    unsigned CPSA2              : 1;
    unsigned T0CKI              : 1;
    unsigned CPSA4              : 1;
    unsigned CPSB1              : 1;
    unsigned CPSB0              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACOUT             : 1;
    unsigned                    : 1;
    unsigned TACKI              : 1;
    unsigned                    : 1;
    unsigned CLKOUT             : 1;
    unsigned CLKIN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CPSA               : 5;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _AN0                    0x01
#define _RA1                    0x02
#define _AN1                    0x02
#define _CPSA0                  0x02
#define _RA2                    0x04
#define _AN2                    0x04
#define _CPSA1                  0x04
#define _DACOUT                 0x04
#define _RA3                    0x08
#define _AN3                    0x08
#define _CPSA2                  0x08
#define _RA4                    0x10
#define _CPSA3                  0x10
#define _T0CKI                  0x10
#define _TACKI                  0x10
#define _RA5                    0x20
#define _AN4                    0x20
#define _CPSA4                  0x20
#define _RA6                    0x40
#define _OSC2                   0x40
#define _CPSB1                  0x40
#define _CLKOUT                 0x40
#define _RA7                    0x80
#define _OSC1                   0x80
#define _CPSB0                  0x80
#define _CLKIN                  0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned AN12               : 1;
    unsigned AN10               : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned AN11               : 1;
    unsigned AN13               : 1;
    unsigned CPSB14             : 1;
    unsigned CPSB15             : 1;
    };

  struct
    {
    unsigned CPSB8              : 1;
    unsigned CPSB9              : 1;
    unsigned CPSB10             : 1;
    unsigned CPSB11             : 1;
    unsigned CPSB12             : 1;
    unsigned CPSB13             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2               : 1;
    unsigned                    : 1;
    unsigned T1G                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3CKI              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _AN12                   0x01
#define _CPSB8                  0x01
#define _RB1                    0x02
#define _AN10                   0x02
#define _CPSB9                  0x02
#define _RB2                    0x04
#define _AN8                    0x04
#define _CPSB10                 0x04
#define _RB3                    0x08
#define _AN9                    0x08
#define _CPSB11                 0x08
#define _CCP2                   0x08
#define _RB4                    0x10
#define _AN11                   0x10
#define _CPSB12                 0x10
#define _RB5                    0x20
#define _AN13                   0x20
#define _CPSB13                 0x20
#define _T1G                    0x20
#define _T3CKI                  0x20
#define _RB6                    0x40
#define _CPSB14                 0x40
#define _RB7                    0x80
#define _CPSB15                 0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned CPSB2              : 1;
    unsigned CPSB3              : 1;
    unsigned CPSB4              : 1;
    unsigned SCK                : 1;
    unsigned SDI                : 1;
    unsigned CPSA9              : 1;
    unsigned CPSA10             : 1;
    unsigned CPSA11             : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned TBCKI              : 1;
    unsigned SCL                : 1;
    unsigned SDA                : 1;
    unsigned SDO                : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T1CKI              : 1;
    unsigned CCP2               : 1;
    unsigned CCP1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CK                 : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_CPSB2            0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T1CKI            0x01
#define _PORTC_RC1              0x02
#define _PORTC_CPSB3            0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_CCP2             0x02
#define _PORTC_RC2              0x04
#define _PORTC_CPSB4            0x04
#define _PORTC_TBCKI            0x04
#define _PORTC_CCP1             0x04
#define _PORTC_RC3              0x08
#define _PORTC_SCK              0x08
#define _PORTC_SCL              0x08
#define _PORTC_RC4              0x10
#define _PORTC_SDI              0x10
#define _PORTC_SDA              0x10
#define _PORTC_RC5              0x20
#define _PORTC_CPSA9            0x20
#define _PORTC_SDO              0x20
#define _PORTC_RC6              0x40
#define _PORTC_CPSA10           0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_RC7              0x80
#define _PORTC_CPSA11           0x80
#define _PORTC_RX               0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0008) __sfr PORTD;

typedef union
  {
  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };

  struct
    {
    unsigned CPSB5              : 1;
    unsigned CPSB6              : 1;
    unsigned CPSB7              : 1;
    unsigned CPSA8              : 1;
    unsigned CPSA12             : 1;
    unsigned CPSA13             : 1;
    unsigned CPSA14             : 1;
    unsigned CPSA15             : 1;
    };

  struct
    {
    unsigned T3G                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTDbits_t;

extern __at(0x0008) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _CPSB5                  0x01
#define _T3G                    0x01
#define _RD1                    0x02
#define _CPSB6                  0x02
#define _RD2                    0x04
#define _CPSB7                  0x04
#define _RD3                    0x08
#define _CPSA8                  0x08
#define _RD4                    0x10
#define _CPSA12                 0x10
#define _RD5                    0x20
#define _CPSA13                 0x20
#define _RD6                    0x40
#define _CPSA14                 0x40
#define _RD7                    0x80
#define _CPSA15                 0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0009) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AN5                : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned NOT_MCLR           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CPSA5              : 1;
    unsigned CPSA6              : 1;
    unsigned CPSA7              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 4;
    unsigned                    : 4;
    };
  } __PORTEbits_t;

extern __at(0x0009) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _AN5                    0x01
#define _CPSA5                  0x01
#define _RE1                    0x02
#define _AN6                    0x02
#define _CPSA6                  0x02
#define _RE2                    0x04
#define _AN7                    0x04
#define _CPSA7                  0x04
#define _RE3                    0x08
#define _NOT_MCLR               0x08

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSPIF                : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x000D) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TMRAIF               : 1;
  unsigned TMRBIF               : 1;
  unsigned TMR3IF               : 1;
  unsigned TMR3GIF              : 1;
  } __PIR2bits_t;

extern __at(0x000D) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMRAIF                 0x10
#define _TMRBIF                 0x20
#define _TMR3IF                 0x40
#define _TMR3GIF                0x80

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMRCS0             : 1;
    unsigned TMRCS1             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMRCS              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMRCS0                 0x40
#define _TMR1CS0                0x40
#define _TMRCS1                 0x80
#define _TMR1CS1                0x80

//==============================================================================

extern __at(0x0011) __sfr TMR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0012) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0012) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0013) __sfr SSPBUF;

//==============================================================================
//        SSPCON Bits

extern __at(0x0014) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0014) volatile __SSPCONbits_t SSPCONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================

extern __at(0x0015) __sfr CCPR1;
extern __at(0x0015) __sfr CCPR1L;
extern __at(0x0016) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0017) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0017) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0018) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x0018) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================

extern __at(0x0019) __sfr TXREG;
extern __at(0x001A) __sfr RCREG;
extern __at(0x001B) __sfr CCPR2;
extern __at(0x001B) __sfr CCPR2L;
extern __at(0x001C) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x001D) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x001D) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20

//==============================================================================

extern __at(0x001E) __sfr ADRES;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RBPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0088) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x0088) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0089) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned TRISE3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISE              : 4;
    unsigned                    : 4;
    };
  } __TRISEbits_t;

extern __at(0x0089) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSPIE                : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x008D) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TMRAIE               : 1;
  unsigned TMRBIE               : 1;
  unsigned TMR3IE               : 1;
  unsigned TMR3GIE              : 1;
  } __PIE2bits_t;

extern __at(0x008D) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMRAIE                 0x10
#define _TMRBIE                 0x20
#define _TMR3IE                 0x40
#define _TMR3GIE                0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x008F) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x008F) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0090) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ICSS               : 1;
    unsigned ICSL               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 2;
    unsigned                    : 2;
    };
  } __OSCCONbits_t;

extern __at(0x0090) volatile __OSCCONbits_t OSCCONbits;

#define _ICSS                   0x04
#define _ICSL                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20

//==============================================================================

extern __at(0x0091) __sfr OSCTUNE;
extern __at(0x0092) __sfr PR2;
extern __at(0x0093) __sfr SSPADD;
extern __at(0x0093) __sfr SSPMSK;

//==============================================================================
//        SSPSTAT Bits

extern __at(0x0094) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0094) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0095) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0095) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0096) __sfr IOCB;

typedef struct
  {
  unsigned IOCB0                : 1;
  unsigned IOCB1                : 1;
  unsigned IOCB2                : 1;
  unsigned IOCB3                : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0096) volatile __IOCBbits_t IOCBbits;

#define _IOCB0                  0x01
#define _IOCB1                  0x02
#define _IOCB2                  0x04
#define _IOCB3                  0x08
#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        T3CON Bits

extern __at(0x0097) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0097) volatile __T3CONbits_t T3CONbits;

#define _TMR3ON                 0x01
#define _T3SYNC                 0x04
#define _T3CKPS0                0x10
#define _T3CKPS1                0x20
#define _TMR3CS0                0x40
#define _TMR3CS1                0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0098) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned                      : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x0098) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0099) __sfr SPBRG;
extern __at(0x009A) __sfr TMR3;
extern __at(0x009A) __sfr TMR3L;
extern __at(0x009B) __sfr TMR3H;

//==============================================================================
//        APFCON Bits

extern __at(0x009C) __sfr APFCON;

typedef struct
  {
  unsigned CCP2SEL              : 1;
  unsigned SSSEL                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __APFCONbits_t;

extern __at(0x009C) volatile __APFCONbits_t APFCONbits;

#define _CCP2SEL                0x01
#define _SSSEL                  0x02

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x009D) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVREN              : 1;
    unsigned FVRRDY             : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x009D) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _FVREN                  0x40
#define _FVRRDY                 0x80

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x009E) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x009E) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_DONE         0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADREF0             : 1;
    unsigned ADREF1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADREF              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _ADREF0                 0x01
#define _ADREF1                 0x02
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40

//==============================================================================


//==============================================================================
//        TACON Bits

extern __at(0x0105) __sfr TACON;

typedef union
  {
  struct
    {
    unsigned TAPS0              : 1;
    unsigned TAPS1              : 1;
    unsigned TAPS2              : 1;
    unsigned TAPSA              : 1;
    unsigned TASE               : 1;
    unsigned TACS               : 1;
    unsigned                    : 1;
    unsigned TMRAON             : 1;
    };

  struct
    {
    unsigned TMRAPS0            : 1;
    unsigned TMRAPS1            : 1;
    unsigned TMRAPS2            : 1;
    unsigned TMRAPSA            : 1;
    unsigned TMRASE             : 1;
    unsigned TMRACS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TMRAPS             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned TAPS               : 3;
    unsigned                    : 5;
    };
  } __TACONbits_t;

extern __at(0x0105) volatile __TACONbits_t TACONbits;

#define _TAPS0                  0x01
#define _TMRAPS0                0x01
#define _TAPS1                  0x02
#define _TMRAPS1                0x02
#define _TAPS2                  0x04
#define _TMRAPS2                0x04
#define _TAPSA                  0x08
#define _TMRAPSA                0x08
#define _TASE                   0x10
#define _TMRASE                 0x10
#define _TACS                   0x20
#define _TMRACS                 0x20
#define _TMRAON                 0x80

//==============================================================================


//==============================================================================
//        CPSBCON0 Bits

extern __at(0x0106) __sfr CPSBCON0;

typedef union
  {
  struct
    {
    unsigned TBXCS              : 1;
    unsigned CPSBOUT            : 1;
    unsigned CPSBRNG0           : 1;
    unsigned CPSBRNG1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CPSBRM             : 1;
    unsigned CPSBON             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CPSBRNG            : 2;
    unsigned                    : 4;
    };
  } __CPSBCON0bits_t;

extern __at(0x0106) volatile __CPSBCON0bits_t CPSBCON0bits;

#define _TBXCS                  0x01
#define _CPSBOUT                0x02
#define _CPSBRNG0               0x04
#define _CPSBRNG1               0x08
#define _CPSBRM                 0x40
#define _CPSBON                 0x80

//==============================================================================


//==============================================================================
//        CPSBCON1 Bits

extern __at(0x0107) __sfr CPSBCON1;

typedef union
  {
  struct
    {
    unsigned CPSBCH0            : 1;
    unsigned CPSBCH1            : 1;
    unsigned CPSBCH2            : 1;
    unsigned CPSBCH3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CPSBCH             : 4;
    unsigned                    : 4;
    };
  } __CPSBCON1bits_t;

extern __at(0x0107) volatile __CPSBCON1bits_t CPSBCON1bits;

#define _CPSBCH0                0x01
#define _CPSBCH1                0x02
#define _CPSBCH2                0x04
#define _CPSBCH3                0x08

//==============================================================================


//==============================================================================
//        CPSACON0 Bits

extern __at(0x0108) __sfr CPSACON0;

typedef union
  {
  struct
    {
    unsigned TAXCS              : 1;
    unsigned CPSAOUT            : 1;
    unsigned CPSARNG0           : 1;
    unsigned CPSARNG1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CPSARM             : 1;
    unsigned CPSAON             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CPSARNG            : 2;
    unsigned                    : 4;
    };
  } __CPSACON0bits_t;

extern __at(0x0108) volatile __CPSACON0bits_t CPSACON0bits;

#define _TAXCS                  0x01
#define _CPSAOUT                0x02
#define _CPSARNG0               0x04
#define _CPSARNG1               0x08
#define _CPSARM                 0x40
#define _CPSAON                 0x80

//==============================================================================


//==============================================================================
//        CPSACON1 Bits

extern __at(0x0109) __sfr CPSACON1;

typedef union
  {
  struct
    {
    unsigned CPSACH0            : 1;
    unsigned CPSACH1            : 1;
    unsigned CPSACH2            : 1;
    unsigned CPSACH3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CPSACH             : 4;
    unsigned                    : 4;
    };
  } __CPSACON1bits_t;

extern __at(0x0109) volatile __CPSACON1bits_t CPSACON1bits;

#define _CPSACH0                0x01
#define _CPSACH1                0x02
#define _CPSACH2                0x04
#define _CPSACH3                0x08

//==============================================================================

extern __at(0x010C) __sfr PMDATL;
extern __at(0x010D) __sfr PMADRL;
extern __at(0x010E) __sfr PMDATH;
extern __at(0x010F) __sfr PMADRH;
extern __at(0x0110) __sfr TMRA;

//==============================================================================
//        TBCON Bits

extern __at(0x0111) __sfr TBCON;

typedef union
  {
  struct
    {
    unsigned TBPS0              : 1;
    unsigned TBPS1              : 1;
    unsigned TBPS2              : 1;
    unsigned TBPSA              : 1;
    unsigned TBSE               : 1;
    unsigned TBCS               : 1;
    unsigned                    : 1;
    unsigned TMRBON             : 1;
    };

  struct
    {
    unsigned TMRBPS0            : 1;
    unsigned TMRBPS1            : 1;
    unsigned TMRBPS2            : 1;
    unsigned TMRBPSA            : 1;
    unsigned TMRBSE             : 1;
    unsigned TMRBCS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TBPS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned TMRBPS             : 3;
    unsigned                    : 5;
    };
  } __TBCONbits_t;

extern __at(0x0111) volatile __TBCONbits_t TBCONbits;

#define _TBPS0                  0x01
#define _TMRBPS0                0x01
#define _TBPS1                  0x02
#define _TMRBPS1                0x02
#define _TBPS2                  0x04
#define _TMRBPS2                0x04
#define _TBPSA                  0x08
#define _TMRBPSA                0x08
#define _TBSE                   0x10
#define _TMRBSE                 0x10
#define _TBCS                   0x20
#define _TMRBCS                 0x20
#define _TMRBON                 0x80

//==============================================================================

extern __at(0x0112) __sfr TMRB;

//==============================================================================
//        DACCON0 Bits

extern __at(0x0113) __sfr DACCON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACLPS             : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __DACCON0bits_t;

extern __at(0x0113) volatile __DACCON0bits_t DACCON0bits;

#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE                  0x20
#define _DACLPS                 0x40
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        DACCON1 Bits

extern __at(0x0114) __sfr DACCON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DACCON1bits_t;

extern __at(0x0114) volatile __DACCON1bits_t DACCON1bits;

#define _DACR0                  0x01
#define _DACR1                  0x02
#define _DACR2                  0x04
#define _DACR3                  0x08
#define _DACR4                  0x10

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x0185) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned ANSA4                : 1;
  unsigned ANSA5                : 1;
  unsigned ANSA6                : 1;
  unsigned ANSA7                : 1;
  } __ANSELAbits_t;

extern __at(0x0185) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA4                  0x10
#define _ANSA5                  0x20
#define _ANSA6                  0x40
#define _ANSA7                  0x80

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x0186) __sfr ANSELB;

typedef struct
  {
  unsigned ANSB0                : 1;
  unsigned ANSB1                : 1;
  unsigned ANSB2                : 1;
  unsigned ANSB3                : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned ANSB6                : 1;
  unsigned ANSB7                : 1;
  } __ANSELBbits_t;

extern __at(0x0186) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40
#define _ANSB7                  0x80

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x0187) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x0187) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================


//==============================================================================
//        ANSELD Bits

extern __at(0x0188) __sfr ANSELD;

typedef struct
  {
  unsigned ANSD0                : 1;
  unsigned ANSD1                : 1;
  unsigned ANSD2                : 1;
  unsigned ANSD3                : 1;
  unsigned ANSD4                : 1;
  unsigned ANSD5                : 1;
  unsigned ANSD6                : 1;
  unsigned ANSD7                : 1;
  } __ANSELDbits_t;

extern __at(0x0188) volatile __ANSELDbits_t ANSELDbits;

#define _ANSD0                  0x01
#define _ANSD1                  0x02
#define _ANSD2                  0x04
#define _ANSD3                  0x08
#define _ANSD4                  0x10
#define _ANSD5                  0x20
#define _ANSD6                  0x40
#define _ANSD7                  0x80

//==============================================================================


//==============================================================================
//        ANSELE Bits

extern __at(0x0189) __sfr ANSELE;

typedef union
  {
  struct
    {
    unsigned ANSE0              : 1;
    unsigned ANSE1              : 1;
    unsigned ANSE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSE               : 3;
    unsigned                    : 5;
    };
  } __ANSELEbits_t;

extern __at(0x0189) volatile __ANSELEbits_t ANSELEbits;

#define _ANSE0                  0x01
#define _ANSE1                  0x02
#define _ANSE2                  0x04

//==============================================================================


//==============================================================================
//        PMCON1 Bits

extern __at(0x018C) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x018C) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01

//==============================================================================


//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG                 0x2007
#define _CONFIG2                0x2008

//----------------------------- CONFIG Options -------------------------------

#define _FOSC_LP_OSC            0x3FF8  // LP oscillator: Low-power crystal on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _LP_OSC                 0x3FF8  // LP oscillator: Low-power crystal on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _FOSC_XT_OSC            0x3FF9  // XT oscillator: Crystal/resonator on RA6/OSC2/CLKIN and RA7/OSC1/CLKIN.
#define _XT_OSC                 0x3FF9  // XT oscillator: Crystal/resonator on RA6/OSC2/CLKIN and RA7/OSC1/CLKIN.
#define _FOSC_HS_OSC            0x3FFA  // HS oscillator: High Speed crystal/resonator on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _HS_OSC                 0x3FFA  // HS oscillator: High Speed crystal/resonator on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _FOSC_EC_OSC            0x3FFB  // EC oscillator: I/O function on RA6/OSC2/CLKOUT pin, CLKIN on RA7/OSC1/CLKIN.
#define _EC_OSC                 0x3FFB  // EC oscillator: I/O function on RA6/OSC2/CLKOUT pin, CLKIN on RA7/OSC1/CLKIN.
#define _FOSC_INTOSCIO          0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN pins.
#define _INTOSCIO               0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN pins.
#define _FOSC_INTOSC            0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, I/O function  on RA7/OSC1/CLKIN.
#define _INTOSC                 0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, I/O function  on RA7/OSC1/CLKIN.
#define _FOSC_EXTRCIO           0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _EXTRCIO                0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _FOSC_EXTRC             0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _EXTRC                  0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _WDTE_OFF               0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDT_OFF                0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FEF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FDF  // RE3/MCLR pin function is digital input, MCLR internally tied to VDD.
#define _MCLRE_ON               0x3FFF  // RE3/MCLR pin function is MCLR.
#define _CP_ON                  0x3FBF  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x3CFF  // BOR disabled (Preconditioned State).
#define _BOREN_NSLEEP           0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BORV_25                0x3BFF  // Brown-out Reset Voltage (VBOR) set to 2.5 V nominal.
#define _BORV_19                0x3FFF  // Brown-out Reset Voltage (VBOR) set to 1.9 V nominal.
#define _PLLEN_OFF              0x2FFF  // INTOSC Frequency is 500 kHz.
#define _PLLEN_ON               0x3FFF  // INTOSC Frequency is 16 MHz (32x).

//----------------------------- CONFIG2 Options -------------------------------

#define _VCAPEN_RA0             0x3FCF  // VCAP functionality is enabled on RA0.
#define _VCAPEN_RA5             0x3FDF  // VCAP functionality is enabled on RA5.
#define _VCAPEN_RA6             0x3FEF  // VCAP functionality is enabled on RA6.
#define _VCAPEN_OFF             0x3FFF  // All VCAP pin functions are disabled.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5

#define ADREF0                  ADCON1bits.ADREF0               // bit 0
#define ADREF1                  ADCON1bits.ADREF1               // bit 1
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5
#define ANSA6                   ANSELAbits.ANSA6                // bit 6
#define ANSA7                   ANSELAbits.ANSA7                // bit 7

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6
#define ANSB7                   ANSELBbits.ANSB7                // bit 7

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC5                   ANSELCbits.ANSC5                // bit 5
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define ANSD0                   ANSELDbits.ANSD0                // bit 0
#define ANSD1                   ANSELDbits.ANSD1                // bit 1
#define ANSD2                   ANSELDbits.ANSD2                // bit 2
#define ANSD3                   ANSELDbits.ANSD3                // bit 3
#define ANSD4                   ANSELDbits.ANSD4                // bit 4
#define ANSD5                   ANSELDbits.ANSD5                // bit 5
#define ANSD6                   ANSELDbits.ANSD6                // bit 6
#define ANSD7                   ANSELDbits.ANSD7                // bit 7

#define ANSE0                   ANSELEbits.ANSE0                // bit 0
#define ANSE1                   ANSELEbits.ANSE1                // bit 1
#define ANSE2                   ANSELEbits.ANSE2                // bit 2

#define CCP2SEL                 APFCONbits.CCP2SEL              // bit 0
#define SSSEL                   APFCONbits.SSSEL                // bit 1

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5

#define TAXCS                   CPSACON0bits.TAXCS              // bit 0
#define CPSAOUT                 CPSACON0bits.CPSAOUT            // bit 1
#define CPSARNG0                CPSACON0bits.CPSARNG0           // bit 2
#define CPSARNG1                CPSACON0bits.CPSARNG1           // bit 3
#define CPSARM                  CPSACON0bits.CPSARM             // bit 6
#define CPSAON                  CPSACON0bits.CPSAON             // bit 7

#define CPSACH0                 CPSACON1bits.CPSACH0            // bit 0
#define CPSACH1                 CPSACON1bits.CPSACH1            // bit 1
#define CPSACH2                 CPSACON1bits.CPSACH2            // bit 2
#define CPSACH3                 CPSACON1bits.CPSACH3            // bit 3

#define TBXCS                   CPSBCON0bits.TBXCS              // bit 0
#define CPSBOUT                 CPSBCON0bits.CPSBOUT            // bit 1
#define CPSBRNG0                CPSBCON0bits.CPSBRNG0           // bit 2
#define CPSBRNG1                CPSBCON0bits.CPSBRNG1           // bit 3
#define CPSBRM                  CPSBCON0bits.CPSBRM             // bit 6
#define CPSBON                  CPSBCON0bits.CPSBON             // bit 7

#define CPSBCH0                 CPSBCON1bits.CPSBCH0            // bit 0
#define CPSBCH1                 CPSBCON1bits.CPSBCH1            // bit 1
#define CPSBCH2                 CPSBCON1bits.CPSBCH2            // bit 2
#define CPSBCH3                 CPSBCON1bits.CPSBCH3            // bit 3

#define DACPSS0                 DACCON0bits.DACPSS0             // bit 2
#define DACPSS1                 DACCON0bits.DACPSS1             // bit 3
#define DACOE                   DACCON0bits.DACOE               // bit 5
#define DACLPS                  DACCON0bits.DACLPS              // bit 6
#define DACEN                   DACCON0bits.DACEN               // bit 7

#define DACR0                   DACCON1bits.DACR0               // bit 0
#define DACR1                   DACCON1bits.DACR1               // bit 1
#define DACR2                   DACCON1bits.DACR2               // bit 2
#define DACR3                   DACCON1bits.DACR3               // bit 3
#define DACR4                   DACCON1bits.DACR4               // bit 4

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define FVREN                   FVRCONbits.FVREN                // bit 6
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 7

#define RBIF                    INTCONbits.RBIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define RBIE                    INTCONbits.RBIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCB0                   IOCBbits.IOCB0                  // bit 0
#define IOCB1                   IOCBbits.IOCB1                  // bit 1
#define IOCB2                   IOCBbits.IOCB2                  // bit 2
#define IOCB3                   IOCBbits.IOCB3                  // bit 3
#define IOCB4                   IOCBbits.IOCB4                  // bit 4
#define IOCB5                   IOCBbits.IOCB5                  // bit 5
#define IOCB6                   IOCBbits.IOCB6                  // bit 6
#define IOCB7                   IOCBbits.IOCB7                  // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RBPU                OPTION_REGbits.NOT_RBPU         // bit 7

#define ICSS                    OSCCONbits.ICSS                 // bit 2
#define ICSL                    OSCCONbits.ICSL                 // bit 3
#define IRCF0                   OSCCONbits.IRCF0                // bit 4
#define IRCF1                   OSCCONbits.IRCF1                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSPIE                   PIE1bits.SSPIE                  // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define TMRAIE                  PIE2bits.TMRAIE                 // bit 4
#define TMRBIE                  PIE2bits.TMRBIE                 // bit 5
#define TMR3IE                  PIE2bits.TMR3IE                 // bit 6
#define TMR3GIE                 PIE2bits.TMR3GIE                // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSPIF                   PIR1bits.SSPIF                  // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define TMRAIF                  PIR2bits.TMRAIF                 // bit 4
#define TMRBIF                  PIR2bits.TMRBIF                 // bit 5
#define TMR3IF                  PIR2bits.TMR3IF                 // bit 6
#define TMR3GIF                 PIR2bits.TMR3GIF                // bit 7

#define RD                      PMCON1bits.RD                   // bit 0

#define RA0                     PORTAbits.RA0                   // bit 0, shadows bit in PORTAbits
#define AN0                     PORTAbits.AN0                   // bit 0, shadows bit in PORTAbits
#define RA1                     PORTAbits.RA1                   // bit 1, shadows bit in PORTAbits
#define AN1                     PORTAbits.AN1                   // bit 1, shadows bit in PORTAbits
#define CPSA0                   PORTAbits.CPSA0                 // bit 1, shadows bit in PORTAbits
#define RA2                     PORTAbits.RA2                   // bit 2, shadows bit in PORTAbits
#define AN2                     PORTAbits.AN2                   // bit 2, shadows bit in PORTAbits
#define CPSA1                   PORTAbits.CPSA1                 // bit 2, shadows bit in PORTAbits
#define DACOUT                  PORTAbits.DACOUT                // bit 2, shadows bit in PORTAbits
#define RA3                     PORTAbits.RA3                   // bit 3, shadows bit in PORTAbits
#define AN3                     PORTAbits.AN3                   // bit 3, shadows bit in PORTAbits
#define CPSA2                   PORTAbits.CPSA2                 // bit 3, shadows bit in PORTAbits
#define RA4                     PORTAbits.RA4                   // bit 4, shadows bit in PORTAbits
#define CPSA3                   PORTAbits.CPSA3                 // bit 4, shadows bit in PORTAbits
#define T0CKI                   PORTAbits.T0CKI                 // bit 4, shadows bit in PORTAbits
#define TACKI                   PORTAbits.TACKI                 // bit 4, shadows bit in PORTAbits
#define RA5                     PORTAbits.RA5                   // bit 5, shadows bit in PORTAbits
#define AN4                     PORTAbits.AN4                   // bit 5, shadows bit in PORTAbits
#define CPSA4                   PORTAbits.CPSA4                 // bit 5, shadows bit in PORTAbits
#define RA6                     PORTAbits.RA6                   // bit 6, shadows bit in PORTAbits
#define OSC2                    PORTAbits.OSC2                  // bit 6, shadows bit in PORTAbits
#define CPSB1                   PORTAbits.CPSB1                 // bit 6, shadows bit in PORTAbits
#define CLKOUT                  PORTAbits.CLKOUT                // bit 6, shadows bit in PORTAbits
#define RA7                     PORTAbits.RA7                   // bit 7, shadows bit in PORTAbits
#define OSC1                    PORTAbits.OSC1                  // bit 7, shadows bit in PORTAbits
#define CPSB0                   PORTAbits.CPSB0                 // bit 7, shadows bit in PORTAbits
#define CLKIN                   PORTAbits.CLKIN                 // bit 7, shadows bit in PORTAbits

#define RB0                     PORTBbits.RB0                   // bit 0, shadows bit in PORTBbits
#define AN12                    PORTBbits.AN12                  // bit 0, shadows bit in PORTBbits
#define CPSB8                   PORTBbits.CPSB8                 // bit 0, shadows bit in PORTBbits
#define RB1                     PORTBbits.RB1                   // bit 1, shadows bit in PORTBbits
#define AN10                    PORTBbits.AN10                  // bit 1, shadows bit in PORTBbits
#define CPSB9                   PORTBbits.CPSB9                 // bit 1, shadows bit in PORTBbits
#define RB2                     PORTBbits.RB2                   // bit 2, shadows bit in PORTBbits
#define AN8                     PORTBbits.AN8                   // bit 2, shadows bit in PORTBbits
#define CPSB10                  PORTBbits.CPSB10                // bit 2, shadows bit in PORTBbits
#define RB3                     PORTBbits.RB3                   // bit 3, shadows bit in PORTBbits
#define AN9                     PORTBbits.AN9                   // bit 3, shadows bit in PORTBbits
#define CPSB11                  PORTBbits.CPSB11                // bit 3, shadows bit in PORTBbits
#define CCP2                    PORTBbits.CCP2                  // bit 3, shadows bit in PORTBbits
#define RB4                     PORTBbits.RB4                   // bit 4, shadows bit in PORTBbits
#define AN11                    PORTBbits.AN11                  // bit 4, shadows bit in PORTBbits
#define CPSB12                  PORTBbits.CPSB12                // bit 4, shadows bit in PORTBbits
#define RB5                     PORTBbits.RB5                   // bit 5, shadows bit in PORTBbits
#define AN13                    PORTBbits.AN13                  // bit 5, shadows bit in PORTBbits
#define CPSB13                  PORTBbits.CPSB13                // bit 5, shadows bit in PORTBbits
#define T1G                     PORTBbits.T1G                   // bit 5, shadows bit in PORTBbits
#define T3CKI                   PORTBbits.T3CKI                 // bit 5, shadows bit in PORTBbits
#define RB6                     PORTBbits.RB6                   // bit 6, shadows bit in PORTBbits
#define CPSB14                  PORTBbits.CPSB14                // bit 6, shadows bit in PORTBbits
#define RB7                     PORTBbits.RB7                   // bit 7, shadows bit in PORTBbits
#define CPSB15                  PORTBbits.CPSB15                // bit 7, shadows bit in PORTBbits

#define RD0                     PORTDbits.RD0                   // bit 0, shadows bit in PORTDbits
#define CPSB5                   PORTDbits.CPSB5                 // bit 0, shadows bit in PORTDbits
#define T3G                     PORTDbits.T3G                   // bit 0, shadows bit in PORTDbits
#define RD1                     PORTDbits.RD1                   // bit 1, shadows bit in PORTDbits
#define CPSB6                   PORTDbits.CPSB6                 // bit 1, shadows bit in PORTDbits
#define RD2                     PORTDbits.RD2                   // bit 2, shadows bit in PORTDbits
#define CPSB7                   PORTDbits.CPSB7                 // bit 2, shadows bit in PORTDbits
#define RD3                     PORTDbits.RD3                   // bit 3, shadows bit in PORTDbits
#define CPSA8                   PORTDbits.CPSA8                 // bit 3, shadows bit in PORTDbits
#define RD4                     PORTDbits.RD4                   // bit 4, shadows bit in PORTDbits
#define CPSA12                  PORTDbits.CPSA12                // bit 4, shadows bit in PORTDbits
#define RD5                     PORTDbits.RD5                   // bit 5, shadows bit in PORTDbits
#define CPSA13                  PORTDbits.CPSA13                // bit 5, shadows bit in PORTDbits
#define RD6                     PORTDbits.RD6                   // bit 6, shadows bit in PORTDbits
#define CPSA14                  PORTDbits.CPSA14                // bit 6, shadows bit in PORTDbits
#define RD7                     PORTDbits.RD7                   // bit 7, shadows bit in PORTDbits
#define CPSA15                  PORTDbits.CPSA15                // bit 7, shadows bit in PORTDbits

#define RE0                     PORTEbits.RE0                   // bit 0, shadows bit in PORTEbits
#define AN5                     PORTEbits.AN5                   // bit 0, shadows bit in PORTEbits
#define CPSA5                   PORTEbits.CPSA5                 // bit 0, shadows bit in PORTEbits
#define RE1                     PORTEbits.RE1                   // bit 1, shadows bit in PORTEbits
#define AN6                     PORTEbits.AN6                   // bit 1, shadows bit in PORTEbits
#define CPSA6                   PORTEbits.CPSA6                 // bit 1, shadows bit in PORTEbits
#define RE2                     PORTEbits.RE2                   // bit 2, shadows bit in PORTEbits
#define AN7                     PORTEbits.AN7                   // bit 2, shadows bit in PORTEbits
#define CPSA7                   PORTEbits.CPSA7                 // bit 2, shadows bit in PORTEbits
#define RE3                     PORTEbits.RE3                   // bit 3, shadows bit in PORTEbits
#define NOT_MCLR                PORTEbits.NOT_MCLR              // bit 3, shadows bit in PORTEbits

#define RX9D                    RCSTAbits.RX9D                  // bit 0
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define ADDEN                   RCSTAbits.ADDEN                 // bit 3
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define SSPM0                   SSPCONbits.SSPM0                // bit 0
#define SSPM1                   SSPCONbits.SSPM1                // bit 1
#define SSPM2                   SSPCONbits.SSPM2                // bit 2
#define SSPM3                   SSPCONbits.SSPM3                // bit 3
#define CKP                     SSPCONbits.CKP                  // bit 4
#define SSPEN                   SSPCONbits.SSPEN                // bit 5
#define SSPOV                   SSPCONbits.SSPOV                // bit 6
#define WCOL                    SSPCONbits.WCOL                 // bit 7

#define BF                      SSPSTATbits.BF                  // bit 0
#define UA                      SSPSTATbits.UA                  // bit 1
#define R_NOT_W                 SSPSTATbits.R_NOT_W             // bit 2
#define S                       SSPSTATbits.S                   // bit 3
#define P                       SSPSTATbits.P                   // bit 4
#define D_NOT_A                 SSPSTATbits.D_NOT_A             // bit 5
#define CKE                     SSPSTATbits.CKE                 // bit 6
#define SMP                     SSPSTATbits.SMP                 // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2, shadows bit in T1CONbits
#define T1SYNC                  T1CONbits.T1SYNC                // bit 2, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMRCS0                  T1CONbits.TMRCS0                // bit 6, shadows bit in T1CONbits
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6, shadows bit in T1CONbits
#define TMRCS1                  T1CONbits.TMRCS1                // bit 7, shadows bit in T1CONbits
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7, shadows bit in T1CONbits

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TMR3ON                  T3CONbits.TMR3ON                // bit 0
#define T3SYNC                  T3CONbits.T3SYNC                // bit 2
#define T3CKPS0                 T3CONbits.T3CKPS0               // bit 4
#define T3CKPS1                 T3CONbits.T3CKPS1               // bit 5
#define TMR3CS0                 T3CONbits.TMR3CS0               // bit 6
#define TMR3CS1                 T3CONbits.TMR3CS1               // bit 7

#define T3GSS0                  T3GCONbits.T3GSS0               // bit 0
#define T3GSS1                  T3GCONbits.T3GSS1               // bit 1
#define T3GVAL                  T3GCONbits.T3GVAL               // bit 2
#define T3GGO_NOT_DONE          T3GCONbits.T3GGO_NOT_DONE       // bit 3
#define T3GSPM                  T3GCONbits.T3GSPM               // bit 4
#define T3GTM                   T3GCONbits.T3GTM                // bit 5
#define T3GPOL                  T3GCONbits.T3GPOL               // bit 6
#define TMR3GE                  T3GCONbits.TMR3GE               // bit 7

#define TAPS0                   TACONbits.TAPS0                 // bit 0, shadows bit in TACONbits
#define TMRAPS0                 TACONbits.TMRAPS0               // bit 0, shadows bit in TACONbits
#define TAPS1                   TACONbits.TAPS1                 // bit 1, shadows bit in TACONbits
#define TMRAPS1                 TACONbits.TMRAPS1               // bit 1, shadows bit in TACONbits
#define TAPS2                   TACONbits.TAPS2                 // bit 2, shadows bit in TACONbits
#define TMRAPS2                 TACONbits.TMRAPS2               // bit 2, shadows bit in TACONbits
#define TAPSA                   TACONbits.TAPSA                 // bit 3, shadows bit in TACONbits
#define TMRAPSA                 TACONbits.TMRAPSA               // bit 3, shadows bit in TACONbits
#define TASE                    TACONbits.TASE                  // bit 4, shadows bit in TACONbits
#define TMRASE                  TACONbits.TMRASE                // bit 4, shadows bit in TACONbits
#define TACS                    TACONbits.TACS                  // bit 5, shadows bit in TACONbits
#define TMRACS                  TACONbits.TMRACS                // bit 5, shadows bit in TACONbits
#define TMRAON                  TACONbits.TMRAON                // bit 7

#define TBPS0                   TBCONbits.TBPS0                 // bit 0, shadows bit in TBCONbits
#define TMRBPS0                 TBCONbits.TMRBPS0               // bit 0, shadows bit in TBCONbits
#define TBPS1                   TBCONbits.TBPS1                 // bit 1, shadows bit in TBCONbits
#define TMRBPS1                 TBCONbits.TMRBPS1               // bit 1, shadows bit in TBCONbits
#define TBPS2                   TBCONbits.TBPS2                 // bit 2, shadows bit in TBCONbits
#define TMRBPS2                 TBCONbits.TMRBPS2               // bit 2, shadows bit in TBCONbits
#define TBPSA                   TBCONbits.TBPSA                 // bit 3, shadows bit in TBCONbits
#define TMRBPSA                 TBCONbits.TMRBPSA               // bit 3, shadows bit in TBCONbits
#define TBSE                    TBCONbits.TBSE                  // bit 4, shadows bit in TBCONbits
#define TMRBSE                  TBCONbits.TMRBSE                // bit 4, shadows bit in TBCONbits
#define TBCS                    TBCONbits.TBCS                  // bit 5, shadows bit in TBCONbits
#define TMRBCS                  TBCONbits.TMRBCS                // bit 5, shadows bit in TBCONbits
#define TMRBON                  TBCONbits.TMRBON                // bit 7

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define TRISE3                  TRISEbits.TRISE3                // bit 3

#define TX9D                    TXSTAbits.TX9D                  // bit 0
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F707_H__
