/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    public Rectangle(Double x, Double y, Double width, Double height) {
        this((int)Math.round(x), (int)Math.round(y), (int)Math.round(width), (int)Math.round(height));
    }

    public Rectangle(int x, int y, int width, int height) {
        this();
        this.setBounds(x, y, width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getX2() {
        return this.x + this.width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public int getY2() {
        return this.y + this.height;
    }

    public PointDouble getUpperLeftCorner() {
        return new PointDouble(this.x, this.y);
    }

    public PointDouble getCenter() {
        return new PointDouble(this.x + this.width / 2, this.y + this.height / 2);
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void move(int diffX, int diffY) {
        this.x += diffX;
        this.y += diffY;
    }

    public void addBorder(int border) {
        this.x -= border;
        this.y -= border;
        this.width += border * 2;
        this.height += border * 2;
    }

    public boolean contains(Point p) {
        return this.contains(new Rectangle(p.getX(), p.getY(), 0, 0));
    }

    public boolean contains(Rectangle other) {
        return this.getX() <= other.getX() && this.getX2() >= other.getX2() && this.getY() <= other.getY() && this.getY2() >= other.getY2();
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean intersects(Rectangle other) {
        if (this.getY2() < other.getY()) {
            return false;
        }
        if (this.getY() > other.getY2()) {
            return false;
        }
        if (this.getX2() < other.getX()) {
            return false;
        }
        return this.getX() <= other.getX2();
    }

    public void merge(Rectangle other) {
        int oldX2 = this.getX2();
        int oldY2 = this.getY2();
        this.setX(Math.min(this.getX(), other.getX()));
        this.setY(Math.min(this.getY(), other.getY()));
        this.setWidth(Math.max(oldX2, other.getX2()) - this.getX());
        this.setHeight(Math.max(oldY2, other.getY2()) - this.getY());
    }

    public Rectangle copy() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle copyInverted() {
        return new Rectangle(-this.x, -this.y, -this.width, -this.height);
    }

    public Rectangle subtract(Rectangle other) {
        return new Rectangle(this.x - other.x, this.y - other.y, this.width - other.width, this.height - other.height);
    }

    public Rectangle add(Rectangle other) {
        return new Rectangle(this.x + other.x, this.y + other.y, this.width + other.width, this.height + other.height);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return "Rectangle [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

